/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.field.expression.handler;

import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.SafeLdapFilterConstraints;
import com.liferay.portal.security.ldap.SafeLdapFilterFactory;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import com.liferay.portal.security.ldap.SafePortalLDAP;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import com.liferay.saml.opensaml.integration.field.expression.handler.UserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.internal.field.expression.handler.DefaultUserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.processor.context.ProcessorContext;
import com.liferay.saml.opensaml.integration.processor.context.UserProcessorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"display.index:Integer=100", "prefix=expando", "processing.index:Integer=100"}, service={UserFieldExpressionHandler.class})
public class ExpandoUserFieldExpressionHandler
implements UserFieldExpressionHandler {
    private static final Log _log = LogFactoryUtil.getLog(ExpandoUserFieldExpressionHandler.class);
    private static final HashMap<Integer, ValueConsumer<String[]>> _valueConsumers = HashMapBuilder.put((Object)1, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getBoolean((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setBoolean)).put((Object)2, ExpandoUserFieldExpressionHandler._getValueConsumer(GetterUtil::getBooleanValues, ExpandoValue::setBooleanArray)).put((Object)5, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getDouble((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setDouble)).put((Object)6, ExpandoUserFieldExpressionHandler._getValueConsumer(GetterUtil::getDoubleValues, ExpandoValue::setDoubleArray)).put((Object)7, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> Float.valueOf(GetterUtil.getFloat((String)ExpandoUserFieldExpressionHandler._head(values))), ExpandoValue::setFloat)).put((Object)8, ExpandoUserFieldExpressionHandler._getValueConsumer(GetterUtil::getLongValues, ExpandoValue::setLongArray)).put((Object)9, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getIntegerStrict((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setInteger)).put((Object)10, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> {
        if (values == null) {
            return null;
        }
        int[] valuesIntArray = new int[((String[])values).length];
        for (int i = 0; i < valuesIntArray.length; ++i) {
            valuesIntArray[i] = GetterUtil.getIntegerStrict((String)values[i]);
        }
        return valuesIntArray;
    }, ExpandoValue::setIntegerArray)).put((Object)11, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getLongStrict((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setLong)).put((Object)12, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> {
        if (values == null) {
            return null;
        }
        long[] valuesLongArray = new long[((String[])values).length];
        for (int i = 0; i < valuesLongArray.length; ++i) {
            valuesLongArray[i] = GetterUtil.getLongStrict((String)values[i]);
        }
        return valuesLongArray;
    }, ExpandoValue::setLongArray)).put((Object)17, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getNumber((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setNumber)).put((Object)18, ExpandoUserFieldExpressionHandler._getValueConsumer(GetterUtil::getNumberValues, ExpandoValue::setNumberArray)).put((Object)13, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> GetterUtil.getShortStrict((String)ExpandoUserFieldExpressionHandler._head(values)), ExpandoValue::setShort)).put((Object)14, ExpandoUserFieldExpressionHandler._getValueConsumer(values -> {
        if (values == null) {
            return null;
        }
        short[] shortValues = new short[((String[])values).length];
        for (int i = 0; i < ((String[])values).length; ++i) {
            shortValues[i] = GetterUtil.getShortStrict((String)values[i]);
        }
        return shortValues;
    }, ExpandoValue::setShortArray)).put((Object)15, ExpandoUserFieldExpressionHandler._getValueConsumer(ExpandoUserFieldExpressionHandler::_head, ExpandoValue::setString)).put((Object)16, ExpandoUserFieldExpressionHandler._getValueConsumer(Function.identity(), ExpandoValue::setStringArray)).build();
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private LDAPFilterValidator _ldapFilterValidator;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference
    private LDAPUserImporter _ldapUserImporter;
    private int _processingIndex;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SafePortalLDAP _safePortalLDAP;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void bindProcessorContext(UserProcessorContext userProcessorContext) {
        for (String validFieldExpression : this.getValidFieldExpressions()) {
            if (Validator.isBlank((String)userProcessorContext.getValue(String.class, validFieldExpression))) continue;
            ProcessorContext.Bind userBind = userProcessorContext.bind(user -> this._getExpandoValue((User)user, validFieldExpression), this._processingIndex, validFieldExpression, this::_update);
            userBind.handleUnsafeStringArray(validFieldExpression, (expandoValue, values) -> {
                ExpandoColumn expandoColumn = expandoValue.getColumn();
                try {
                    this._setExpandoValueData((ExpandoValue)expandoValue, _valueConsumers.get(expandoColumn.getType()), (String[])values);
                }
                catch (Exception exception) {
                    if (exception instanceof PortalException) {
                        throw exception;
                    }
                    throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to set value for expando column ", validFieldExpression, ": ", exception.getMessage()}), (Throwable)exception);
                }
            });
        }
    }

    @Override
    public User getLdapUser(long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        userIdentifier = this._getNormalizedData(companyId, userIdentifierExpression, userIdentifier);
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            String providerUrl = ldapServerConfiguration.baseProviderURL();
            if (Validator.isNull((String)providerUrl)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No provider URL defined in " + ldapServerConfiguration));
                continue;
            }
            User user = this._getLdapUser(ldapServerConfiguration.ldapServerId(), companyId, userIdentifier, userIdentifierExpression);
            if (user == null) continue;
            return user;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"User with the expando field ", userIdentifierExpression, "=", userIdentifier, " was not found in any LDAP servers"}));
        }
        return null;
    }

    @Override
    public String getSectionLabel(Locale locale) {
        return ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DefaultUserFieldExpressionHandler.class), (String)"user-custom-fields");
    }

    @Override
    public User getUser(long companyId, String userIdentifier, String userIdentifierExpression) throws PortalException {
        if (userIdentifier == null) {
            return null;
        }
        List expandoValues = this._expandoValueLocalService.getColumnValues(companyId, User.class.getName(), "CUSTOM_FIELDS", userIdentifierExpression, this._getNormalizedData(companyId, userIdentifierExpression, userIdentifier), -1, -1);
        if (expandoValues.size() > 1) {
            ArrayList userIds = new ArrayList();
            expandoValues.forEach(expandoValue -> userIds.add(expandoValue.getClassPK()));
            throw new PortalException(StringBundler.concat((Object[])new Object[]{"User expando column \"", userIdentifierExpression, "\" and value \"", userIdentifier, "\" must match only 1 user, but it matched ", userIds}));
        }
        for (ExpandoValue expandoValue2 : expandoValues) {
            User user = this._userLocalService.fetchUserById(expandoValue2.getClassPK());
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Override
    public List<String> getValidFieldExpressions() {
        ArrayList<String> validExpressions = new ArrayList<String>();
        Set<Integer> types = _valueConsumers.keySet();
        for (ExpandoColumn column : this._expandoColumnLocalService.getDefaultTableColumns(CompanyThreadLocal.getCompanyId().longValue(), User.class.getName())) {
            if (!types.contains(column.getType())) continue;
            validExpressions.add(column.getName());
        }
        return Collections.unmodifiableList(validExpressions);
    }

    @Override
    public boolean isSupportedForUserMatching(String userIdentifier) {
        return true;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._processingIndex = GetterUtil.getInteger((Object)properties.get("processing.index"));
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    private static <V> ValueConsumer<String[]> _getValueConsumer(Function<String[], V> function, ValueConsumer<V> valueConsumer) {
        return (expandoValue, value) -> valueConsumer.accept(expandoValue, function.apply((String[])value));
    }

    private static <V> V _head(V[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private ExpandoValue _getExpandoValue(User user, String validUserFieldExpression) {
        ExpandoValue expandoValue = null;
        if (!user.isNew()) {
            expandoValue = this._expandoValueLocalService.getValue(user.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS", validUserFieldExpression, user.getUserId());
        }
        if (expandoValue == null) {
            ExpandoTable table = null;
            try {
                table = this._expandoTableLocalService.getTable(user.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS");
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
            ExpandoColumn column = this._expandoColumnLocalService.getColumn(table.getTableId(), validUserFieldExpression);
            expandoValue = this._expandoValueLocalService.createExpandoValue(0L);
            expandoValue.setCompanyId(user.getCompanyId());
            expandoValue.setClassName(User.class.getName());
            expandoValue.setColumnId(column.getColumnId());
            expandoValue.setClassPK(user.getUserId());
        }
        return expandoValue;
    }

    private User _getLdapUser(long ldapServerId, long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
        String attributeName = GetterUtil.getString((String)userExpandoMappings.getProperty(userIdentifierExpression));
        if (Validator.isBlank((String)attributeName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"User expando field ", userIdentifierExpression, " is not mapped for LDAP server ", ldapServerId}));
            }
            return null;
        }
        SafeLdapContext safeLdapContext = null;
        NamingEnumeration enumeration = null;
        try {
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
            if (safeLdapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
                }
                User user = null;
                return user;
            }
            SafeLdapFilter safeLdapFilter = null;
            try {
                safeLdapFilter = SafeLdapFilterFactory.fromUnsafeFilter((String)ldapServerConfiguration.userSearchFilter(), (LDAPFilterValidator)this._ldapFilterValidator);
            }
            catch (LDAPFilterException ldapFilterException) {
                throw new LDAPFilterException("Invalid user search filter: ", (Throwable)ldapFilterException);
            }
            safeLdapFilter = safeLdapFilter.and(new SafeLdapFilter[]{SafeLdapFilterConstraints.eq((String)attributeName, (Object)userIdentifier)});
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName"));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enumeration = safeLdapContext.search(LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), safeLdapFilter, searchControls);
            if (enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enumeration.nextElement();
                Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)binding));
                User user = this._ldapUserImporter.importUser(ldapServerId, companyId, safeLdapContext, attributes, null);
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + exception.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new SystemException("Problem accessing LDAP server " + exception.getMessage());
        }
        finally {
            if (enumeration != null) {
                enumeration.close();
            }
            if (safeLdapContext != null) {
                safeLdapContext.close();
            }
        }
    }

    private String _getNormalizedData(long companyId, String columnName, String ... values) throws PortalException {
        ExpandoValue expandoValue = this._expandoValueLocalService.createExpandoValue(0L);
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(companyId, User.class.getName(), "CUSTOM_FIELDS", columnName);
        expandoValue.setColumnId(expandoColumn.getColumnId());
        this._setExpandoValueData(expandoValue, _valueConsumers.get(expandoColumn.getType()), values);
        return expandoValue.getData();
    }

    private void _setExpandoValueData(ExpandoValue expandoValue, ValueConsumer<String[]> valueConsumer, String[] values) throws PortalException {
        if (valueConsumer == null) {
            ExpandoColumn expandoColumn = expandoValue.getColumn();
            throw new ValueDataException.UnsupportedColumnType(expandoColumn.getColumnId(), ExpandoColumnConstants.getTypeLabel((int)expandoColumn.getType()));
        }
        valueConsumer.accept(expandoValue, values);
    }

    private ExpandoValue _update(ExpandoValue currentExpandoValue, ExpandoValue newExpandoValue, ServiceContext serviceContext) throws PortalException {
        if (!newExpandoValue.isNew()) {
            return this._expandoValueLocalService.updateExpandoValue(newExpandoValue);
        }
        ExpandoColumn column = this._expandoColumnLocalService.getColumn(newExpandoValue.getColumnId());
        return this._expandoValueLocalService.addValue(newExpandoValue.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS", column.getName(), newExpandoValue.getClassPK(), (Object)newExpandoValue.getData());
    }

    @FunctionalInterface
    public static interface ValueConsumer<T> {
        public void accept(ExpandoValue var1, T var2) throws PortalException;
    }
}

