/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.binding;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.saml.opensaml.integration.internal.binding.HttpPostBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpRedirectBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpSoap11Binding;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.velocity.VelocityEngineFactory;
import com.liferay.saml.runtime.SamlException;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.client.HttpClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SamlBindingProvider.class})
public class SamlBindingProvider {
    @Reference
    private HttpClient _httpClient;
    @Reference
    private ParserPool _parserPool;
    private final Map<String, SamlBinding> _samlBindings = new HashMap<String, SamlBinding>();
    @Reference
    private VelocityEngineFactory _velocityEngineFactory;

    public SamlBinding getSamlBinding(String communicationProfileId) throws PortalException {
        SamlBinding samlBinding = this._samlBindings.get(communicationProfileId);
        if (samlBinding != null) {
            return samlBinding;
        }
        throw new SamlException("Unsupported SAML binding " + communicationProfileId);
    }

    @Activate
    protected void activate() {
        HttpPostBinding httpPostBinding = new HttpPostBinding(this._parserPool, this._velocityEngineFactory.getVelocityEngine());
        this._samlBindings.put(httpPostBinding.getCommunicationProfileId(), httpPostBinding);
        HttpRedirectBinding httpRedirectBinding = new HttpRedirectBinding(this._parserPool);
        this._samlBindings.put(httpRedirectBinding.getCommunicationProfileId(), httpRedirectBinding);
        HttpSoap11Binding httpSoap11Binding = new HttpSoap11Binding(this._parserPool, this._httpClient);
        this._samlBindings.put(httpSoap11Binding.getCommunicationProfileId(), httpSoap11Binding);
    }
}

