/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.servlet.profile;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBindingProvider;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.IdentifierGenerationStrategyFactory;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlSpSessionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.util.function.Supplier;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseProfile {
    @Reference
    protected IdentifierGenerationStrategyFactory identifierGenerationStrategyFactory;
    @Reference
    protected MetadataManager metadataManager;
    @Reference
    protected Portal portal;
    @Reference
    protected SamlBindingProvider samlBindingProvider;
    @Reference
    protected SamlProviderConfigurationHelper samlProviderConfigurationHelper;
    @Reference
    protected SamlSpSessionLocalService samlSpSessionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseProfile.class);

    public MessageContext<?> decodeSamlMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlBinding samlBinding, boolean requireSignature) throws Exception {
        MessageContext<SAMLObject> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse);
        Supplier<HttpServletRequestMessageDecoder> messageDecoderSupplier = samlBinding.getHttpServletRequestMessageDecoderSupplier();
        HttpServletRequestMessageDecoder httpServletRequestMessageDecoder = messageDecoderSupplier.get();
        httpServletRequestMessageDecoder.setHttpServletRequest(httpServletRequest);
        httpServletRequestMessageDecoder.initialize();
        httpServletRequestMessageDecoder.decode();
        MessageContext inboundMessageContext = httpServletRequestMessageDecoder.getMessageContext();
        InOutOperationContext inOutOperationContext = new InOutOperationContext(inboundMessageContext, new MessageContext());
        messageContext.addSubcontext((BaseContext)inOutOperationContext);
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)inboundMessageContext.getSubcontext(SAMLBindingContext.class);
        messageContext.addSubcontext((BaseContext)samlBindingContext);
        if (_log.isDebugEnabled()) {
            SAMLObject samlObject = (SAMLObject)inboundMessageContext.getMessage();
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Received message using binding ", samlBindingContext.getBindingUri(), " ", OpenSamlUtil.marshall((XMLObject)samlObject)}));
        }
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)inboundMessageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        MetadataResolver metadataResolver = this.metadataManager.getMetadataResolver();
        EntityDescriptor entityDescriptor = (EntityDescriptor)metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(samlPeerEntityContext.getEntityId())}));
        if (entityDescriptor == null) {
            SAMLObject samlObject = (SAMLObject)messageContext.getMessage();
            RequestAbstractType samlRequest = (RequestAbstractType)samlObject;
            throw new SamlException("Unable to resolve metadata for issuer " + samlRequest.getIssuer());
        }
        SPSSODescriptor roleDescriptor = null;
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            samlPeerEntityContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            samlPeerEntityContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        }
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class, true);
        samlMetadataContext.setEntityDescriptor(entityDescriptor);
        samlMetadataContext.setRoleDescriptor((RoleDescriptor)roleDescriptor);
        MessageHandler<?> messageHandler = this.metadataManager.getSecurityMessageHandler(httpServletRequest, samlBindingContext.getBindingUri(), requireSignature);
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)inboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        BasicSignatureValidationParametersResolver basicSignatureValidationParametersResolver = new BasicSignatureValidationParametersResolver();
        SignatureValidationParameters signatureValidationParameters = basicSignatureValidationParametersResolver.resolveSingle(new CriteriaSet(new Criterion[]{new SignatureValidationConfigurationCriterion(new SignatureValidationConfiguration[]{(SignatureValidationConfiguration)ConfigurationService.get(SignatureValidationConfiguration.class)})}));
        signatureValidationParameters.setSignatureTrustEngine(this.metadataManager.getSignatureTrustEngine());
        securityParametersContext.setSignatureValidationParameters(signatureValidationParameters);
        inboundMessageContext.addSubcontext(messageContext.getSubcontext(SAMLProtocolContext.class));
        messageHandler.invoke(inboundMessageContext);
        messageContext.removeSubcontext(SAMLPeerEntityContext.class);
        messageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        return messageContext;
    }

    public String generateIdentifier(int length) {
        IdentifierGenerationStrategyFactory identifierGenerationStrategyFactory = this.getIdentifierGenerationStrategyFactory();
        IdentifierGenerationStrategy identifierGenerationStrategy = identifierGenerationStrategyFactory.create(length);
        return identifierGenerationStrategy.generateIdentifier();
    }

    public IdentifierGenerationStrategyFactory getIdentifierGenerationStrategyFactory() {
        return this.identifierGenerationStrategyFactory;
    }

    public MessageContext<SAMLObject> getMessageContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        MessageContext messageContext = new MessageContext();
        messageContext.setAutoCreateSubcontexts(true);
        IDPSSODescriptor roleDescriptor = null;
        EntityDescriptor entityDescriptor = this.metadataManager.getEntityDescriptor(httpServletRequest);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        SAMLMetadataContext samlSelfMetadataContext = (SAMLMetadataContext)samlSelfEntityContext.getSubcontext(SAMLMetadataContext.class, true);
        samlSelfMetadataContext.setEntityDescriptor(entityDescriptor);
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            samlPeerEntityContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            samlPeerEntityContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        }
        samlSelfEntityContext.setEntityId(entityDescriptor.getEntityID());
        samlSelfMetadataContext.setRoleDescriptor((RoleDescriptor)roleDescriptor);
        return messageContext;
    }

    public MessageContext<?> getMessageContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String peerEntityId) throws Exception {
        MessageContext<SAMLObject> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        samlPeerEntityContext.setEntityId(peerEntityId);
        MetadataResolver metadataResolver = this.metadataManager.getMetadataResolver();
        EntityDescriptor entityDescriptor = (EntityDescriptor)metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(peerEntityId)}));
        if (entityDescriptor == null) {
            throw new SamlException("Unknown peer entity ID " + peerEntityId);
        }
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class, true);
        samlPeerMetadataContext.setEntityDescriptor(entityDescriptor);
        SPSSODescriptor roleDescriptor = null;
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        samlPeerMetadataContext.setRoleDescriptor((RoleDescriptor)roleDescriptor);
        return messageContext;
    }

    public SamlSpSession getSamlSpSession(HttpServletRequest httpServletRequest) {
        SamlSpSession samlSpSession;
        String samlSpSessionKey = this.getSamlSpSessionKey(httpServletRequest);
        if (Validator.isNotNull((String)samlSpSessionKey) && (samlSpSession = this.samlSpSessionLocalService.fetchSamlSpSessionBySamlSpSessionKey(samlSpSessionKey)) != null) {
            return samlSpSession;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        return this.samlSpSessionLocalService.fetchSamlSpSessionByJSessionId(httpSession.getId());
    }

    public String getSamlSpSessionKey(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String samlSpSessionKey = (String)httpSession.getAttribute("SAML_SP_SESSION_KEY");
        if (Validator.isNull((String)samlSpSessionKey)) {
            samlSpSessionKey = CookiesManagerUtil.getCookieValue((String)"SAML_SP_SESSION_KEY", (HttpServletRequest)httpServletRequest);
        }
        return samlSpSessionKey;
    }

    public String getSamlSsoSessionId(HttpServletRequest httpServletRequest) {
        return CookiesManagerUtil.getCookieValue((String)"SAML_SSO_SESSION_ID", (HttpServletRequest)httpServletRequest);
    }

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block3: {
            String domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest);
            CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"COMPANY_ID"});
            CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"ID"});
            CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"PASSWORD"});
            CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"REMEMBER_ME"});
            boolean rememberMe = GetterUtil.getBoolean((String)CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME", (HttpServletRequest)httpServletRequest));
            if (!rememberMe) {
                CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"LOGIN"});
            }
            HttpSession httpSession = httpServletRequest.getSession();
            try {
                httpSession.invalidate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
    }

    public void sendSamlMessage(MessageContext<?> messageContext, HttpServletResponse httpServletResponse) throws PortalException {
        SamlBinding samlBinding;
        Endpoint endpoint;
        MessageContext outboundMessageContext;
        block5: {
            InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
            outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)outboundMessageContext.getSubcontext(SAMLPeerEntityContext.class);
            SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class);
            endpoint = samlPeerEndpointContext.getEndpoint();
            samlBinding = this.samlBindingProvider.getSamlBinding(endpoint.getBinding());
            if (_log.isDebugEnabled()) {
                try {
                    XMLObject xmlObject = (XMLObject)outboundMessageContext.getMessage();
                    String samlMessage = OpenSamlUtil.marshall(xmlObject);
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Sending SAML message ", samlMessage, " to ", endpoint.getLocation(), " with binding ", endpoint.getBinding()}));
                }
                catch (MarshallingException marshallingException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)marshallingException);
                }
            }
        }
        Supplier<HttpServletResponseMessageEncoder> messageEncoderSupplier = samlBinding.getHttpServletResponseMessageEncoderSupplier();
        HttpServletResponseMessageEncoder httpServletResponseMessageEncoder = messageEncoderSupplier.get();
        SAMLOutboundProtocolMessageSigningHandler samlOutboundProtocolMessageSigningHandler = new SAMLOutboundProtocolMessageSigningHandler();
        try {
            samlOutboundProtocolMessageSigningHandler.initialize();
            samlOutboundProtocolMessageSigningHandler.invoke(outboundMessageContext);
            httpServletResponseMessageEncoder.setHttpServletResponse(httpServletResponse);
            httpServletResponseMessageEncoder.setMessageContext(outboundMessageContext);
            httpServletResponseMessageEncoder.initialize();
            httpServletResponseMessageEncoder.encode();
        }
        catch (Exception exception) {
            throw new SamlException(StringBundler.concat((String[])new String[]{"Unable to send SAML message to ", endpoint.getLocation(), " with binding ", endpoint.getBinding()}), (Throwable)exception);
        }
    }

    protected void addNonpersistentCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String cookieName, String cookieValue) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(-1);
        if (Validator.isNull((String)this.portal.getPathContext())) {
            cookie.setPath("/");
        } else {
            cookie.setPath(this.portal.getPathContext());
        }
        CookiesManagerUtil.addCookie((int)1, (Cookie)cookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (boolean)httpServletRequest.isSecure());
    }
}

