/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupModel;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={AttributeResolver.class})
public class DefaultAttributeResolver
implements AttributeResolver {
    private static final String _SALESFORCE_ENTITY_ID = "https://saml.salesforce.com";
    private static final Log _log = LogFactoryUtil.getLog(DefaultAttributeResolver.class);
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private MetadataManager _metadataManager;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    @Override
    public void resolve(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher) {
        String entityId = attributeResolverSAMLContext.resolvePeerEntityId();
        boolean namespaceEnabled = this._metadataManager.isAttributesNamespaceEnabled(entityId);
        for (String attributeName : this.getAttributeNames(entityId)) {
            if (attributeName.startsWith("expando:")) {
                attributeName = attributeName.substring(8);
                this._addExpandoAttribute(user, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("groups")) {
                this._addGroupsAttribute(user, attributePublisher, namespaceEnabled);
                continue;
            }
            if (attributeName.startsWith("map:")) {
                attributeName = attributeName.substring(4);
                this._addMapAttribute(user, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizations")) {
                this._addOrganizationsAttribute(user, attributePublisher, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizationRoles")) {
                this._addOrganizationRolesAttribute(user, attributePublisher, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("roles")) {
                this._addRolesAttribute(user, attributePublisher, namespaceEnabled);
                continue;
            }
            if (attributeName.startsWith("static:")) {
                attributeName = attributeName.substring(7);
                this._addStaticAttribute(attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("siteRoles") || attributeName.equals("userGroupRoles")) {
                this._addSiteRolesAttribute(user, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("userGroups")) {
                this._addUserGroupsAttribute(user, attributePublisher, namespaceEnabled);
                continue;
            }
            this._addUserAttribute(user, attributePublisher, attributeName, namespaceEnabled);
        }
        if (this._isPeerSalesForce(entityId)) {
            this._addSalesForceAttributes(attributeResolverSAMLContext, attributePublisher);
        }
    }

    protected String[] getAttributeNames(String entityId) {
        return this._metadataManager.getAttributeNames(entityId);
    }

    private void _addExpandoAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        ExpandoBridge expandoBridge = user.getExpandoBridge();
        Object value = expandoBridge.getAttribute(attributeName, false);
        if (value == null) {
            value = "";
        }
        if (!namespaceEnabled) {
            attributePublisher.publish(attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(value.toString()));
        } else {
            attributePublisher.publish("urn:liferay:user:expando:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(value.toString()));
        }
    }

    private void _addGroupsAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, boolean namespaceEnabled) {
        try {
            List groups = user.getGroups();
            if (groups.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:groups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "groups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream groupsStream = groups.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])groupsStream.map(GroupModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get groups for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _addMapAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        if (attributeName.indexOf("=") <= 0) {
            return;
        }
        String[] values = StringUtil.split((String)attributeName, (String)"=");
        if (values.length > 2) {
            return;
        }
        String attributeValue = this._beanProperties.getString((Object)user, values[1]);
        if (namespaceEnabled) {
            attributePublisher.publish(values[0], "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(attributeValue));
        } else {
            attributePublisher.publish(values[0], "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(attributeValue));
        }
    }

    private void _addOrganizationRolesAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, boolean namespaceEnabled) {
        try {
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, Set> groupRoles = new HashMap<String, Set>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() != 3) continue;
                Group group = userGroupRole.getGroup();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(userGroupRole.getRole());
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                String name = null;
                String nameFormat = null;
                if (namespaceEnabled) {
                    name = "urn:liferay:organizationRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
                } else {
                    name = "organizationRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
                }
                Set roles = (Set)entry.getValue();
                Stream rolesStream = roles.stream();
                attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])rolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
            }
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get organization roles for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _addOrganizationsAttribute(User user, AttributeResolver.AttributePublisher publisher, boolean namespaceEnabled) {
        try {
            List organizations = user.getOrganizations();
            if (organizations.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:organizations";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "organizations";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream organizationsStream = organizations.stream();
            publisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])organizationsStream.map(OrganizationModel::getName).map(publisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get organizations for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _addRolesAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, boolean namespaceEnabled) {
        try {
            List roles = user.getRoles();
            List groups = user.getGroups();
            List organizations = user.getOrganizations();
            List userGroups = user.getUserGroups();
            List inheritedSiteGroups = this._groupLocalService.getUserGroupsRelatedGroups(userGroups);
            List organizationsRelatedGroups = Collections.emptyList();
            if (!organizations.isEmpty()) {
                organizationsRelatedGroups = this._groupLocalService.getOrganizationsRelatedGroups(organizations);
                for (Group group : organizationsRelatedGroups) {
                    if (inheritedSiteGroups.contains(group)) continue;
                    inheritedSiteGroups.add(group);
                }
            }
            ArrayList allGroups = new ArrayList();
            allGroups.addAll(groups);
            allGroups.addAll(inheritedSiteGroups);
            allGroups.addAll(organizationsRelatedGroups);
            allGroups.addAll(this._groupLocalService.getOrganizationsGroups(organizations));
            allGroups.addAll(this._groupLocalService.getUserGroupsGroups(userGroups));
            HashSet uniqueRoles = new HashSet();
            uniqueRoles.addAll(roles);
            for (Group group : allGroups) {
                if (!this._roleLocalService.hasGroupRoles(group.getGroupId())) continue;
                uniqueRoles.addAll(this._roleLocalService.getGroupRoles(group.getGroupId()));
            }
            if (uniqueRoles.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:roles";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "roles";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream uniqueRolesStream = uniqueRoles.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])uniqueRolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get roles for user  ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _addSalesForceAttributes(AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher) {
        String samlIdpMetadataSalesForceLogoutURL = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.logout.url"));
        attributePublisher.publish("logoutURL", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(samlIdpMetadataSalesForceLogoutURL));
        String samlIdpMetadataSalesForceSsoStartPage = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.sso.start.page"));
        List<String> locations = attributeResolverSAMLContext.resolveSsoServicesLocationForBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        if (!locations.isEmpty()) {
            samlIdpMetadataSalesForceSsoStartPage = locations.get(0);
        }
        attributePublisher.publish("ssoStartPage", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(samlIdpMetadataSalesForceSsoStartPage));
    }

    private void _addSiteRolesAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            Group group;
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, Set> groupRoles = new HashMap<String, Set>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() == 3 && !attributeName.equals("userGroupRoles")) continue;
                group = userGroupRole.getGroup();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(userGroupRole.getRole());
            }
            List inheritedSiteRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByUser(user.getUserId());
            for (UserGroupGroupRole userGroupGroupRole : inheritedSiteRoles) {
                group = userGroupGroupRole.getGroup();
                Role role = userGroupGroupRole.getRole();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(role);
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                String name = null;
                String nameFormat = null;
                if (namespaceEnabled) {
                    name = attributeName.equals("siteRoles") ? "urn:liferay:siteRole:" + groupName : "urn:liferay:userGroupRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
                } else {
                    name = attributeName.equals("siteRoles") ? "siteRole:" + groupName : "userGroupRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
                }
                Set roles = (Set)entry.getValue();
                Stream rolesStream = roles.stream();
                attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])rolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
            }
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get user group roles for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _addStaticAttribute(AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        String attributeValue = "";
        if (attributeName.indexOf(61) > 0) {
            String[] values = StringUtil.split((String)attributeName, (String)"=");
            attributeName = values[0];
            attributeValue = values[1];
            if (values.length > 2) {
                for (int i = 2; i < values.length; ++i) {
                    attributeValue = StringBundler.concat((String[])new String[]{attributeValue, "=", values[i]});
                }
            }
        }
        String nameFormat = null;
        nameFormat = namespaceEnabled ? "urn:oasis:names:tc:SAML:2.0:attrname-format:uri" : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        attributePublisher.publish(attributeName, nameFormat, attributePublisher.buildString(attributeValue));
    }

    private void _addUserAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        Serializable value = (Serializable)this._beanProperties.getObject((Object)user, attributeName);
        if (!namespaceEnabled) {
            attributePublisher.publish(attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(value.toString()));
        } else {
            attributePublisher.publish("urn:liferay:user:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(value.toString()));
        }
    }

    private void _addUserGroupsAttribute(User user, AttributeResolver.AttributePublisher attributePublisher, boolean namespaceEnabled) {
        try {
            List userGroups = user.getUserGroups();
            if (userGroups.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:userGroups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "userGroups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream userGroupsStream = userGroups.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])userGroupsStream.map(UserGroupModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get user groups for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private boolean _isPeerSalesForce(String entityId) {
        if (entityId.equals(_SALESFORCE_ENTITY_ID)) {
            return true;
        }
        return GetterUtil.getBoolean((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.attributes.enabled", (Filter)new Filter(entityId)));
    }
}

