/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.certificate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.runtime.certificate.CertificateEntityId;
import com.liferay.saml.runtime.certificate.CertificateTool;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Optional;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CertificateTool.class})
public class CertificateToolImpl
implements CertificateTool {
    /*
     * Exception decompiling
     */
    public X509Certificate generateCertificate(KeyPair keyPair, CertificateEntityId issuerCertificateEntityId, CertificateEntityId subjectCertificateEntityId, Date startDate, Date endDate, String signatureAlgorithm) throws CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KeyPair generateKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public String getFingerprint(String algorithm, X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(x509Certificate.getEncoded());
        byte[] digest = messageDigest.digest();
        StringBundler sb = new StringBundler(digest.length * 2 - 1);
        for (int i = 0; i < digest.length; ++i) {
            String hex = String.format("%02X", digest[i]);
            sb.append(hex);
            if (i + 1 >= digest.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public String getSerialNumber(X509Certificate x509Certificate) {
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        byte[] bytes = serialNumber.toByteArray();
        StringBundler sb = new StringBundler(bytes.length);
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.toString();
    }

    public Optional<String> getSubjectName(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return Optional.empty();
        }
        Principal principal = x509Certificate.getSubjectDN();
        if (principal != null) {
            return Optional.of(principal.getName());
        }
        return Optional.empty();
    }

    private X500Name _createX500Name(CertificateEntityId certificateEntityId) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        if (Validator.isNotNull((String)certificateEntityId.getCommonName())) {
            x500NameBuilder.addRDN(BCStyle.CN, certificateEntityId.getCommonName());
        }
        if (Validator.isNotNull((String)certificateEntityId.getOrganization())) {
            x500NameBuilder.addRDN(BCStyle.O, certificateEntityId.getOrganization());
        }
        if (Validator.isNotNull((String)certificateEntityId.getOrganizationUnit())) {
            x500NameBuilder.addRDN(BCStyle.OU, certificateEntityId.getOrganizationUnit());
        }
        if (Validator.isNotNull((String)certificateEntityId.getLocality())) {
            x500NameBuilder.addRDN(BCStyle.L, certificateEntityId.getLocality());
        }
        if (Validator.isNotNull((String)certificateEntityId.getState())) {
            x500NameBuilder.addRDN(BCStyle.ST, certificateEntityId.getState());
        }
        if (Validator.isAlphanumericName((String)certificateEntityId.getCountry())) {
            x500NameBuilder.addRDN(BCStyle.C, certificateEntityId.getCountry());
        }
        return x500NameBuilder.build();
    }
}

