/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.servlet.profile;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributePublisherImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverRegistry;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.DecrypterContext;
import com.liferay.saml.opensaml.integration.internal.resolver.NameIdResolverRegistry;
import com.liferay.saml.opensaml.integration.internal.resolver.NameIdResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.SubjectAssertionContext;
import com.liferay.saml.opensaml.integration.internal.resolver.UserResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.BaseProfile;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.ExceptionHandlerUtil;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSsoRequestContext;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlSpAuthRequest;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.model.SamlSpMessage;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSsoSessionLocalService;
import com.liferay.saml.persistence.service.SamlSpAuthRequestLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlSpMessageLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.exception.AssertionException;
import com.liferay.saml.runtime.exception.AudienceException;
import com.liferay.saml.runtime.exception.AuthnAgeException;
import com.liferay.saml.runtime.exception.DestinationException;
import com.liferay.saml.runtime.exception.EntityInteractionException;
import com.liferay.saml.runtime.exception.ExpiredException;
import com.liferay.saml.runtime.exception.InResponseToException;
import com.liferay.saml.runtime.exception.IssuerException;
import com.liferay.saml.runtime.exception.ReplayException;
import com.liferay.saml.runtime.exception.SignatureException;
import com.liferay.saml.runtime.exception.StatusException;
import com.liferay.saml.runtime.exception.SubjectException;
import com.liferay.saml.runtime.servlet.profile.WebSsoProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.NameIDType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.security.impl.SAMLMetadataEncryptionParametersResolver;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={WebSsoProfile.class})
public class WebSsoProfileImpl
extends BaseProfile
implements WebSsoProfile {
    private static final Log _log = LogFactoryUtil.getLog(WebSsoProfileImpl.class);
    private static final SAMLSignatureProfileValidator _samlSignatureProfileValidator = new SAMLSignatureProfileValidator();
    @Reference
    private AttributeResolverRegistry _attributeResolverRegistry;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private Decrypter _decrypter;
    @Reference
    private NameIdResolverRegistry _nameIdResolverRegistry;
    private SamlConfiguration _samlConfiguration;
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    @Reference
    private SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    @Reference
    private SamlIdpSsoSessionLocalService _samlIdpSsoSessionLocalService;
    private SAMLMetadataEncryptionParametersResolver _samlMetadataEncryptionParametersResolver;
    @Reference
    private SamlSpAuthRequestLocalService _samlSpAuthRequestLocalService;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;
    @Reference
    private SamlSpMessageLocalService _samlSpMessageLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserResolver _userResolver;

    public void processAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        try {
            this._processAuthnRequest(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void processResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        MessageContext<?> messageContext = null;
        try {
            messageContext = this._decodeAuthnResponse(httpServletRequest, httpServletResponse, this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"));
            this._processResponse(messageContext, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            SAMLPeerEntityContext samlPeerEntityContext;
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            } else if (!(exception instanceof AuthnAgeException) && !(exception instanceof SubjectException)) {
                _log.error((Throwable)exception);
            }
            if (messageContext != null && (samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class)) != null) {
                String nameIdValue = Optional.ofNullable(messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class)).map(SAMLSubjectNameIdentifierContext::getSAML2SubjectNameID).map(NameIDType::getValue).orElse(null);
                throw new EntityInteractionException(samlPeerEntityContext.getEntityId(), nameIdValue, (Throwable)exception);
            }
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void sendAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String relayState) throws PortalException {
        try {
            this.doSendAuthnRequest(httpServletRequest, httpServletResponse, relayState);
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void updateSamlSpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block3: {
            SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
            HttpSession httpSession = httpServletRequest.getSession();
            String jSessionId = httpSession.getId();
            if (samlSpSession != null && !jSessionId.equals(samlSpSession.getJSessionId())) {
                try {
                    this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession.getPrimaryKey(), jSessionId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)exception);
                }
            }
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._samlConfiguration = (SamlConfiguration)ConfigurableUtil.createConfigurable(SamlConfiguration.class, properties);
        this._samlMetadataEncryptionParametersResolver = new SAMLMetadataEncryptionParametersResolver(this.metadataManager.getMetadataCredentialResolver());
        this._samlMetadataEncryptionParametersResolver.setAutoGenerateDataEncryptionCredential(true);
    }

    protected SamlSsoRequestContext decodeAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SamlSsoRequestContext samlSsoRequestContext;
        SamlSsoRequestContext samlSsoRequestContext2;
        String samlMessageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"saml_message_id");
        if (!Validator.isBlank((String)samlMessageId) && (samlSsoRequestContext2 = this._decodeAuthnConversationAfterLogin(httpServletRequest, httpServletResponse)) != null) {
            MessageContext<?> messageContext = samlSsoRequestContext2.getSAMLMessageContext();
            InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
            MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
            SAMLMessageInfoContext samlMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class, true);
            if (messageContext != null && samlMessageId.equals(samlMessageInfoContext.getMessageId())) {
                return samlSsoRequestContext2;
            }
        }
        boolean idpInitiatedSSO = false;
        String entityId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"entityId");
        String samlRequest = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"SAMLRequest");
        if (Validator.isNotNull((String)entityId) && Validator.isNull((String)samlRequest)) {
            idpInitiatedSSO = true;
        }
        if (idpInitiatedSSO && (samlSsoRequestContext = this._decodeAuthnConversationAfterLogin(httpServletRequest, httpServletResponse)) != null) {
            MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            if (messageContext != null && entityId.equals(samlPeerEntityContext.getEntityId())) {
                return samlSsoRequestContext;
            }
        }
        MessageContext<?> messageContext = null;
        SamlBinding samlBinding = null;
        samlBinding = StringUtil.equalsIgnoreCase((String)httpServletRequest.getMethod(), (String)"GET") ? this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") : this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SamlSsoRequestContext samlSsoRequestContext3 = null;
        if (idpInitiatedSSO) {
            messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, entityId);
            SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
            samlBindingContext.setBindingUri(samlBinding.getCommunicationProfileId());
            String relayState = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"RelayState");
            samlBindingContext.setRelayState(relayState);
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            samlSsoRequestContext3 = new SamlSsoRequestContext(samlPeerEntityContext.getEntityId(), relayState, messageContext, this._userLocalService);
        } else {
            SamlProviderConfiguration samlProviderConfiguration = this.samlProviderConfigurationHelper.getSamlProviderConfiguration();
            messageContext = this.decodeSamlMessage(httpServletRequest, httpServletResponse, samlBinding, samlProviderConfiguration.authnRequestSignatureRequired());
            InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
            MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
            AuthnRequest authnRequest = (AuthnRequest)inboundMessageContext.getMessage();
            SAMLMessageInfoContext samlMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class, true);
            samlMessageInfoContext.setMessageId(authnRequest.getID());
            String authnRequestXml = OpenSamlUtil.marshall((XMLObject)authnRequest);
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
            samlSsoRequestContext3 = new SamlSsoRequestContext(authnRequestXml, samlPeerEntityContext.getEntityId(), samlBindingContext.getRelayState(), messageContext, this._userLocalService);
        }
        String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
        if (Validator.isNotNull((String)samlSsoSessionId)) {
            samlSsoRequestContext3.setSamlSsoSessionId(samlSsoSessionId);
        } else {
            samlSsoRequestContext3.setNewSession(true);
            samlSsoRequestContext3.setSamlSsoSessionId(this.generateIdentifier(30));
        }
        samlSsoRequestContext3.setStage(0);
        samlSsoRequestContext3.setUserId(this.portal.getUserId(httpServletRequest));
        return samlSsoRequestContext3;
    }

    protected void doSendAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String relayState) throws Exception {
        SamlSpIdpConnection samlSpIdpConnection = (SamlSpIdpConnection)httpServletRequest.getAttribute("SAML_SP_IDP_CONNECTION");
        if (samlSpIdpConnection == null) {
            return;
        }
        String entityId = samlSpIdpConnection.getSamlIdpEntityId();
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, entityId);
        InOutOperationContext inOutOperationContext = new InOutOperationContext(new MessageContext(), new MessageContext());
        messageContext.addSubcontext((BaseContext)inOutOperationContext);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)outboundMessageContext.getSubcontext(SAMLBindingContext.class, true);
        samlBindingContext.setRelayState(relayState);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        SAMLMetadataContext samlSelfMetadataContext = (SAMLMetadataContext)samlSelfEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlSelfMetadataContext.getRoleDescriptor();
        AssertionConsumerService assertionConsumerService = SamlUtil.getAssertionConsumerServiceForBinding(spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        SingleSignOnService singleSignOnService = SamlUtil.resolveSingleSignOnService(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        NameIDPolicy nameIDPolicy = OpenSamlUtil.buildNameIdPolicy();
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setFormat(this.metadataManager.getNameIdFormat(entityId));
        AuthnRequest authnRequest = OpenSamlUtil.buildAuthnRequest(samlSelfEntityContext.getEntityId(), assertionConsumerService, singleSignOnService, nameIDPolicy);
        if (samlSpIdpConnection.isForceAuthn() || GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("FORCE_REAUTHENTICATION"), (boolean)Boolean.FALSE)) {
            authnRequest.setForceAuthn(Boolean.valueOf(true));
        } else {
            authnRequest.setForceAuthn(Boolean.valueOf(false));
        }
        authnRequest.setID(this.generateIdentifier(20));
        outboundMessageContext.setMessage((Object)authnRequest);
        if (spSSODescriptor.isAuthnRequestsSigned().booleanValue() || idpSSODescriptor.getWantAuthnRequestsSigned().booleanValue()) {
            Credential credential = this.metadataManager.getSigningCredential();
            SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
            OpenSamlUtil.prepareSecurityParametersContext(this.metadataManager.getSigningCredential(), securityParametersContext, (RoleDescriptor)idpSSODescriptor);
            OpenSamlUtil.signObject((SignableSAMLObject)authnRequest, credential, (RoleDescriptor)idpSSODescriptor);
        }
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)singleSignOnService);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        this._samlSpAuthRequestLocalService.addSamlSpAuthRequest(samlPeerEntityContext.getEntityId(), authnRequest.getID(), serviceContext);
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    protected AudienceRestriction getSuccessAudienceRestriction(String entityId) {
        AudienceRestriction audienceRestriction = OpenSamlUtil.buildAudienceRestriction();
        List audiences = audienceRestriction.getAudiences();
        Audience audience = OpenSamlUtil.buildAudience();
        audience.setAudienceURI(entityId);
        audiences.add(audience);
        return audienceRestriction;
    }

    protected Conditions getSuccessConditions(SamlSsoRequestContext samlSsoRequestContext, DateTime notBeforeDateTime, DateTime notOnOrAfterDateTime) {
        Conditions conditions = OpenSamlUtil.buildConditions();
        conditions.setNotBefore(notBeforeDateTime);
        conditions.setNotOnOrAfter(notOnOrAfterDateTime);
        List audienceRestrictions = conditions.getAudienceRestrictions();
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        AudienceRestriction audienceRestriction = this.getSuccessAudienceRestriction(samlPeerEntityContext.getEntityId());
        audienceRestrictions.add(audienceRestriction);
        return conditions;
    }

    protected Subject getSuccessSubject(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, NameID nameID, SubjectConfirmationData subjectConfirmationData) {
        SubjectConfirmation subjectConfirmation = OpenSamlUtil.buildSubjectConfirmation();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        Subject subject = OpenSamlUtil.buildSubject(nameID);
        List subjectConfirmations = subject.getSubjectConfirmations();
        subjectConfirmations.add(subjectConfirmation);
        return subject;
    }

    protected SubjectConfirmationData getSuccessSubjectConfirmationData(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, DateTime issueInstantDateTime) {
        SubjectConfirmationData subjectConfirmationData = OpenSamlUtil.buildSubjectConfirmationData();
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
        if (inOutOperationContext != null) {
            MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
            SAMLMessageInfoContext samlMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class);
            subjectConfirmationData.setInResponseTo(samlMessageInfoContext.getMessageId());
        }
        subjectConfirmationData.setRecipient(assertionConsumerService.getLocation());
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        DateTime notOnOrAfterDateTime = issueInstantDateTime.plusSeconds(this.metadataManager.getAssertionLifetime(samlPeerEntityContext.getEntityId()));
        subjectConfirmationData.setNotOnOrAfter(notOnOrAfterDateTime);
        return subjectConfirmationData;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSamlBinding(SamlBinding samlBinding) {
        this.addSamlBinding(samlBinding);
    }

    @Override
    protected void unsetSamlBinding(SamlBinding samlBinding) {
        this.removeSamlBinding(samlBinding);
    }

    protected void verifyAssertionSignature(Signature signature, MessageContext<?> messageContext, TrustEngine<Signature> trustEngine) throws PortalException {
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        SAMLMetadataContext samlSelfMetadataContext = (SAMLMetadataContext)samlSelfEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlSelfMetadataContext.getRoleDescriptor();
        if (signature != null) {
            this._verifySignature(messageContext, signature, trustEngine);
        } else if (spSSODescriptor.getWantAssertionsSigned().booleanValue()) {
            throw new SignatureException("SAML assertion is not signed");
        }
    }

    protected void verifyAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, MessageContext<?> messageContext) throws PortalException {
        if (audienceRestrictions.isEmpty()) {
            return;
        }
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            for (Audience audience : audienceRestriction.getAudiences()) {
                String audienceURI = audience.getAudienceURI();
                if (!audienceURI.equals(samlSelfEntityContext.getEntityId())) continue;
                return;
            }
        }
        throw new AudienceException("Unable verify audience");
    }

    protected void verifyConditions(MessageContext<?> messageContext, Conditions conditions) throws PortalException {
        DateTime notOnOrAfterDateTime;
        this.verifyAudienceRestrictions(conditions.getAudienceRestrictions(), messageContext);
        DateTime nowDateTime = new DateTime(DateTimeZone.UTC);
        DateTime notBeforeDateTime = conditions.getNotBefore();
        if (notBeforeDateTime != null) {
            this.verifyNotBeforeDateTime(nowDateTime, this.metadataManager.getClockSkew(), notBeforeDateTime);
        }
        if ((notOnOrAfterDateTime = conditions.getNotOnOrAfter()) != null) {
            this.verifyNotOnOrAfterDateTime(nowDateTime, this.metadataManager.getClockSkew(), notOnOrAfterDateTime);
        }
    }

    protected void verifyDestination(MessageContext<?> messageContext, String destination) throws PortalException {
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        SAMLMetadataContext samlSelfMetadataContext = (SAMLMetadataContext)samlSelfEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlSelfMetadataContext.getRoleDescriptor();
        List assertionConsumerServices = spSSODescriptor.getAssertionConsumerServices();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        for (AssertionConsumerService assertionConsumerService : assertionConsumerServices) {
            String binding = assertionConsumerService.getBinding();
            if (!destination.equals(assertionConsumerService.getLocation()) || !binding.equals(samlBindingContext.getBindingUri())) continue;
            return;
        }
        throw new DestinationException(StringBundler.concat((String[])new String[]{"Destination ", destination, " does not match any assertion ", "consumer location with binding ", samlBindingContext.getBindingUri()}));
    }

    protected void verifyInResponseTo(Response samlResponse) throws PortalException {
        String inResponseTo;
        if (Validator.isNull((String)samlResponse.getInResponseTo())) {
            return;
        }
        Issuer issuer = samlResponse.getIssuer();
        String issuerEntityId = issuer.getValue();
        SamlSpAuthRequest samlSpAuthRequest = this._samlSpAuthRequestLocalService.fetchSamlSpAuthRequest(issuerEntityId, inResponseTo = samlResponse.getInResponseTo());
        if (samlSpAuthRequest == null) {
            throw new InResponseToException(StringBundler.concat((String[])new String[]{"Response in response to ", inResponseTo, " does not match any authentication requests"}));
        }
        this._samlSpAuthRequestLocalService.deleteSamlSpAuthRequest(samlSpAuthRequest);
    }

    protected void verifyIssuer(MessageContext<?> messageContext, Issuer issuer) throws PortalException {
        String issuerFormat = issuer.getFormat();
        if (issuerFormat != null && !issuerFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new IssuerException("Invalid issuer format " + issuerFormat);
        }
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        String peerEntityId = samlPeerEntityContext.getEntityId();
        if (!peerEntityId.equals(issuer.getValue())) {
            throw new IssuerException("Issuer does not match expected peer entity ID " + peerEntityId);
        }
    }

    protected void verifyNotBeforeDateTime(DateTime nowDateTime, long clockSkew, DateTime dateTime) throws PortalException {
        DateTime lowerBoundDateTime = dateTime.minus(new Duration(clockSkew));
        if (!nowDateTime.isBefore(lowerBoundDateTime)) {
            return;
        }
        throw new AssertionException(StringBundler.concat((Object[])new Object[]{"Date ", nowDateTime.toString(), " is before ", lowerBoundDateTime.toString(), " including clock skew ", clockSkew}));
    }

    protected void verifyNotOnOrAfterDateTime(DateTime nowDateTime, long clockSkew, DateTime dateTime) throws PortalException {
        DateTime upperBoundDateTime = dateTime.plus(new Duration(clockSkew));
        if (!nowDateTime.isEqual(upperBoundDateTime) && !nowDateTime.isAfter(upperBoundDateTime)) {
            return;
        }
        throw new ExpiredException(StringBundler.concat((Object[])new Object[]{"Date ", nowDateTime.toString(), " is after ", upperBoundDateTime.toString(), " including clock skew ", clockSkew}));
    }

    protected void verifyReplay(MessageContext<?> messageContext, Assertion assertion) throws PortalException {
        Issuer issuer = assertion.getIssuer();
        String idpEntityId = issuer.getValue();
        String messageKey = assertion.getID();
        DateTime notOnOrAfterDateTime = new DateTime(DateTimeZone.UTC);
        notOnOrAfterDateTime = notOnOrAfterDateTime.plus((long)this._samlConfiguration.getReplayChacheDuration() + this.metadataManager.getClockSkew());
        try {
            SamlSpMessage samlSpMessage = this._samlSpMessageLocalService.fetchSamlSpMessage(idpEntityId, messageKey);
            if (samlSpMessage != null && !samlSpMessage.isExpired()) {
                throw new ReplayException(StringBundler.concat((String[])new String[]{"SAML assertion ", messageKey, " replayed from IdP ", idpEntityId}));
            }
            if (samlSpMessage != null) {
                this._samlSpMessageLocalService.deleteSamlSpMessage(samlSpMessage);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(CompanyThreadLocal.getCompanyId().longValue());
            this._samlSpMessageLocalService.addSamlSpMessage(idpEntityId, messageKey, notOnOrAfterDateTime.toDate(), serviceContext);
        }
        catch (SystemException systemException) {
            throw new SamlException((Throwable)systemException);
        }
    }

    protected void verifySubject(MessageContext<?> messageContext, Subject subject) throws PortalException {
        List subjectConfirmations = subject.getSubjectConfirmations();
        for (SubjectConfirmation subjectConfirmation : subjectConfirmations) {
            DateTime notOnOrAfterDateTime;
            SubjectConfirmationData subjectConfirmationData;
            String method = subjectConfirmation.getMethod();
            if (!method.equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || (subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData()) == null) continue;
            DateTime nowDateTime = new DateTime(DateTimeZone.UTC);
            long clockSkew = this.metadataManager.getClockSkew();
            DateTime notBeforeDateTime = subjectConfirmationData.getNotBefore();
            if (notBeforeDateTime != null) {
                this.verifyNotBeforeDateTime(nowDateTime, clockSkew, notBeforeDateTime);
            }
            if ((notOnOrAfterDateTime = subjectConfirmationData.getNotOnOrAfter()) != null) {
                this.verifyNotOnOrAfterDateTime(nowDateTime, clockSkew, notOnOrAfterDateTime);
            }
            if (Validator.isNull((String)subjectConfirmationData.getRecipient())) continue;
            this.verifyDestination(messageContext, subjectConfirmationData.getRecipient());
            NameID nameID = subject.getNameID();
            if (Validator.isNull((String)nameID.getValue())) continue;
            SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
            samlSubjectNameIdentifierContext.setSubjectNameIdentifier((SAMLObject)nameID);
            return;
        }
        throw new SubjectException("Unable to verify subject");
    }

    private void _addSamlSsoSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSsoRequestContext samlSsoRequestContext, NameID nameID) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.addSamlIdpSsoSession(samlSsoRequestContext.getSamlSsoSessionId(), serviceContext);
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        this._samlIdpSpSessionLocalService.addSamlIdpSpSession(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlPeerEntityContext.getEntityId(), nameID.getFormat(), nameID.getValue(), serviceContext);
        this.addNonpersistentCookie(httpServletRequest, httpServletResponse, "SAML_SSO_SESSION_ID", samlSsoRequestContext.getSamlSsoSessionId());
    }

    private SamlSsoRequestContext _decodeAuthnConversationAfterLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        SamlSsoRequestContext samlSsoRequestContext = (SamlSsoRequestContext)httpSession.getAttribute("SAML_SSO_REQUEST_CONTEXT");
        if (samlSsoRequestContext != null) {
            httpSession.removeAttribute("SAML_SSO_REQUEST_CONTEXT");
            MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, samlSsoRequestContext.getPeerEntityId());
            samlSsoRequestContext.setSAMLMessageContext(messageContext);
            String authnRequestXml = samlSsoRequestContext.getAuthnRequestXml();
            if (Validator.isNotNull((String)authnRequestXml)) {
                AuthnRequest authnRequest = (AuthnRequest)OpenSamlUtil.unmarshall(authnRequestXml);
                InOutOperationContext inOutOperationContext = new InOutOperationContext(new MessageContext(), new MessageContext());
                messageContext.addSubcontext((BaseContext)inOutOperationContext);
                MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
                inboundMessageContext.setMessage((Object)authnRequest);
                SAMLMessageInfoContext samlInboundMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class, true);
                samlInboundMessageInfoContext.setMessageId(authnRequest.getID());
            }
            String relayState = samlSsoRequestContext.getRelayState();
            SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
            samlBindingContext.setRelayState(relayState);
            String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
            if (Validator.isNotNull((String)samlSsoSessionId)) {
                samlSsoRequestContext.setSamlSsoSessionId(samlSsoSessionId);
            } else {
                samlSsoRequestContext.setNewSession(true);
                samlSsoRequestContext.setSamlSsoSessionId(this.generateIdentifier(30));
            }
            samlSsoRequestContext.setStage(1);
            samlSsoRequestContext.setUserId(this.portal.getUserId(httpServletRequest));
            return samlSsoRequestContext;
        }
        return null;
    }

    private MessageContext<?> _decodeAuthnResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlBinding samlBinding) throws Exception {
        MessageContext<?> messageContext = this.decodeSamlMessage(httpServletRequest, httpServletResponse, samlBinding, true);
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        Response samlResponse = (Response)inboundMessageContext.getMessage();
        List encryptedAssertions = samlResponse.getEncryptedAssertions();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>(samlResponse.getAssertions());
        if (this._decrypter != null) {
            for (EncryptedAssertion encryptedAssertion : encryptedAssertions) {
                try {
                    assertions.add(this._decrypter.decrypt(encryptedAssertion));
                }
                catch (DecryptionException decryptionException) {
                    _log.error((Object)"Unable to assertion decryption", (Throwable)decryptionException);
                }
            }
            inboundMessageContext.addSubcontext((BaseContext)new DecrypterContext(this._decrypter));
        } else if (!encryptedAssertions.isEmpty() && _log.isWarnEnabled()) {
            _log.warn((Object)"Message returned encrypted assertions but there is no decrypter available");
        }
        SignatureTrustEngine signatureTrustEngine = this.metadataManager.getSignatureTrustEngine();
        Assertion assertion = null;
        block5: for (Assertion curAssertion : assertions) {
            Subject subject;
            try {
                this._verifyAssertion(curAssertion, messageContext, (TrustEngine<Signature>)signatureTrustEngine);
            }
            catch (SamlException samlException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Rejecting assertion " + curAssertion.getID()), (Throwable)samlException);
                continue;
            }
            List authnStatements = curAssertion.getAuthnStatements();
            if (authnStatements.isEmpty() || (subject = curAssertion.getSubject()) == null || subject.getSubjectConfirmations() == null) continue;
            for (SubjectConfirmation subjectConfirmation : subject.getSubjectConfirmations()) {
                if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())) continue;
                assertion = curAssertion;
                continue block5;
            }
        }
        if (assertion == null) {
            throw new AssertionException("Response does not contain any acceptable assertions");
        }
        inboundMessageContext.addSubcontext((BaseContext)new SubjectAssertionContext(assertion));
        return messageContext;
    }

    private String _getAuthRedirectURL(MessageContext<?> messageContext, HttpServletRequest httpServletRequest) throws Exception {
        StringBundler sb = new StringBundler(3);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/saml/auth_redirect?redirect=");
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        String relayState = this.portal.escapeRedirect(samlBindingContext.getRelayState());
        if (Validator.isNull((String)relayState)) {
            relayState = this.portal.getHomeURL(httpServletRequest);
        }
        sb.append(URLCodec.encodeURL((String)relayState));
        return sb.toString();
    }

    private Assertion _getSuccessAssertion(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, NameID nameID) {
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        Assertion assertion = OpenSamlUtil.buildAssertion();
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        SubjectConfirmationData subjectConfirmationData = this.getSuccessSubjectConfirmationData(samlSsoRequestContext, assertionConsumerService, issueInstantDateTime);
        assertion.setConditions(this.getSuccessConditions(samlSsoRequestContext, issueInstantDateTime, subjectConfirmationData.getNotOnOrAfter()));
        assertion.setID(this.generateIdentifier(20));
        assertion.setIssueInstant(issueInstantDateTime);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        assertion.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        assertion.setSubject(this.getSuccessSubject(samlSsoRequestContext, assertionConsumerService, nameID, subjectConfirmationData));
        assertion.setVersion(SAMLVersion.VERSION_20);
        List authnStatements = assertion.getAuthnStatements();
        authnStatements.add(this._getSuccessAuthnStatement(samlSsoRequestContext, assertion));
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        boolean attributesEnabled = this.metadataManager.isAttributesEnabled(samlPeerEntityContext.getEntityId());
        if (!attributesEnabled) {
            return assertion;
        }
        User user = samlSsoRequestContext.getUser();
        AttributeResolver attributeResolver = this._attributeResolverRegistry.getAttributeResolver(samlPeerEntityContext.getEntityId());
        AttributePublisherImpl attributePublisherImpl = new AttributePublisherImpl();
        attributeResolver.resolve(user, new AttributeResolverSAMLContextImpl((MessageContext<AuthnRequest>)messageContext), attributePublisherImpl);
        List<Attribute> attributes = attributePublisherImpl.getAttributes();
        if (attributes.isEmpty()) {
            return assertion;
        }
        List attributeStatements = assertion.getAttributeStatements();
        AttributeStatement attributeStatement = OpenSamlUtil.buildAttributeStatement();
        attributeStatements.add(attributeStatement);
        List attributeStatementAttributes = attributeStatement.getAttributes();
        attributeStatementAttributes.addAll(attributes);
        return assertion;
    }

    private AuthnContext _getSuccessAuthnContext() {
        AuthnContext authnContext = OpenSamlUtil.buildAuthnContext();
        AuthnContextClassRef authnContextClassRef = OpenSamlUtil.buildAuthnContextClassRef();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        return authnContext;
    }

    private AuthnStatement _getSuccessAuthnStatement(SamlSsoRequestContext samlSsoRequestContext, Assertion assertion) {
        AuthnStatement authnStatement = OpenSamlUtil.buildAuthnStatement();
        authnStatement.setAuthnContext(this._getSuccessAuthnContext());
        authnStatement.setAuthnInstant(assertion.getIssueInstant());
        authnStatement.setSessionIndex(samlSsoRequestContext.getSamlSsoSessionId());
        return authnStatement;
    }

    private NameID _getSuccessNameId(SamlSsoRequestContext samlSsoRequestContext) throws Exception {
        NameIDPolicy nameIDPolicy;
        String nameIdFormat = null;
        String spNameQualifier = null;
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        NameIdResolver nameIdResolver = this._nameIdResolverRegistry.getNameIdResolver(samlPeerEntityContext.getEntityId());
        boolean allowCreate = false;
        AuthnRequest authnRequest = SamlUtil.getAuthnRequest(messageContext);
        if (authnRequest != null && (nameIDPolicy = authnRequest.getNameIDPolicy()) != null) {
            nameIdFormat = nameIDPolicy.getFormat();
            spNameQualifier = nameIDPolicy.getSPNameQualifier();
            allowCreate = nameIDPolicy.getAllowCreate();
        }
        if (nameIdFormat == null) {
            nameIdFormat = this.metadataManager.getNameIdFormat(samlPeerEntityContext.getEntityId());
        }
        return OpenSamlUtil.buildNameId(nameIdFormat, null, spNameQualifier, nameIdResolver.resolve(samlSsoRequestContext.getUser(), samlPeerEntityContext.getEntityId(), nameIdFormat, spNameQualifier, allowCreate, new NameIdResolverSAMLContextImpl((MessageContext<AuthnRequest>)messageContext)));
    }

    private Response _getSuccessResponse(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, DateTime issueInstant) {
        MessageContext inboundMessageContext;
        SAMLMessageInfoContext samlMessageInfoContext;
        Response response = OpenSamlUtil.buildResponse();
        response.setDestination(assertionConsumerService.getLocation());
        response.setID(this.generateIdentifier(20));
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
        if (inOutOperationContext != null && Validator.isNotNull((String)(samlMessageInfoContext = (SAMLMessageInfoContext)(inboundMessageContext = inOutOperationContext.getInboundMessageContext()).getSubcontext(SAMLMessageInfoContext.class)).getMessageId())) {
            response.setInResponseTo(samlMessageInfoContext.getMessageId());
        }
        response.setIssueInstant(issueInstant);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        response.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        StatusCode statusCode = OpenSamlUtil.buildStatusCode("urn:oasis:names:tc:SAML:2.0:status:Success");
        response.setStatus(OpenSamlUtil.buildStatus(statusCode));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    private void _processAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        MessageContext inboundMessageContext;
        SamlSsoRequestContext samlSsoRequestContext = this.decodeAuthnRequest(httpServletRequest, httpServletResponse);
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
        AuthnRequest authnRequest = null;
        User user = samlSsoRequestContext.getUser();
        if (inOutOperationContext != null && (authnRequest = (AuthnRequest)(inboundMessageContext = inOutOperationContext.getInboundMessageContext()).getMessage()) != null && authnRequest.isPassive().booleanValue() && user == null) {
            this._sendFailureResponse(samlSsoRequestContext, "urn:oasis:names:tc:SAML:2.0:status:NoPassive", httpServletResponse);
            return;
        }
        boolean sessionExpired = false;
        if (!samlSsoRequestContext.isNewSession()) {
            String samlSsoSessionId = samlSsoRequestContext.getSamlSsoSessionId();
            SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId);
            if (samlIdpSsoSession != null) {
                sessionExpired = samlIdpSsoSession.isExpired();
            } else {
                samlSsoSessionId = null;
                samlSsoRequestContext.setSamlSsoSessionId(null);
            }
            if (sessionExpired || Validator.isNull((String)samlSsoSessionId)) {
                CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"SAML_SSO_SESSION_ID"});
                samlSsoRequestContext.setNewSession(true);
                samlSsoRequestContext.setSamlSsoSessionId(this.generateIdentifier(30));
            }
        }
        if (sessionExpired || user == null || authnRequest != null && authnRequest.isForceAuthn().booleanValue() && user != null && samlSsoRequestContext.getStage() == 0) {
            boolean forceAuthn = false;
            if (authnRequest != null && authnRequest.isForceAuthn().booleanValue()) {
                forceAuthn = true;
            }
            this._redirectToLogin(httpServletRequest, httpServletResponse, samlSsoRequestContext, forceAuthn);
        } else {
            this._sendSuccessResponse(httpServletRequest, httpServletResponse, samlSsoRequestContext);
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                httpSession.removeAttribute("FORCE_REAUTHENTICATION");
            }
        }
    }

    private void _processResponse(MessageContext<?> messageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        Response samlResponse = (Response)inboundMessageContext.getMessage();
        Status status = samlResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        String statusCodeURI = statusCode.getValue();
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            StatusCode childStatusCode = statusCode.getStatusCode();
            if (childStatusCode != null && Validator.isNotNull((String)childStatusCode.getValue())) {
                throw new StatusException(childStatusCode.getValue());
            }
            throw new StatusException(statusCodeURI);
        }
        this.verifyInResponseTo(samlResponse);
        this.verifyDestination(messageContext, samlResponse.getDestination());
        Issuer issuer = samlResponse.getIssuer();
        this.verifyIssuer(messageContext, issuer);
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
        NameID nameID = samlSubjectNameIdentifierContext.getSAML2SubjectNameID();
        if (nameID == null) {
            throw new SamlException("Name ID not present in subject");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SAML authenticated user " + nameID.getValue()));
        }
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(CompanyThreadLocal.getCompanyId().longValue(), samlPeerEntityContext.getEntityId());
        if (Validator.isNull((String)samlResponse.getInResponseTo()) && samlSpIdpConnection.isForceAuthn()) {
            throw new AuthnAgeException();
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        User user = this._userResolver.resolveUser(new UserResolverSAMLContextImpl((MessageContext<Response>)messageContext), serviceContext);
        if (user == null) {
            throw new SubjectException("No user could not be matched or provisioned");
        }
        serviceContext.setUserId(user.getUserId());
        SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        SubjectAssertionContext subjectAssertionContext = (SubjectAssertionContext)inboundMessageContext.getSubcontext(SubjectAssertionContext.class);
        Assertion assertion = subjectAssertionContext.getAssertion();
        List authnStatements = assertion.getAuthnStatements();
        AuthnStatement authnStatement = (AuthnStatement)authnStatements.get(0);
        String sessionIndex = authnStatement.getSessionIndex();
        if (samlSpSession != null) {
            this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession.getSamlSpSessionId(), OpenSamlUtil.marshall((XMLObject)assertion), httpSession.getId(), nameID.getFormat(), nameID.getNameQualifier(), nameID.getSPNameQualifier(), nameID.getValue(), issuer.getValue(), samlSpSession.getSamlSpSessionKey(), sessionIndex, serviceContext);
        } else {
            String samlSpSessionKey = this.generateIdentifier(30);
            samlSpSession = this.samlSpSessionLocalService.addSamlSpSession(OpenSamlUtil.marshall((XMLObject)assertion), httpSession.getId(), nameID.getFormat(), nameID.getNameQualifier(), nameID.getSPNameQualifier(), nameID.getValue(), issuer.getValue(), samlSpSessionKey, sessionIndex, serviceContext);
        }
        httpSession.setAttribute("SAML_SP_SESSION_KEY", (Object)samlSpSession.getSamlSpSessionKey());
        this.addNonpersistentCookie(httpServletRequest, httpServletResponse, "SAML_SP_SESSION_KEY", samlSpSession.getSamlSpSessionKey());
        httpServletResponse.sendRedirect(this._getAuthRedirectURL(messageContext, httpServletRequest));
    }

    private void _redirectToLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSsoRequestContext samlSsoRequestContext, boolean forceAuthn) {
        HttpSession httpSession = httpServletRequest.getSession();
        if (forceAuthn) {
            this.logout(httpServletRequest, httpServletResponse);
            httpSession = httpServletRequest.getSession(true);
            httpSession.setAttribute("FORCE_REAUTHENTICATION", (Object)Boolean.TRUE);
        }
        MessageContext<?> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        samlSsoRequestContext.setSAMLMessageContext(null);
        httpSession.setAttribute("SAML_SSO_REQUEST_CONTEXT", (Object)samlSsoRequestContext);
        httpServletResponse.addHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        httpServletResponse.addHeader("Pragma", "no-cache");
        StringBundler sb = new StringBundler(3);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/login?redirect=");
        StringBundler redirectSB = new StringBundler(4);
        redirectSB.append(themeDisplay.getPathMain());
        redirectSB.append("/portal/saml/sso");
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)samlMessageContext.getSubcontext(SAMLPeerEntityContext.class);
        InOutOperationContext inOutOperationContext = (InOutOperationContext)samlMessageContext.getSubcontext(InOutOperationContext.class, false);
        if (inOutOperationContext != null) {
            MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
            SAMLMessageInfoContext samlMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class);
            if (samlMessageInfoContext != null && samlMessageInfoContext.getMessageId() != null) {
                redirectSB.append("?saml_message_id=");
                redirectSB.append(URLCodec.encodeURL((String)samlMessageInfoContext.getMessageId()));
            }
        } else if (samlPeerEntityContext.getEntityId() != null) {
            redirectSB.append("?entityId=");
            redirectSB.append(URLCodec.encodeURL((String)samlPeerEntityContext.getEntityId()));
        }
        sb.append(URLCodec.encodeURL((String)redirectSB.toString()));
        String redirect = sb.toString();
        try {
            httpServletResponse.sendRedirect(redirect);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    private void _sendFailureResponse(SamlSsoRequestContext samlSsoRequestContext, String statusURI, HttpServletResponse httpServletResponse) throws Exception {
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        AssertionConsumerService assertionConsumerService = SamlUtil.resolverAssertionConsumerService(messageContext, samlBinding.getCommunicationProfileId());
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class);
        samlPeerEndpointContext.setEndpoint((Endpoint)assertionConsumerService);
        Credential credential = this.metadataManager.getSigningCredential();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        OpenSamlUtil.prepareSecurityParametersContext(credential, securityParametersContext, samlPeerMetadataContext.getRoleDescriptor());
        Response response = OpenSamlUtil.buildResponse();
        response.setDestination(assertionConsumerService.getLocation());
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        SAMLMessageInfoContext samlMessageInfoContext = (SAMLMessageInfoContext)inboundMessageContext.getSubcontext(SAMLMessageInfoContext.class);
        response.setInResponseTo(samlMessageInfoContext.getMessageId());
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        response.setIssueInstant(issueInstantDateTime);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        response.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusURI);
        response.setStatus(OpenSamlUtil.buildStatus(statusCode));
        outboundMessageContext.setMessage((Object)response);
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    private void _sendSuccessResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSsoRequestContext samlSsoRequestContext) throws Exception {
        EncryptionParameters encryptionParameters;
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        AssertionConsumerService assertionConsumerService = SamlUtil.resolverAssertionConsumerService(messageContext, samlBinding.getCommunicationProfileId());
        NameID nameID = this._getSuccessNameId(samlSsoRequestContext);
        Assertion assertion = this._getSuccessAssertion(samlSsoRequestContext, assertionConsumerService, nameID);
        Credential credential = this.metadataManager.getSigningCredential();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        if (spSSODescriptor.getWantAssertionsSigned().booleanValue()) {
            OpenSamlUtil.signObject((SignableSAMLObject)assertion, credential, (RoleDescriptor)spSSODescriptor);
        }
        Response samlResponse = this._getSuccessResponse(samlSsoRequestContext, assertionConsumerService, assertion.getIssueInstant());
        SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(CompanyThreadLocal.getCompanyId().longValue(), samlPeerEntityContext.getEntityId());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{(EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class)}), new RoleDescriptorCriterion((RoleDescriptor)spSSODescriptor)});
        if (!samlIdpSpConnection.isEncryptionForced()) {
            criteriaSet.add(new EncryptionOptionalCriterion(true));
        }
        if ((encryptionParameters = this._samlMetadataEncryptionParametersResolver.resolveSingle(criteriaSet)) != null) {
            Encrypter encrypter = new Encrypter(new DataEncryptionParameters(encryptionParameters), new KeyEncryptionParameters(encryptionParameters, samlPeerEntityContext.getEntityId()));
            EncryptedAssertion encryptedAssertion = encrypter.encrypt(assertion);
            List encryptedAssertions = samlResponse.getEncryptedAssertions();
            encryptedAssertions.add(encryptedAssertion);
        } else {
            if (samlIdpSpConnection.isEncryptionForced()) {
                throw new SamlException(StringBundler.concat((String[])new String[]{"Encryption is forced for ", samlPeerEntityContext.getEntityId(), ", but no encryption parameters have been successfully ", "negotiated"}));
            }
            List assertions = samlResponse.getAssertions();
            assertions.add(assertion);
        }
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
        if (inOutOperationContext == null) {
            inOutOperationContext = (InOutOperationContext)messageContext.addSubcontext((BaseContext)new InOutOperationContext(new MessageContext(), new MessageContext()));
        }
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.addSubcontext(messageContext.getSubcontext(SAMLBindingContext.class, true));
        outboundMessageContext.setMessage((Object)samlResponse);
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        OpenSamlUtil.prepareSecurityParametersContext(credential, securityParametersContext, (RoleDescriptor)spSSODescriptor);
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)outboundMessageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SAMLPeerEntityContext samlOutboundPeerEntityContext = (SAMLPeerEntityContext)outboundMessageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlOutboundPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)assertionConsumerService);
        if (samlSsoRequestContext.isNewSession()) {
            this._addSamlSsoSession(httpServletRequest, httpServletResponse, samlSsoRequestContext, nameID);
        } else {
            this._updateSamlSsoSession(httpServletRequest, samlSsoRequestContext, nameID);
        }
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    private void _updateSamlSsoSession(HttpServletRequest httpServletRequest, SamlSsoRequestContext samlSsoRequestContext, NameID nameID) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.updateModifiedDate(samlSsoRequestContext.getSamlSsoSessionId());
        MessageContext<?> messageContext = samlSsoRequestContext.getSAMLMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        try {
            this._samlIdpSpSessionLocalService.updateModifiedDate(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlPeerEntityContext.getEntityId());
        }
        catch (NoSuchIdpSpSessionException noSuchIdpSpSessionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchIdpSpSessionException);
            }
            this._samlIdpSpSessionLocalService.addSamlIdpSpSession(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlPeerEntityContext.getEntityId(), nameID.getFormat(), nameID.getValue(), serviceContext);
        }
    }

    private void _verifyAssertion(Assertion assertion, MessageContext<?> messageContext, TrustEngine<Signature> trustEngine) throws PortalException {
        this.verifyReplay(messageContext, assertion);
        this.verifyIssuer(messageContext, assertion.getIssuer());
        this.verifyAssertionSignature(assertion.getSignature(), messageContext, trustEngine);
        this.verifyConditions(messageContext, assertion.getConditions());
        this.verifySubject(messageContext, assertion.getSubject());
    }

    private void _verifySignature(MessageContext<?> messageContext, Signature signature, TrustEngine<Signature> trustEngine) throws PortalException {
        try {
            _samlSignatureProfileValidator.validate(signature);
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add(new EntityIdCriterion(samlPeerEntityContext.getEntityId()));
            criteriaSet.add(new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
            criteriaSet.add(new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
            criteriaSet.add(new UsageCriterion(UsageType.SIGNING));
            if (!trustEngine.validate((Object)signature, criteriaSet)) {
                throw new SignatureException("Unable validate signature trust");
            }
        }
        catch (Exception exception) {
            if (exception instanceof PortalException) {
                throw (PortalException)((Object)exception);
            }
            throw new SignatureException("Unable to verify signature", (Throwable)exception);
        }
    }
}

