/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={NameIdResolver.class})
public class DefaultNameIdResolver
implements NameIdResolver {
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private MetadataManager _metadataManager;

    @Override
    public String resolve(User user, String entityId, String format, String spQualifierName, boolean allowCreate, NameIdResolver.NameIdResolverSAMLContext nameIdResolverSAMLContext) {
        return this._getNameIdValue(user, entityId);
    }

    private String _getNameIdAttributeName(String entityId) {
        return this._metadataManager.getNameIdAttribute(entityId);
    }

    private String _getNameIdValue(User user, String entityId) {
        String nameIdAttributeName = this._getNameIdAttributeName(entityId);
        if (Validator.isNull((String)nameIdAttributeName)) {
            return user.getEmailAddress();
        }
        if (nameIdAttributeName.startsWith("expando:")) {
            String attributeName = nameIdAttributeName.substring(8);
            ExpandoBridge expandoBridge = user.getExpandoBridge();
            return this._toString(expandoBridge.getAttribute(attributeName));
        }
        if (nameIdAttributeName.startsWith("static:")) {
            return nameIdAttributeName.substring(7);
        }
        return this._toString(this._beanProperties.getObject((Object)user, nameIdAttributeName));
    }

    private String _toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

