/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.metadata;

import com.google.common.base.Function;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.bootstrap.SecurityConfigurationBootstrap;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataGeneratorUtil;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.internal.provider.CachingChainingMetadataResolver;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import com.liferay.saml.util.SamlHttpRequestUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.impl.BasicMessageHandlerChain;
import org.opensaml.messaging.handler.impl.CheckMandatoryAuthentication;
import org.opensaml.messaging.handler.impl.CheckMandatoryIssuer;
import org.opensaml.messaging.handler.impl.HTTPRequestValidationHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLProtocolMessageXMLSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextAuthenticationFunction;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextIssuerFunction;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPPostSimpleSignSecurityHandler;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ChainingSignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={MetadataManager.class, SamlHttpRequestUtil.class})
public class MetadataManagerImpl
implements MetadataManager,
SamlHttpRequestUtil {
    private static final Log _log = LogFactoryUtil.getLog(MetadataManagerImpl.class);
    private final CachingChainingMetadataResolver _cachingChainingMetadataResolver = new CachingChainingMetadataResolver();
    private ChainingSignatureTrustEngine _chainingSignatureTrustEngine;
    private CredentialResolver _credentialResolver;
    private LocalEntityManager _localEntityManager;
    private MetadataCredentialResolver _metadataCredentialResolver;
    private ParserPool _parserPool;
    private Portal _portal;
    private final PredicateRoleDescriptorResolver _predicateRoleDescriptorResolver = new PredicateRoleDescriptorResolver((MetadataResolver)this._cachingChainingMetadataResolver);
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;
    @Reference
    private SecurityConfigurationBootstrap _securityConfigurationBootstrap;

    @Override
    public int getAssertionLifetime(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.getAssertionLifetime();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
            return samlProviderConfiguration.defaultAssertionLifetime();
        }
    }

    @Override
    public String[] getAttributeNames(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return StringUtil.splitLines((String)samlIdpSpConnection.getAttributeNames());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public long getClockSkew() {
        return this._getSamlProviderConfiguration().clockSkew();
    }

    @Override
    public Credential getEncryptionCredential() throws SamlException {
        try {
            String entityId = this._localEntityManager.getLocalEntityId();
            if (Validator.isNull((String)entityId)) {
                return null;
            }
            return (Credential)this._credentialResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), new UsageCriterion(UsageType.ENCRYPTION)}));
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    @Override
    public EntityDescriptor getEntityDescriptor(HttpServletRequest httpServletRequest) throws SamlException {
        Credential encryptionCredential;
        block6: {
            encryptionCredential = null;
            try {
                encryptionCredential = this.getEncryptionCredential();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("Unable to get encryption credential: " + exception.getMessage()), (Throwable)exception);
            }
        }
        try {
            String portalURL = this._portal.getPortalURL(httpServletRequest, this._isSSLRequired() || this._portal.isSecure(httpServletRequest));
            String localEntityId = this._localEntityManager.getLocalEntityId();
            if (this._samlProviderConfigurationHelper.isRoleIdp()) {
                return MetadataGeneratorUtil.buildIdpEntityDescriptor(portalURL, localEntityId, this._isWantAuthnRequestSigned(), this._isSignMetadata(), this.getSigningCredential(), encryptionCredential);
            }
            if (this._samlProviderConfigurationHelper.isRoleSp()) {
                return MetadataGeneratorUtil.buildSpEntityDescriptor(portalURL, localEntityId, this._isSignAuthnRequest(), this._isSignMetadata(), this._isWantAssertionsSigned(), this.getSigningCredential(), encryptionCredential);
            }
            return null;
        }
        catch (Exception exception) {
            throw new SamlException((Throwable)exception);
        }
    }

    public String getEntityDescriptorString(HttpServletRequest httpServletRequest) throws SamlException {
        try {
            return OpenSamlUtil.marshall((XMLObject)this.getEntityDescriptor(httpServletRequest));
        }
        catch (Exception exception) {
            throw new SamlException((Throwable)exception);
        }
    }

    @Override
    public MetadataCredentialResolver getMetadataCredentialResolver() {
        return this._metadataCredentialResolver;
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this._cachingChainingMetadataResolver;
    }

    @Override
    public String getNameIdAttribute(String entityId) {
        String nameIdAttributeName;
        block3: {
            long companyId = CompanyThreadLocal.getCompanyId();
            nameIdAttributeName = "";
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                nameIdAttributeName = samlIdpSpConnection.getNameIdAttribute();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        if (Validator.isNotNull((String)nameIdAttributeName)) {
            return nameIdAttributeName;
        }
        return "emailAddress";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getNameIdFormat(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (this._samlProviderConfigurationHelper.isRoleIdp()) {
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                return samlIdpSpConnection.getNameIdFormat();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) return null;
                _log.debug((Throwable)exception);
                return null;
            }
        } else {
            if (!this._samlProviderConfigurationHelper.isRoleSp()) return null;
            try {
                SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
                return samlSpIdpConnection.getNameIdFormat();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) return null;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }

    public String getRequestPath(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (Validator.isNotNull((String)contextPath) && !contextPath.equals("/")) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return HttpComponentsUtil.removePathParameters((String)requestURI);
    }

    @Override
    public MessageHandler<?> getSecurityMessageHandler(HttpServletRequest httpServletRequest, String communicationProfileId, boolean requireSignature) {
        BasicMessageHandlerChain basicMessageHandlerChain = new BasicMessageHandlerChain();
        ArrayList<Object> messageHandlers = new ArrayList<Object>();
        if (requireSignature) {
            if (communicationProfileId.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                SAML2HTTPRedirectDeflateSignatureSecurityHandler saml2HTTPRedirectDeflateSignatureSecurityHandler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
                saml2HTTPRedirectDeflateSignatureSecurityHandler.setHttpServletRequest(httpServletRequest);
                messageHandlers.add(saml2HTTPRedirectDeflateSignatureSecurityHandler);
            } else if (communicationProfileId.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign")) {
                DecryptionConfiguration decryptionConfiguration = SecurityConfigurationSupport.getGlobalDecryptionConfiguration();
                KeyInfoCredentialResolver keyInfoCredentialResolver = decryptionConfiguration.getDataKeyInfoCredentialResolver();
                SAML2HTTPPostSimpleSignSecurityHandler saml2HTTPPostSimpleSignSecurityHandler = new SAML2HTTPPostSimpleSignSecurityHandler();
                saml2HTTPPostSimpleSignSecurityHandler.setKeyInfoResolver(keyInfoCredentialResolver);
                saml2HTTPPostSimpleSignSecurityHandler.setParser(this._parserPool);
                messageHandlers.add(saml2HTTPPostSimpleSignSecurityHandler);
            } else {
                messageHandlers.add(new SAMLProtocolMessageXMLSignatureSecurityHandler());
            }
            CheckMandatoryAuthentication checkMandatoryAuthentication = new CheckMandatoryAuthentication();
            checkMandatoryAuthentication.setAuthenticationLookupStrategy((Function)new SAMLMessageContextAuthenticationFunction());
            messageHandlers.add(checkMandatoryAuthentication);
        }
        CheckMandatoryIssuer checkMandatoryIssuer = new CheckMandatoryIssuer();
        checkMandatoryIssuer.setIssuerLookupStrategy((Function)new SAMLMessageContextIssuerFunction());
        messageHandlers.add(checkMandatoryIssuer);
        HTTPRequestValidationHandler httpRequestValidationHandler = new HTTPRequestValidationHandler();
        httpRequestValidationHandler.setHttpServletRequest(httpServletRequest);
        httpRequestValidationHandler.setRequireSecured(this._isSSLRequired());
        messageHandlers.add(httpRequestValidationHandler);
        basicMessageHandlerChain.setHandlers(messageHandlers);
        return basicMessageHandlerChain;
    }

    @Override
    public SignatureTrustEngine getSignatureTrustEngine() throws SamlException {
        return this._chainingSignatureTrustEngine;
    }

    @Override
    public Credential getSigningCredential() throws SamlException {
        try {
            String entityId = this._localEntityManager.getLocalEntityId();
            if (Validator.isNull((String)entityId)) {
                return null;
            }
            return (Credential)this._credentialResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), new UsageCriterion(UsageType.SIGNING)}));
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    @Override
    public String getUserAttributeMappings(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
            return samlSpIdpConnection.getUserAttributeMappings();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public boolean isAttributesEnabled(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.isAttributesEnabled();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    @Override
    public boolean isAttributesNamespaceEnabled(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.isAttributesNamespaceEnabled();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    @Reference(unbind="-")
    public void setCredentialResolver(CredentialResolver credentialResolver) {
        this._credentialResolver = credentialResolver;
    }

    @Reference(unbind="-")
    public void setLocalEntityManager(LocalEntityManager localEntityManager) {
        this._localEntityManager = localEntityManager;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY, scope=ReferenceScope.PROTOTYPE_REQUIRED)
    public void setMetadataResolver(MetadataResolver metadataResolver) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding metadata resolver " + metadataResolver));
        }
        this._cachingChainingMetadataResolver.addMetadataResolver(metadataResolver);
    }

    @Reference(unbind="-")
    public void setParserPool(ParserPool parserPool) {
        this._parserPool = parserPool;
    }

    @Reference(unbind="-")
    public void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this._samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    public void unsetMetadataResolver(MetadataResolver metadataResolver) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removing metadata resolver " + metadataResolver));
        }
        this._cachingChainingMetadataResolver.removeMetadataResolver(metadataResolver);
    }

    @Activate
    protected void activate() throws ComponentInitializationException {
        this._cachingChainingMetadataResolver.setId(CachingChainingMetadataResolver.class.getName());
        this._cachingChainingMetadataResolver.setParserPool(this._parserPool);
        this._cachingChainingMetadataResolver.initialize();
        this._predicateRoleDescriptorResolver.initialize();
        KeyInfoCredentialResolver keyInfoCredentialResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
        this._metadataCredentialResolver = new MetadataCredentialResolver();
        this._metadataCredentialResolver.setKeyInfoCredentialResolver(keyInfoCredentialResolver);
        this._metadataCredentialResolver.setRoleDescriptorResolver((RoleDescriptorResolver)this._predicateRoleDescriptorResolver);
        this._metadataCredentialResolver.initialize();
        ArrayList<ExplicitKeySignatureTrustEngine> signatureTrustEngines = new ArrayList<ExplicitKeySignatureTrustEngine>();
        ExplicitKeySignatureTrustEngine signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this._metadataCredentialResolver, keyInfoCredentialResolver);
        signatureTrustEngines.add(signatureTrustEngine);
        signatureTrustEngine = new ExplicitKeySignatureTrustEngine(this._credentialResolver, keyInfoCredentialResolver);
        signatureTrustEngines.add(signatureTrustEngine);
        this._chainingSignatureTrustEngine = new ChainingSignatureTrustEngine(signatureTrustEngines);
    }

    @Deactivate
    protected void deactivate() {
        this._predicateRoleDescriptorResolver.destroy();
        this._cachingChainingMetadataResolver.destroy();
    }

    private SamlProviderConfiguration _getSamlProviderConfiguration() {
        return this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
    }

    private boolean _isSignAuthnRequest() {
        return this._getSamlProviderConfiguration().signAuthnRequest();
    }

    private boolean _isSignMetadata() {
        return this._getSamlProviderConfiguration().signMetadata();
    }

    private boolean _isSSLRequired() {
        return this._getSamlProviderConfiguration().sslRequired();
    }

    private boolean _isWantAssertionsSigned() {
        return this._getSamlProviderConfiguration().assertionSignatureRequired();
    }

    private boolean _isWantAuthnRequestSigned() {
        return this._getSamlProviderConfiguration().authnRequestSignatureRequired();
    }
}

