/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import com.liferay.saml.runtime.exception.EntityIdException;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.AbstractCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlKeyStoreManagerConfiguration"}, immediate=true, service={CredentialResolver.class, LocalEntityManager.class})
public class KeyStoreCredentialResolver
extends AbstractCredentialResolver
implements LocalEntityManager {
    private KeyStoreManager _keyStoreManager;
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;

    public void deleteLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws KeyStoreException {
        KeyStore keyStore = this._keyStoreManager.getKeyStore();
        keyStore.deleteEntry(this._getAlias(this.getLocalEntityId(), this._getUsageType(certificateUsage)));
        try {
            this._keyStoreManager.saveKeyStore(keyStore);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception);
        }
    }

    public String getEncodedLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws SamlException {
        try {
            X509Certificate x509Certificate = this.getLocalEntityCertificate(certificateUsage);
            if (x509Certificate == null) {
                return null;
            }
            return Base64.encode(x509Certificate.getEncoded(), 76);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SamlException((Throwable)certificateEncodingException);
        }
    }

    public X509Certificate getLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws SamlException {
        UsageType usageType = this._getUsageType(certificateUsage);
        if (usageType == null) {
            return null;
        }
        String entityId = this.getLocalEntityId();
        if (Validator.isBlank((String)entityId)) {
            throw new SamlException((Throwable)new EntityIdException("An Entity ID must be configured"));
        }
        UsageCriterion usageCriterion = new UsageCriterion(usageType);
        try {
            X509Credential x509Credential = (X509Credential)this.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), usageCriterion}));
            if (x509Credential == null) {
                return null;
            }
            return x509Credential.getEntityCertificate();
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    public String getLocalEntityId() {
        return this._getSamlProviderConfiguration().entityId();
    }

    public boolean hasDefaultIdpRole() {
        List samlSpIdpConnections = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnections(CompanyThreadLocal.getCompanyId().longValue());
        return !samlSpIdpConnections.isEmpty();
    }

    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws SecurityException {
        try {
            KeyStore keyStore;
            KeyStore.Entry entry;
            this._checkCriteriaRequirements(criteriaSet);
            EntityIdCriterion entityIDCriterion = criteriaSet.get(EntityIdCriterion.class);
            String entityId = entityIDCriterion.getEntityId();
            KeyStore.PasswordProtection keyStorePasswordProtection = null;
            SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
            UsageCriterion usageCriterion = criteriaSet.get(UsageCriterion.class);
            UsageType usageType = UsageType.UNSPECIFIED;
            if (usageCriterion != null) {
                usageType = usageCriterion.getUsage();
            }
            if (entityId.equals(samlProviderConfiguration.entityId())) {
                String keyStoreCredentialPassword = null;
                keyStoreCredentialPassword = usageType == UsageType.ENCRYPTION ? samlProviderConfiguration.keyStoreEncryptionCredentialPassword() : samlProviderConfiguration.keyStoreCredentialPassword();
                if (keyStoreCredentialPassword != null) {
                    keyStorePasswordProtection = new KeyStore.PasswordProtection(keyStoreCredentialPassword.toCharArray());
                }
            }
            if ((entry = (keyStore = this._keyStoreManager.getKeyStore()).getEntry(this._getAlias(entityId, usageType), keyStorePasswordProtection)) == null) {
                return Collections.emptySet();
            }
            Credential credential = this._buildCredential(entry, entityId, usageType);
            return Collections.singleton(credential);
        }
        catch (RuntimeException runtimeException) {
            throw new SecurityException(runtimeException);
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    @Reference(name="KeyStoreManager", target="(default=true)", unbind="-")
    public void setKeyStoreManager(KeyStoreManager keyStoreManager) {
        this._keyStoreManager = keyStoreManager;
    }

    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this._samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    public void storeLocalEntityCertificate(PrivateKey privateKey, String certificateKeyPassword, X509Certificate x509Certificate, LocalEntityManager.CertificateUsage certificateUsage) throws Exception {
        KeyStore keyStore = this._keyStoreManager.getKeyStore();
        keyStore.setEntry(this._getAlias(this.getLocalEntityId(), this._getUsageType(certificateUsage)), new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{x509Certificate}), new KeyStore.PasswordProtection(certificateKeyPassword.toCharArray()));
        this._keyStoreManager.saveKeyStore(keyStore);
    }

    private Credential _buildCredential(KeyStore.Entry entry, String entityId, UsageType usage) {
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            return this._processPrivateKeyEntry((KeyStore.PrivateKeyEntry)entry, entityId, usage);
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            return this._processSecretKeyEntry((KeyStore.SecretKeyEntry)entry, entityId, usage);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            return this._processTrustedCertificateEntry((KeyStore.TrustedCertificateEntry)entry, entityId, usage);
        }
        return null;
    }

    private void _checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIdCriterion entityIdCriterion = criteriaSet.get(EntityIdCriterion.class);
        if (entityIdCriterion == null) {
            throw new IllegalArgumentException("No entity ID criterion was available in criteria set");
        }
    }

    private String _getAlias(String entityId, UsageType usageType) {
        if (usageType.equals((Object)UsageType.SIGNING)) {
            return entityId;
        }
        if (usageType.equals((Object)UsageType.ENCRYPTION)) {
            return entityId + "-encryption";
        }
        return entityId;
    }

    private SamlProviderConfiguration _getSamlProviderConfiguration() {
        return this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
    }

    private UsageType _getUsageType(LocalEntityManager.CertificateUsage certificateUsage) {
        UsageType usageType = null;
        if (certificateUsage == LocalEntityManager.CertificateUsage.ENCRYPTION) {
            usageType = UsageType.ENCRYPTION;
        } else if (certificateUsage == LocalEntityManager.CertificateUsage.SIGNING) {
            usageType = UsageType.SIGNING;
        }
        return usageType;
    }

    private Credential _processPrivateKeyEntry(KeyStore.PrivateKeyEntry privateKeyEntry, String entityId, UsageType usageType) {
        BasicX509Credential basicX509Credential = new BasicX509Credential((X509Certificate)privateKeyEntry.getCertificate());
        basicX509Credential.setEntityCertificateChain(Arrays.asList((X509Certificate[])privateKeyEntry.getCertificateChain()));
        basicX509Credential.setEntityId(entityId);
        basicX509Credential.setPrivateKey(privateKeyEntry.getPrivateKey());
        basicX509Credential.setUsageType(usageType);
        return basicX509Credential;
    }

    private Credential _processSecretKeyEntry(KeyStore.SecretKeyEntry secretKeyEntry, String entityId, UsageType usageType) {
        BasicCredential basicCredential = new BasicCredential(secretKeyEntry.getSecretKey());
        basicCredential.setEntityId(entityId);
        basicCredential.setUsageType(usageType);
        return basicCredential;
    }

    private Credential _processTrustedCertificateEntry(KeyStore.TrustedCertificateEntry trustedCertificateEntry, String entityId, UsageType usageType) {
        X509Certificate x509Certificate = (X509Certificate)trustedCertificateEntry.getTrustedCertificate();
        BasicX509Credential basicX509Credential = new BasicX509Credential(x509Certificate);
        basicX509Credential.setEntityCertificateChain(Arrays.asList(x509Certificate));
        basicX509Credential.setEntityId(entityId);
        basicX509Credential.setUsageType(usageType);
        return basicX509Credential;
    }
}

