/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={NameIdResolver.class})
public class DefaultNameIdResolver
implements NameIdResolver {
    private MetadataManager _metadataManager;

    @Override
    public String resolve(User user, String entityId, String format, String spQualifierName, boolean allowCreate, NameIdResolver.NameIdResolverSAMLContext nameIdResolverSAMLContext) {
        return this.getNameIdValue(user, entityId);
    }

    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        this._metadataManager = metadataManager;
    }

    protected String getNameIdAttributeName(String entityId) {
        return this._metadataManager.getNameIdAttribute(entityId);
    }

    protected String getNameIdValue(User user, String entityId) {
        String nameIdAttributeName = this.getNameIdAttributeName(entityId);
        String nameIdValue = user.getEmailAddress();
        if (Validator.isNull((String)nameIdAttributeName)) {
            return nameIdValue;
        }
        if (nameIdAttributeName.startsWith("expando:")) {
            String attributeName = nameIdAttributeName.substring(8);
            ExpandoBridge expandoBridge = user.getExpandoBridge();
            nameIdValue = String.valueOf(expandoBridge.getAttribute(attributeName));
        } else {
            nameIdValue = nameIdAttributeName.startsWith("static:") ? nameIdAttributeName.substring(7) : String.valueOf(BeanPropertiesUtil.getObject((Object)user, (String)nameIdAttributeName));
        }
        return nameIdValue;
    }
}

