/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.service.tracker.collections;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.service.tracker.collections.OrderedServiceTrackerMap;
import com.liferay.saml.opensaml.integration.internal.service.tracker.collections.OrderedServiceTrackerMapFactory;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={OrderedServiceTrackerMapFactory.class})
public class OrderedServiceTrackerMapFactoryImpl
implements OrderedServiceTrackerMapFactory {
    @Override
    public <T> OrderedServiceTrackerMap<T> create(BundleContext bundleContext, Class<T> clazz, String propertyKey) {
        return new OrderedServiceTrackerMapImpl(bundleContext, clazz, "(default=true)", propertyKey);
    }

    private static class OrderedServiceTrackerMapImpl<T>
    implements OrderedServiceTrackerMap<T> {
        private final ServiceTracker<T, T> _defaultServiceTracker;
        private final String _propertyKey;
        private final ServiceTrackerMap<String, ServiceReferenceServiceTuple<T, T>> _serviceTrackerMap;

        @Override
        public void close() {
            this._serviceTrackerMap.close();
        }

        @Override
        public String getDefaultServiceKey() {
            ServiceReference serviceReference = this._defaultServiceTracker.getServiceReference();
            if (serviceReference == null) {
                return "";
            }
            return GetterUtil.getString((Object)serviceReference.getProperty(this._propertyKey));
        }

        @Override
        public List<Map.Entry<String, T>> getOrderedServices() {
            Set prefixes = this._serviceTrackerMap.keySet();
            Stream stream = prefixes.stream();
            return stream.map(arg_0 -> this._serviceTrackerMap.getService(arg_0)).filter(Validator::isNotNull).sorted(Comparator.comparing(serviceReferenceServiceTuple -> {
                ServiceReference serviceReference = serviceReferenceServiceTuple.getServiceReference();
                return GetterUtil.getInteger((Object)serviceReference.getProperty("display.index"));
            })).map(serviceReferenceServiceTuple -> new AbstractMap.SimpleEntry<String, Object>((String)serviceReferenceServiceTuple.getServiceReference().getProperty(this._propertyKey), serviceReferenceServiceTuple.getService())).collect(Collectors.toList());
        }

        @Override
        public List<String> getOrderedServicesKeys() {
            Set prefixes = this._serviceTrackerMap.keySet();
            Stream stream = prefixes.stream();
            return stream.map(arg_0 -> this._serviceTrackerMap.getService(arg_0)).map(ServiceReferenceServiceTuple::getServiceReference).sorted(Comparator.comparing(serviceReference -> GetterUtil.getInteger((Object)serviceReference.getProperty("display.index")))).map(serviceReference -> GetterUtil.getString((Object)serviceReference.getProperty(this._propertyKey))).collect(Collectors.toList());
        }

        @Override
        public T getService(String key) {
            ServiceReferenceServiceTuple service = (ServiceReferenceServiceTuple)this._serviceTrackerMap.getService((Object)key);
            if (service != null) {
                return (T)service.getService();
            }
            return (T)this._defaultServiceTracker.getService();
        }

        @Override
        public Set<String> getServicesKeys() {
            return this._serviceTrackerMap.keySet();
        }

        private OrderedServiceTrackerMapImpl(BundleContext bundleContext, Class<T> clazz, String defaultServiceFilter, String propertyKey) {
            this._propertyKey = propertyKey;
            this._defaultServiceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)StringBundler.concat((String[])new String[]{"(&(objectClass=", clazz.getName(), ")", defaultServiceFilter, ")"}));
            this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, clazz, (String)propertyKey, (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceReferenceServiceTuple((BundleContext)bundleContext));
        }
    }
}

