/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.servlet.profile;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.BaseProfile;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.ExceptionHandlerUtil;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.IdentifierGenerationStrategyFactory;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSloContext;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSloRequestInfo;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSsoSessionLocalService;
import com.liferay.saml.persistence.service.SamlSpSessionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.exception.UnsolicitedLogoutResponseException;
import com.liferay.saml.runtime.exception.UnsupportedBindingException;
import com.liferay.saml.runtime.servlet.profile.SingleLogoutProfile;
import com.liferay.saml.util.JspUtil;
import com.liferay.saml.util.SamlHttpRequestUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.client.HttpClient;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;
import org.opensaml.messaging.pipeline.httpclient.BasicHttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipelineFactory;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.credential.Credential;
import org.opensaml.soap.client.http.PipelineFactoryHttpSOAPClient;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SingleLogoutProfile.class})
public class SingleLogoutProfileImpl
extends BaseProfile
implements SingleLogoutProfile {
    private static final Log _log = LogFactoryUtil.getLog(SingleLogoutProfileImpl.class);
    @Reference
    private HttpClient _httpClient;
    private SamlHttpRequestUtil _samlHttpRequestUtil;
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    private SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    private SamlIdpSsoSessionLocalService _samlIdpSsoSessionLocalService;
    private UserLocalService _userLocalService;

    public boolean isSingleLogoutSupported(HttpServletRequest httpServletRequest) {
        block5: {
            try {
                String binding;
                String entityId;
                SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
                if (samlSpSession == null) {
                    return false;
                }
                MetadataResolver metadataResolver = this.metadataManager.getMetadataResolver();
                EntityDescriptor entityDescriptor = (EntityDescriptor)metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId = samlSpSession.getSamlIdpEntityId())}));
                IDPSSODescriptor idpSSODescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                if (singleLogoutService != null && !(binding = singleLogoutService.getBinding()).equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    return true;
                }
            }
            catch (Exception exception) {
                String message = "Unable to verify single logout support: " + exception.getMessage();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)message);
            }
        }
        return false;
    }

    public void processIdpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        String requestPath = this._samlHttpRequestUtil.getRequestPath(httpServletRequest);
        try {
            httpServletResponse.addHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.addHeader("Pragma", "no-cache");
            if (requestPath.equals("/c/portal/logout")) {
                this.initiateIdpSingleLogout(httpServletRequest, httpServletResponse);
            } else if (requestPath.equals("/c/portal/saml/slo_logout")) {
                SamlSloContext samlSloContext = this.getSamlSloContext(httpServletRequest, null);
                if (samlSloContext == null) {
                    this.redirectToLogout(httpServletRequest, httpServletResponse);
                    return;
                }
                String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
                if (Validator.isNull((String)cmd)) {
                    httpServletRequest.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext.toJSONObject());
                    JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo.jsp", (String)"single-sign-out");
                } else if (cmd.equals("logout")) {
                    this.performIdpSpLogout(httpServletRequest, httpServletResponse, samlSloContext);
                } else if (cmd.equals("finish")) {
                    this.performIdpFinishLogout(httpServletRequest, httpServletResponse, samlSloContext);
                } else if (cmd.equals("status")) {
                    this.performIdpStatus(httpServletRequest, httpServletResponse, samlSloContext);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void processSingleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        block10: {
            SamlBinding samlBinding = null;
            String method = httpServletRequest.getMethod();
            String requestPath = this._samlHttpRequestUtil.getRequestPath(httpServletRequest);
            if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"GET")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            } else if (requestPath.endsWith("/slo_soap") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            } else {
                throw new UnsupportedBindingException();
            }
            try {
                MessageContext<?> messageContext = this.decodeSamlMessage(httpServletRequest, httpServletResponse, samlBinding, true);
                InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
                MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
                Object inboundSamlMessage = inboundMessageContext.getMessage();
                if (inboundSamlMessage instanceof LogoutRequest) {
                    this.processSingleLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
                    break block10;
                }
                if (inboundSamlMessage instanceof LogoutResponse) {
                    this.processSingleLogoutResponse(httpServletRequest, httpServletResponse, messageContext);
                    break block10;
                }
                throw new SamlException("Unrecognized inbound SAML message " + inboundSamlMessage.getClass());
            }
            catch (Exception exception) {
                ExceptionHandlerUtil.handleException(exception);
            }
        }
    }

    public void processSpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        try {
            this.sendSpLogoutRequest(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    @Override
    @Reference(unbind="-")
    public void setIdentifierGenerationStrategyFactory(IdentifierGenerationStrategyFactory identifierGenerationStrategyFactory) {
        super.setIdentifierGenerationStrategyFactory(identifierGenerationStrategyFactory);
    }

    @Override
    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        super.setMetadataManager(metadataManager);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    public void setSamlBinding(SamlBinding samlBinding) {
        this.addSamlBinding(samlBinding);
    }

    @Override
    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        super.setSamlProviderConfigurationHelper(samlProviderConfigurationHelper);
    }

    public void terminateSpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
            if (samlSpSession == null) {
                return;
            }
            this.samlSpSessionLocalService.deleteSamlSpSession(samlSpSession);
            this.addCookie(httpServletRequest, httpServletResponse, "SAML_SP_SESSION_KEY", "", 0);
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)systemException.getMessage(), (Throwable)systemException);
            }
            _log.error((Object)systemException.getMessage());
        }
    }

    public void terminateSsoSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
        if (Validator.isNotNull((String)samlSsoSessionId)) {
            try {
                SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId);
                if (samlIdpSsoSession != null) {
                    this._samlIdpSsoSessionLocalService.deleteSamlIdpSsoSession(samlIdpSsoSession);
                    List samlIdpSpSessions = this._samlIdpSpSessionLocalService.getSamlIdpSpSessions(samlIdpSsoSession.getSamlIdpSsoSessionId());
                    for (SamlIdpSpSession samlIdpSpSession : samlIdpSpSessions) {
                        this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSession);
                    }
                }
            }
            catch (SystemException systemException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)systemException.getMessage(), (Throwable)systemException);
                }
                _log.error((Object)systemException.getMessage());
            }
        }
        this.addCookie(httpServletRequest, httpServletResponse, "SAML_SSO_SESSION_ID", "", 0);
    }

    protected void addSessionIndex(LogoutRequest logoutRequest, String sessionIndexString) {
        if (Validator.isNull((String)sessionIndexString)) {
            return;
        }
        List sessionIndexes = logoutRequest.getSessionIndexes();
        SessionIndex sessionIndex = OpenSamlUtil.buildSessionIndex(sessionIndexString);
        sessionIndexes.add(sessionIndex);
    }

    protected SamlSloContext getSamlSloContext(HttpServletRequest httpServletRequest, MessageContext<?> messageContext) {
        SamlIdpSsoSession samlIdpSsoSession;
        InOutOperationContext inOutOperationContext;
        MessageContext inboundMessageContext;
        LogoutRequest logoutRequest;
        List sessionIndexes;
        HttpSession session = httpServletRequest.getSession();
        SamlSloContext samlSloContext = (SamlSloContext)session.getAttribute("SAML_SLO_CONTEXT");
        String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
        if (messageContext != null && !(sessionIndexes = (logoutRequest = (LogoutRequest)(inboundMessageContext = (inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class)).getInboundMessageContext()).getMessage()).getSessionIndexes()).isEmpty()) {
            SessionIndex sessionIndex = (SessionIndex)sessionIndexes.get(0);
            samlSsoSessionId = sessionIndex.getSessionIndex();
        }
        if (samlSloContext == null && Validator.isNotNull((String)samlSsoSessionId) && (samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId)) != null) {
            samlSloContext = new SamlSloContext(samlIdpSsoSession, messageContext, this._samlIdpSpConnectionLocalService, this._samlIdpSpSessionLocalService, this._userLocalService);
            samlSloContext.setSamlSsoSessionId(samlSsoSessionId);
            samlSloContext.setUserId(this.portal.getUserId(httpServletRequest));
            session.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext);
        }
        return samlSloContext;
    }

    protected void initiateIdpSingleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(httpServletRequest, null);
        if (samlSloContext != null) {
            String portalURL = this.portal.getPortalURL(httpServletRequest);
            String redirect = portalURL.concat(this.portal.getPathMain()).concat("/portal/saml/slo_logout");
            httpServletResponse.sendRedirect(redirect);
        } else {
            this.redirectToLogout(httpServletRequest, httpServletResponse);
        }
    }

    protected void performIdpFinishLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        if (samlSloContext.getMessageContext() != null) {
            String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
            for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
                String samlRequestInfoStatusCode = samlRequestInfo.getStatusCode();
                if (samlRequestInfoStatusCode.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) continue;
                statusCode = "urn:oasis:names:tc:SAML:2.0:status:PartialLogout";
                break;
            }
            this.sendIdpLogoutResponse(httpServletRequest, httpServletResponse, statusCode, samlSloContext);
        } else {
            this.redirectToLogout(httpServletRequest, httpServletResponse);
        }
    }

    protected void performIdpSpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        String entityId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"entityId");
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Received logout request for service provider " + entityId + " that the user is not logged into"));
            }
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/error.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        if (samlSloRequestInfo.getStatus() == 2) {
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, entityId);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (singleLogoutService == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Single logout not supported by " + entityId));
            }
            samlSloRequestInfo.setStatus(4);
            samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding");
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            try {
                this.sendIdpLogoutRequest(httpServletRequest, httpServletResponse, samlSloContext, samlSloRequestInfo);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(7);
                    sb.append("Unable to perform a single logout for service ");
                    sb.append("provider ");
                    sb.append(entityId);
                    sb.append(" with binding ");
                    sb.append(singleLogoutService.getBinding());
                    sb.append(" to ");
                    sb.append(singleLogoutService.getLocation());
                    _log.debug((Object)sb.toString(), (Throwable)exception);
                }
                samlSloRequestInfo.setStatus(3);
                samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
                httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
                JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            }
        }
    }

    protected void performIdpStatus(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
            DateTime initiateDateTime;
            DateTime expireDateTime;
            int status = samlRequestInfo.getStatus();
            if (status != 1 || !(expireDateTime = (initiateDateTime = samlRequestInfo.getInitiateTime()).plusSeconds(10)).isBeforeNow()) continue;
            samlRequestInfo.setStatus(5);
            samlRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
        }
        httpServletResponse.setContentType("text/javascript");
        PrintWriter writer = httpServletResponse.getWriter();
        JSONObject jsonObject = samlSloContext.toJSONObject();
        ((Writer)writer).write(jsonObject.toString());
    }

    protected void processIdpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(httpServletRequest, messageContext);
        if (samlSloContext == null) {
            this.sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", new SamlSloContext(null, messageContext, this._samlIdpSpConnectionLocalService, this._samlIdpSpSessionLocalService, this._userLocalService));
            return;
        }
        Set<String> samlSpEntityIds = samlSloContext.getSamlSpEntityIds();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        String binding = samlBindingContext.getBindingUri();
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            this.sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", samlSloContext);
        } else if (!samlSpEntityIds.isEmpty()) {
            this.initiateIdpSingleLogout(httpServletRequest, httpServletResponse);
        } else {
            this.sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:Success", samlSloContext);
        }
    }

    protected void processIdpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(httpServletRequest, null);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        if (samlSloContext == null) {
            throw new UnsolicitedLogoutResponseException("Received logout response from " + samlPeerEntityContext.getEntityId() + " without an active SSO session");
        }
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutResponse logoutResponse = (LogoutResponse)inboundMessageContext.getMessage();
        Issuer issuer = logoutResponse.getIssuer();
        String entityId = issuer.getValue();
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            throw new UnsolicitedLogoutResponseException("Received unsolicited logout response from " + samlPeerEntityContext.getEntityId());
        }
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        samlSloRequestInfo.setStatusCode(statusCode.getValue());
        httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
        JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
    }

    protected void processSingleLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.processIdpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.processSpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
        }
    }

    protected void processSingleLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.processIdpLogoutResponse(httpServletRequest, httpServletResponse, messageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.processSpLogoutResponse(httpServletRequest, httpServletResponse);
        }
    }

    protected void processSpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        SamlSpSession samlSpSession;
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutRequest logoutRequest = (LogoutRequest)inboundMessageContext.getMessage();
        NameID nameID = logoutRequest.getNameID();
        List sessionIndexes = logoutRequest.getSessionIndexes();
        String statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:Success";
        if (sessionIndexes.isEmpty()) {
            List samlSpSessions = this.samlSpSessionLocalService.getSamlSpSessions(nameID.getValue());
            if (samlSpSessions.isEmpty()) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
            }
            Iterator iterator = samlSpSessions.iterator();
            while (iterator.hasNext()) {
                samlSpSession = (SamlSpSession)iterator.next();
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            }
        }
        for (SessionIndex sessionIndex : sessionIndexes) {
            samlSpSession = this.samlSpSessionLocalService.fetchSamlSpSessionBySessionIndex(sessionIndex.getSessionIndex());
            if (samlSpSession == null) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
                continue;
            }
            if (Objects.equals(samlSpSession.getNameIdValue(), nameID.getValue()) && Objects.equals(samlSpSession.getNameIdFormat(), nameID.getFormat())) {
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            } else if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:PartialLogout")) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
                continue;
            }
            if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal")) continue;
            statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:PartialLogout";
        }
        LogoutResponse logoutResponse = OpenSamlUtil.buildLogoutResponse();
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SSODescriptor ssoDescriptor = (SSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        OpenSamlUtil.prepareSecurityParametersContext(this.metadataManager.getSigningCredential(), securityParametersContext, (RoleDescriptor)ssoDescriptor);
        outboundMessageContext.setMessage((Object)logoutResponse);
        logoutResponse.setID(this.generateIdentifier(20));
        logoutResponse.setInResponseTo(logoutRequest.getID());
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId());
        logoutResponse.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusCodeURI);
        Status status = OpenSamlUtil.buildStatus(statusCode);
        logoutResponse.setStatus(status);
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(ssoDescriptor, samlBindingContext.getBindingUri());
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)singleLogoutService);
        logoutResponse.setDestination(singleLogoutService.getLocation());
        outboundMessageContext.addSubcontext((BaseContext)samlSelfEntityContext);
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    protected void processSpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.redirectToLogout(httpServletRequest, httpServletResponse);
    }

    protected void redirectToLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.terminateSsoSession(httpServletRequest, httpServletResponse);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.terminateSpSession(httpServletRequest, httpServletResponse);
        }
        String portalURL = this.portal.getPortalURL(httpServletRequest);
        String redirect = portalURL.concat(this.portal.getPathMain()).concat("/portal/logout");
        httpServletResponse.sendRedirect(redirect);
    }

    protected void sendAsyncLogoutRequest(MessageContext<LogoutRequest> messageContext, SamlSloContext samlSloContext, HttpServletResponse httpServletResponse) throws Exception {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class);
        SingleLogoutService singleLogoutService = (SingleLogoutService)samlPeerEndpointContext.getEndpoint();
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId());
        logoutRequest.setIssuer(issuer);
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
        logoutRequest.setNameID(samlSubjectNameIdentifierContext.getSAML2SubjectNameID());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSloContext.getSamlSsoSessionId());
        messageContext.setMessage((Object)logoutRequest);
        Credential credential = this.metadataManager.getSigningCredential();
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        RoleDescriptor roleDescriptor = samlMetadataContext.getRoleDescriptor();
        OpenSamlUtil.signObject((SignableSAMLObject)logoutRequest, credential, roleDescriptor);
        SamlBinding samlBinding = this.getSamlBinding(singleLogoutService.getBinding());
        Supplier<HttpServletResponseMessageEncoder> httpServletResponseMessageEncoderSupplier = samlBinding.getHttpServletResponseMessageEncoderSupplier();
        HttpServletResponseMessageEncoder httpServletResponseMessageEncoder = httpServletResponseMessageEncoderSupplier.get();
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
        OpenSamlUtil.prepareSecurityParametersContext(credential, securityParametersContext, roleDescriptor);
        httpServletResponseMessageEncoder.setHttpServletResponse(httpServletResponse);
        httpServletResponseMessageEncoder.setMessageContext(messageContext);
        httpServletResponseMessageEncoder.initialize();
        httpServletResponseMessageEncoder.encode();
    }

    protected void sendIdpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext, SamlSloRequestInfo samlSloRequestInfo) throws Exception {
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, samlSloRequestInfo.getEntityId());
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMetadataContext.getRoleDescriptor();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)singleLogoutService);
        SamlIdpSpSession samlIdpSpSession = samlSloRequestInfo.getSamlIdpSpSession();
        NameID nameID = OpenSamlUtil.buildNameId(samlIdpSpSession.getNameIdFormat(), samlIdpSpSession.getNameIdValue());
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class, true);
        samlSubjectNameIdentifierContext.setSubjectNameIdentifier((SAMLObject)nameID);
        samlSloRequestInfo.setInitiateTime(new DateTime(DateTimeZone.UTC));
        samlSloRequestInfo.setStatus(1);
        String binding = singleLogoutService.getBinding();
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            String statusCode = this.sendSyncLogoutRequest(messageContext, samlSloContext);
            samlSloRequestInfo.setStatusCode(statusCode);
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            this.sendAsyncLogoutRequest(messageContext, samlSloContext, httpServletResponse);
        }
    }

    protected void sendIdpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String statusCodeURI, SamlSloContext samlSloContext) throws Exception {
        LogoutResponse logoutResponse = OpenSamlUtil.buildLogoutResponse();
        MessageContext<?> messageContext = samlSloContext.getMessageContext();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SSODescriptor ssoDescriptor = (SSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(ssoDescriptor, samlBindingContext.getBindingUri());
        logoutResponse.setDestination(singleLogoutService.getLocation());
        logoutResponse.setID(this.generateIdentifier(20));
        LogoutRequest logoutRequest = (LogoutRequest)inboundMessageContext.getMessage();
        logoutResponse.setInResponseTo(logoutRequest.getID());
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId());
        logoutResponse.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusCodeURI);
        Status status = OpenSamlUtil.buildStatus(statusCode);
        logoutResponse.setStatus(status);
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.setMessage((Object)logoutResponse);
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        OpenSamlUtil.prepareSecurityParametersContext(this.metadataManager.getSigningCredential(), securityParametersContext, (RoleDescriptor)ssoDescriptor);
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)outboundMessageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)singleLogoutService);
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding")) {
            this.terminateSsoSession(httpServletRequest, httpServletResponse);
            this.logout(httpServletRequest, httpServletResponse);
        }
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    protected void sendSpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
        if (samlSpSession == null || samlSpSession.isTerminated()) {
            this.redirectToLogout(httpServletRequest, httpServletResponse);
            return;
        }
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        String entityId = samlSpSession.getSamlIdpEntityId();
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, entityId);
        InOutOperationContext inOutOperationContext = new InOutOperationContext(new MessageContext(), new MessageContext());
        messageContext.addSubcontext((BaseContext)inOutOperationContext);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.setMessage((Object)logoutRequest);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class, true);
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        logoutRequest.setIssueInstant(issueInstantDateTime);
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId());
        outboundMessageContext.addSubcontext((BaseContext)samlSelfEntityContext);
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        OpenSamlUtil.prepareSecurityParametersContext(this.metadataManager.getSigningCredential(), securityParametersContext, (RoleDescriptor)idpSSODescriptor);
        logoutRequest.setIssuer(issuer);
        NameID nameID = OpenSamlUtil.buildNameId(samlSpSession.getNameIdFormat(), samlSpSession.getNameIdNameQualifier(), samlSpSession.getNameIdSPNameQualifier(), samlSpSession.getNameIdValue());
        logoutRequest.setNameID(nameID);
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSpSession.getSessionIndex());
        SAMLEndpointContext samlPeerEndpointSubcontext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointSubcontext.setEndpoint((Endpoint)singleLogoutService);
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    protected String sendSyncLogoutRequest(MessageContext<?> messageContext, SamlSloContext samlSloContext) throws Exception {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointSubcontext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class);
        SingleLogoutService singleLogoutService = (SingleLogoutService)samlPeerEndpointSubcontext.getEndpoint();
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId());
        logoutRequest.setIssuer(issuer);
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
        logoutRequest.setNameID(samlSubjectNameIdentifierContext.getSAML2SubjectNameID());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSloContext.getSamlSsoSessionId());
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEndpointSubcontext);
        outboundMessageContext.setMessage((Object)logoutRequest);
        Credential credential = this.metadataManager.getSigningCredential();
        SecurityParametersContext securityParametersContext = (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        RoleDescriptor roleDescriptor = samlPeerMetadataContext.getRoleDescriptor();
        OpenSamlUtil.prepareSecurityParametersContext(credential, securityParametersContext, roleDescriptor);
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)outboundMessageContext.getSubcontext(SAMLProtocolContext.class);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        OpenSamlUtil.signObject((SignableSAMLObject)logoutRequest, credential, roleDescriptor);
        final SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        PipelineFactoryHttpSOAPClient pipelineFactoryHttpSOAPClient = new PipelineFactoryHttpSOAPClient();
        pipelineFactoryHttpSOAPClient.setPipelineFactory((HttpClientMessagePipelineFactory)new HttpClientMessagePipelineFactory<Object, Object>(){

            @Nonnull
            public HttpClientMessagePipeline<Object, Object> newInstance() {
                Supplier<HttpServletResponseMessageEncoder> httpServletResponseMessageEncoderSupplier = samlBinding.getHttpServletResponseMessageEncoderSupplier();
                Supplier<HttpServletRequestMessageDecoder> httpServletResponseMessageDecoder = samlBinding.getHttpServletRequestMessageDecoderSupplier();
                return new BasicHttpClientMessagePipeline((MessageEncoder)httpServletResponseMessageEncoderSupplier.get(), (MessageDecoder)httpServletResponseMessageDecoder.get());
            }

            @Nonnull
            public HttpClientMessagePipeline<Object, Object> newInstance(@Nullable String pipelineName) {
                return this.newInstance();
            }
        });
        pipelineFactoryHttpSOAPClient.setHttpClient(this._httpClient);
        pipelineFactoryHttpSOAPClient.initialize();
        pipelineFactoryHttpSOAPClient.send(singleLogoutService.getLocation(), inOutOperationContext);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutResponse logoutResponse = (LogoutResponse)inboundMessageContext.getMessage();
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        return statusCode.getValue();
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this.portal = portal;
    }

    @Reference(unbind="-")
    protected void setSamlHttpRequestUtil(SamlHttpRequestUtil samlHttpRequestUtil) {
        this._samlHttpRequestUtil = samlHttpRequestUtil;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSpConnectionLocalService(SamlIdpSpConnectionLocalService samlIdpSpConnectionLocalService) {
        this._samlIdpSpConnectionLocalService = samlIdpSpConnectionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSpSessionLocalService(SamlIdpSpSessionLocalService samlIdpSpSessionLocalService) {
        this._samlIdpSpSessionLocalService = samlIdpSpSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSsoSessionLocalService(SamlIdpSsoSessionLocalService samlIdpSsoSessionLocalService) {
        this._samlIdpSsoSessionLocalService = samlIdpSsoSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlSpSessionLocalService(SamlSpSessionLocalService samlSpSessionLocalService) {
        this.samlSpSessionLocalService = samlSpSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

