/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupModel;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={AttributeResolver.class})
public class DefaultAttributeResolver
implements AttributeResolver {
    private static final String _SALESFORCE_ENTITY_ID = "https://saml.salesforce.com";
    private static final Log _log = LogFactoryUtil.getLog(DefaultAttributeResolver.class);
    private GroupLocalService _groupLocalService;
    private MetadataManager _metadataManager;
    private RoleLocalService _roleLocalService;
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    @Override
    public void resolve(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher) {
        String entityId = attributeResolverSAMLContext.resolvePeerEntityId();
        boolean namespaceEnabled = this._metadataManager.isAttributesNamespaceEnabled(entityId);
        for (String attributeName : this.getAttributeNames(entityId)) {
            if (attributeName.startsWith("expando:")) {
                attributeName = attributeName.substring(8);
                this.addExpandoAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("groups")) {
                this.addGroupsAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.startsWith("map:")) {
                attributeName = attributeName.substring(4);
                this.addMapAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizations")) {
                this.addOrganizationsAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizationRoles")) {
                this.addOrganizationRolesAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("roles")) {
                this.addRolesAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.startsWith("static:")) {
                attributeName = attributeName.substring(7);
                this.addStaticAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("siteRoles") || attributeName.equals("userGroupRoles")) {
                this.addSiteRolesAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("userGroups")) {
                this.addUserGroupsAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
                continue;
            }
            this.addUserAttribute(user, attributeResolverSAMLContext, attributePublisher, attributeName, namespaceEnabled);
        }
        if (this.isPeerSalesForce(entityId)) {
            this.addSalesForceAttributes(attributeResolverSAMLContext, attributePublisher);
        }
    }

    @Reference(unbind="-")
    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        this._metadataManager = metadataManager;
    }

    @Reference(unbind="-")
    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    public void setUserGroupGroupRoleLocalService(UserGroupGroupRoleLocalService userGroupGroupRoleLocalService) {
        this._userGroupGroupRoleLocalService = userGroupGroupRoleLocalService;
    }

    @Reference(unbind="-")
    public void setUserGroupRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        this._userGroupRoleLocalService = userGroupRoleLocalService;
    }

    protected void addExpandoAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        ExpandoBridge expandoBridge = user.getExpandoBridge();
        Serializable value = expandoBridge.getAttribute(attributeName, false);
        if (!namespaceEnabled) {
            attributePublisher.publish(attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(value.toString()));
        } else {
            attributePublisher.publish("urn:liferay:user:expando:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(value.toString()));
        }
    }

    protected void addGroupsAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            List groups = user.getGroups();
            if (groups.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:groups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "groups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream groupsStream = groups.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])groupsStream.map(GroupModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get groups for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected void addMapAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        if (attributeName.indexOf("=") <= 0) {
            return;
        }
        String[] values = StringUtil.split((String)attributeName, (String)"=");
        if (values.length > 2) {
            return;
        }
        String attributeValue = BeanPropertiesUtil.getString((Object)user, (String)values[1]);
        if (namespaceEnabled) {
            attributePublisher.publish(values[0], "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(attributeValue));
        } else {
            attributePublisher.publish(values[0], "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(attributeValue));
        }
    }

    protected void addOrganizationRolesAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, Set> groupRoles = new HashMap<String, Set>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() != 3) continue;
                Group group = userGroupRole.getGroup();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(userGroupRole.getRole());
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                String name = null;
                String nameFormat = null;
                if (namespaceEnabled) {
                    name = "urn:liferay:organizationRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
                } else {
                    name = "organizationRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
                }
                Set roles = (Set)entry.getValue();
                Stream rolesStream = roles.stream();
                attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])rolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
            }
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get organization roles for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected void addOrganizationsAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher publisher, String attributeName, boolean namespaceEnabled) {
        try {
            List organizations = user.getOrganizations();
            if (organizations.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:organizations";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "organizations";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream organizationsStream = organizations.stream();
            publisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])organizationsStream.map(OrganizationModel::getName).map(publisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get organizations for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected void addRolesAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            List roles = user.getRoles();
            List groups = user.getGroups();
            List organizations = user.getOrganizations();
            List userGroups = user.getUserGroups();
            List inheritedSiteGroups = this._groupLocalService.getUserGroupsRelatedGroups(userGroups);
            List organizationsRelatedGroups = Collections.emptyList();
            if (!organizations.isEmpty()) {
                organizationsRelatedGroups = this._groupLocalService.getOrganizationsRelatedGroups(organizations);
                for (Group group : organizationsRelatedGroups) {
                    if (inheritedSiteGroups.contains(group)) continue;
                    inheritedSiteGroups.add(group);
                }
            }
            ArrayList allGroups = new ArrayList();
            allGroups.addAll(groups);
            allGroups.addAll(inheritedSiteGroups);
            allGroups.addAll(organizationsRelatedGroups);
            allGroups.addAll(this._groupLocalService.getOrganizationsGroups(organizations));
            allGroups.addAll(this._groupLocalService.getUserGroupsGroups(userGroups));
            HashSet uniqueRoles = new HashSet();
            uniqueRoles.addAll(roles);
            for (Group group : allGroups) {
                if (!this._roleLocalService.hasGroupRoles(group.getGroupId())) continue;
                List groupRoles = this._roleLocalService.getGroupRoles(group.getGroupId());
                uniqueRoles.addAll(groupRoles);
            }
            if (uniqueRoles.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:roles";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "roles";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream uniqueRolesStream = uniqueRoles.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])uniqueRolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get roles for user  ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected void addSalesForceAttributes(AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher) {
        String samlIdpMetadataSalesForceLogoutURL = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.logout.url"));
        attributePublisher.publish("logoutURL", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(samlIdpMetadataSalesForceLogoutURL));
        String samlIdpMetadataSalesForceSsoStartPage = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.sso.start.page"));
        List<String> locations = attributeResolverSAMLContext.resolveSsoServicesLocationForBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        if (!locations.isEmpty()) {
            samlIdpMetadataSalesForceSsoStartPage = locations.get(0);
        }
        attributePublisher.publish("ssoStartPage", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(samlIdpMetadataSalesForceSsoStartPage));
    }

    protected void addSiteRolesAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            Group group;
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, Set> groupRoles = new HashMap<String, Set>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() == 3 && !attributeName.equals("userGroupRoles")) continue;
                group = userGroupRole.getGroup();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(userGroupRole.getRole());
            }
            List inheritedSiteRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByUser(user.getUserId());
            for (UserGroupGroupRole userGroupGroupRole : inheritedSiteRoles) {
                group = userGroupGroupRole.getGroup();
                Role role = userGroupGroupRole.getRole();
                Set roles = groupRoles.computeIfAbsent(group.getName(), k -> new HashSet());
                roles.add(role);
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                String name = null;
                String nameFormat = null;
                if (namespaceEnabled) {
                    name = attributeName.equals("siteRoles") ? "urn:liferay:siteRole:" + groupName : "urn:liferay:userGroupRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
                } else {
                    name = attributeName.equals("siteRoles") ? "siteRole:" + groupName : "userGroupRole:" + groupName;
                    nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
                }
                Set roles = (Set)entry.getValue();
                Stream rolesStream = roles.stream();
                attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])rolesStream.map(RoleModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
            }
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get user group roles for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected void addStaticAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        String attributeValue = "";
        if (attributeName.indexOf(61) > 0) {
            String[] values = StringUtil.split((String)attributeName, (String)"=");
            attributeName = values[0];
            attributeValue = values[1];
            if (values.length > 2) {
                for (int i = 2; i < values.length; ++i) {
                    attributeValue = attributeValue.concat("=").concat(values[i]);
                }
            }
        }
        String nameFormat = null;
        nameFormat = namespaceEnabled ? "urn:oasis:names:tc:SAML:2.0:attrname-format:uri" : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        attributePublisher.publish(attributeName, nameFormat, attributePublisher.buildString(attributeValue));
    }

    protected void addUserAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        Serializable value = (Serializable)BeanPropertiesUtil.getObject((Object)user, (String)attributeName);
        if (!namespaceEnabled) {
            attributePublisher.publish(attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", attributePublisher.buildString(value.toString()));
        } else {
            attributePublisher.publish("urn:liferay:user:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", attributePublisher.buildString(value.toString()));
        }
    }

    protected void addUserGroupsAttribute(User user, AttributeResolver.AttributeResolverSAMLContext attributeResolverSAMLContext, AttributeResolver.AttributePublisher attributePublisher, String attributeName, boolean namespaceEnabled) {
        try {
            List userGroups = user.getUserGroups();
            if (userGroups.isEmpty()) {
                return;
            }
            String name = null;
            String nameFormat = null;
            if (namespaceEnabled) {
                name = "urn:liferay:userGroups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
            } else {
                name = "userGroups";
                nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            Stream userGroupsStream = userGroups.stream();
            attributePublisher.publish(name, nameFormat, (AttributeResolver.AttributePublisher.AttributeValue[])userGroupsStream.map(UserGroupModel::getName).map(attributePublisher::buildString).toArray(AttributeResolver.AttributePublisher.AttributeValue[]::new));
        }
        catch (Exception exception) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get user groups for user ", user.getUserId(), ": ", exception.getMessage()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    protected String[] getAttributeNames(String entityId) {
        return this._metadataManager.getAttributeNames(entityId);
    }

    protected boolean isPeerSalesForce(String entityId) {
        if (entityId.equals(_SALESFORCE_ENTITY_ID)) {
            return true;
        }
        return GetterUtil.getBoolean((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.attributes.enabled", (Filter)new Filter(entityId)));
    }
}

