/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.runtime.configuration.SamlConfiguration;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.util.Map;

public abstract class BaseKeyStoreManagerImpl
implements KeyStoreManager {
    protected SamlConfiguration samlConfiguration;

    protected long getCompanyId() {
        return CompanyThreadLocal.getCompanyId();
    }

    protected String getSamlKeyStorePassword() {
        return this.samlConfiguration.keyStorePassword();
    }

    protected String getSamlKeyStorePath() {
        String keyStorePath = this.samlConfiguration.keyStorePath();
        String liferayHome = PropsUtil.get((String)"liferay.home");
        if (Validator.isNull((String)keyStorePath)) {
            return liferayHome.concat("/data/keystore.jks");
        }
        return StringUtil.replace((String)keyStorePath, (String)"${liferay.home}", (String)liferayHome);
    }

    protected String getSamlKeyStoreType() {
        return this.samlConfiguration.keyStoreType();
    }

    protected void updateConfigurations(Map<String, Object> properties) throws Exception {
        this.samlConfiguration = (SamlConfiguration)ConfigurableUtil.createConfigurable(SamlConfiguration.class, properties);
    }
}

