/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.bootstrap;

import com.liferay.saml.opensaml.integration.internal.bootstrap.OpenSamlBootstrap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(service={SecurityConfigurationBootstrap.class})
public class SecurityConfigurationBootstrap {
    @Reference
    private OpenSamlBootstrap _openSamlBootstrap;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        BasicDecryptionConfiguration basicDecryptionConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultDecryptionConfiguration();
        BasicEncryptionConfiguration basicEncryptionConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        BasicSignatureSigningConfiguration basicSignatureSigningConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        BasicSignatureValidationConfiguration basicSignatureValidationConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureValidationConfiguration();
        Object blacklistedAlgorithmsObject = properties.get("blacklisted.algorithms");
        if (blacklistedAlgorithmsObject instanceof String[]) {
            basicDecryptionConfiguration.setBlacklistedAlgorithms(this._combine(basicDecryptionConfiguration.getBlacklistedAlgorithms(), (String[])blacklistedAlgorithmsObject));
            basicEncryptionConfiguration.setBlacklistedAlgorithms(this._combine(basicEncryptionConfiguration.getBlacklistedAlgorithms(), (String[])blacklistedAlgorithmsObject));
            basicSignatureSigningConfiguration.setBlacklistedAlgorithms(this._combine(basicSignatureSigningConfiguration.getBlacklistedAlgorithms(), (String[])blacklistedAlgorithmsObject));
            basicSignatureValidationConfiguration.setBlacklistedAlgorithms(this._combine(basicSignatureValidationConfiguration.getBlacklistedAlgorithms(), (String[])blacklistedAlgorithmsObject));
        }
        ConfigurationService.register(DecryptionConfiguration.class, (Object)basicDecryptionConfiguration);
        ConfigurationService.register(EncryptionConfiguration.class, (Object)basicEncryptionConfiguration);
        ConfigurationService.register(SignatureSigningConfiguration.class, (Object)basicSignatureSigningConfiguration);
        ConfigurationService.register(SignatureValidationConfiguration.class, (Object)basicSignatureValidationConfiguration);
    }

    private Collection<String> _combine(Collection<String> collection, String ... strings) {
        HashSet<String> combinedCollection = new HashSet<String>(collection);
        Collections.addAll(combinedCollection, strings);
        return combinedCollection;
    }
}

