/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.credential.BaseKeyStoreManagerImpl;
import com.liferay.saml.opensaml.integration.internal.credential.FileWatcher;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, immediate=true, property={"default=true"}, service={KeyStoreManager.class})
public class FileSystemKeyStoreManagerImpl
extends BaseKeyStoreManagerImpl {
    private static final Log _log = LogFactoryUtil.getLog(FileSystemKeyStoreManagerImpl.class);
    private KeyStore _keyStore;
    private volatile KeyStoreException _keyStoreException;
    private volatile FileWatcher _samlKeyStoreFileWatcher;

    @Activate
    public void activate(Map<String, Object> properties) throws Exception {
        this.updateConfigurations(properties);
        String samlKeyStoreType = this.getSamlKeyStoreType();
        try {
            this._keyStore = KeyStore.getInstance(samlKeyStoreType);
        }
        catch (KeyStoreException kse) {
            String message = StringBundler.concat((String[])new String[]{"Unable instantiate keystore with type ", samlKeyStoreType, ": ", kse.getMessage()});
            this._keyStoreException = new KeyStoreException(message, kse);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)kse);
            } else {
                _log.error((Object)message);
            }
            return;
        }
        this.loadKeyStore();
    }

    public KeyStore getKeyStore() throws KeyStoreException {
        if (this._keyStoreException != null) {
            throw this._keyStoreException;
        }
        return this._keyStore;
    }

    public void saveKeyStore(KeyStore keyStore) throws Exception {
        File samlKeyStoreFile = new File(this.getSamlKeyStorePath());
        if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
            File parentDir;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Creating a new SAML keystore at " + samlKeyStoreFile));
            }
            if (!(parentDir = samlKeyStoreFile.getParentFile()).exists()) {
                parentDir.mkdirs();
            }
        }
        this.monitorFile(samlKeyStoreFile);
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        try (FileOutputStream fileOutputStream = new FileOutputStream(samlKeyStoreFile);){
            this._keyStore.store(fileOutputStream, samlKeyStorePassword.toCharArray());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._samlKeyStoreFileWatcher == null) {
            return;
        }
        try {
            this._samlKeyStoreFileWatcher.close();
        }
        catch (Exception e) {
            String message = "Unable to close file watcher: " + e.getMessage();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)e);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
        }
        finally {
            this._samlKeyStoreFileWatcher = null;
        }
    }

    protected void doLoadKeyStore() throws Exception {
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        try (InputStream inputStream = this._getInputStream();){
            this._keyStore.load(inputStream, samlKeyStorePassword.toCharArray());
        }
    }

    protected void loadKeyStore() {
        try {
            this._keyStoreException = null;
            this.doLoadKeyStore();
        }
        catch (Exception e) {
            String message = StringBundler.concat((String[])new String[]{"Unable to load SAML keystore ", this.getSamlKeyStorePath(), ": ", e.getMessage()});
            this._keyStoreException = new KeyStoreException(message, e);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)e);
            }
            _log.error((Object)message);
        }
    }

    protected void monitorFile(File samlKeyStoreFile) throws IOException {
        if (this._samlKeyStoreFileWatcher != null) {
            return;
        }
        this._samlKeyStoreFileWatcher = new FileWatcher(ev -> this.loadKeyStore(), samlKeyStoreFile.toPath());
    }

    private InputStream _getInputStream() throws Exception {
        String samlKeyStorePath = this.getSamlKeyStorePath();
        if (samlKeyStorePath.startsWith("classpath:")) {
            Class<?> clazz = this.getClass();
            return clazz.getResourceAsStream(samlKeyStorePath.substring(10));
        }
        File samlKeyStoreFile = new File(samlKeyStorePath);
        if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
            if (Validator.isNotNull((String)this.samlConfiguration.keyStorePath()) && !"${liferay.home}/data/keystore.jks".equals(this.samlConfiguration.keyStorePath()) && _log.isWarnEnabled()) {
                _log.warn((Object)("No SAML keystore exists at " + samlKeyStoreFile));
            }
            return null;
        }
        this.monitorFile(samlKeyStoreFile);
        return new FileInputStream(samlKeyStoreFile);
    }
}

