/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.decryption;

import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.util.Collections;
import java.util.Dictionary;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class DecrypterRegistrator {
    private ServiceRegistration<Decrypter> _decrypterServiceRegistration;
    @Reference
    private MetadataManager _metadataManager;
    @Reference
    private ParserPool _parserPool;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;

    @Activate
    protected void activate(BundleContext bundleContext) throws ResolverException {
        BasicDecryptionParametersResolver decryptionParametersResolver = new BasicDecryptionParametersResolver();
        DecryptionParameters decryptionParameters = (DecryptionParameters)decryptionParametersResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{SecurityConfigurationSupport.getGlobalDecryptionConfiguration()})}));
        if (decryptionParameters == null) {
            throw new ResolverException("Unable to resolve decryption parameters from the configuration");
        }
        decryptionParameters.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)new DefaultKeyInfoCredentialResolver());
        CustomParserPoolDecrypter decrypter = new CustomParserPoolDecrypter(decryptionParameters);
        decrypter.setRootInNewDocument(true);
        this._decrypterServiceRegistration = bundleContext.registerService(Decrypter.class, (Object)decrypter, (Dictionary)new HashMapDictionary<String, Object>(){
            {
                this.put("service.ranking", Integer.MIN_VALUE);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._decrypterServiceRegistration.unregister();
    }

    private class DefaultKeyInfoCredentialResolver
    implements KeyInfoCredentialResolver {
        private DefaultKeyInfoCredentialResolver() {
        }

        public Iterable<Credential> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public Credential resolveSingle(CriteriaSet criteria) throws ResolverException {
            try {
                return DecrypterRegistrator.this._metadataManager.getEncryptionCredential();
            }
            catch (SamlException se) {
                throw new ResolverException((Exception)((Object)se));
            }
        }
    }

    private class CustomParserPoolDecrypter
    extends Decrypter {
        public CustomParserPoolDecrypter(DecryptionParameters decryptionParameters) {
            super(decryptionParameters);
        }

        protected ParserPool buildParserPool() {
            return DecrypterRegistrator.this._parserPool;
        }
    }
}

