/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class FileWatcher
implements Closeable {
    private final Consumer<WatchEvent<Path>> _consumer;
    private final ExecutorService _notificationsExecutorService;
    private final List<Path> _paths;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final WatchService _watchService;

    public FileWatcher(Consumer<WatchEvent<Path>> consumer, ExecutorService notificationsExecutorService, long notificationTimeout, TimeUnit notificationTimeUnit, Path ... paths) throws IOException {
        this(consumer, Executors.newScheduledThreadPool(1), 1L, 1L, TimeUnit.SECONDS, notificationsExecutorService, notificationTimeout, notificationTimeUnit, paths);
    }

    public FileWatcher(Consumer<WatchEvent<Path>> consumer, Path ... paths) throws IOException {
        this(consumer, Executors.newScheduledThreadPool(1), 1L, 1L, TimeUnit.SECONDS, Executors.newSingleThreadExecutor(), 10L, TimeUnit.SECONDS, paths);
    }

    public FileWatcher(Consumer<WatchEvent<Path>> consumer, ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit units, ExecutorService notificationsExecutorService, long notificationTimeout, TimeUnit notificationTimeUnit, Path ... paths) throws IOException {
        this._consumer = consumer;
        this._scheduledExecutorService = scheduledExecutorService;
        this._notificationsExecutorService = notificationsExecutorService;
        this._paths = Arrays.asList(paths);
        FileSystem fileSystem = FileSystems.getDefault();
        this._watchService = fileSystem.newWatchService();
        for (Path path : this._paths) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                path = path.getParent();
            }
            path.register(this._watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        this._scheduledExecutorService.scheduleAtFixedRate(() -> {
            WatchKey watchKey = null;
            try {
                watchKey = this._watchService.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                return;
            }
            if (watchKey == null || !watchKey.isValid()) {
                return;
            }
            List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
            Stream pathsStream = this._paths.stream();
            Stream watchEventsStream = watchEvents.stream();
            Stream<Runnable> watchEventsPathStream = pathsStream.flatMap(path -> watchEventsStream.map(watchEvent -> watchEvent).filter(watchEvent -> {
                Path contextPath = (Path)watchEvent.context();
                return contextPath.endsWith(path.getFileName());
            }));
            CompletableFuture[] completableFutures = (CompletableFuture[])watchEventsPathStream.map(watchEvent -> () -> this._consumer.accept((WatchEvent<Path>)watchEvent)).map(runnable -> CompletableFuture.runAsync(runnable, notificationsExecutorService)).toArray(CompletableFuture[]::new);
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(completableFutures);
            try {
                completableFuture.get(notificationTimeout, notificationTimeUnit);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return;
            }
            watchKey.reset();
        }, initialDelay, period, units);
    }

    @Override
    public void close() {
        try {
            this._watchService.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._notificationsExecutorService.shutdown();
        this._scheduledExecutorService.shutdownNow();
    }
}

