/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverSAMLCommand;
import com.liferay.saml.opensaml.integration.internal.resolver.SAMLCommandImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.UserResolverSAMLCommand;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import com.liferay.saml.opensaml.integration.resolver.Resolver;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

public interface SAMLCommands {
    public static final Resolver.SAMLCommand<String, Resolver> peerEntityId = new SAMLCommandImpl(messageContext -> {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, false);
        return samlPeerEntityContext.getEntityId();
    });
    public static final Resolver.SAMLCommand<String, Resolver> subjectNameFormat = new SAMLCommandImpl(messageContext -> {
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class, false);
        NameID nameID = samlSubjectNameIdentifierContext.getSAML2SubjectNameID();
        if (nameID == null) {
            return null;
        }
        return nameID.getFormat();
    });
    public static final Resolver.SAMLCommand<String, Resolver> subjectNameIdentifier = new SAMLCommandImpl(messageContext -> {
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class, false);
        NameID nameID = samlSubjectNameIdentifierContext.getSAML2SubjectNameID();
        if (nameID == null) {
            return null;
        }
        return nameID.getValue();
    });

    public static Resolver.SAMLCommand<Map<String, List<Serializable>>, UserResolver> bearerAssertionAttributesWithMapping(Properties userAttributeMappingsProperties) {
        return new UserResolverSAMLCommand<Map<String, List<Serializable>>, UserResolver>((Function<MessageContext<Response>, Map<String, List<Serializable>>>)((Function<MessageContext, Map>)messageContext -> {
            InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
            if (inOutOperationContext == null) {
                return Collections.emptyMap();
            }
            MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
            if (inboundMessageContext == null) {
                return Collections.emptyMap();
            }
            Response response = (Response)inboundMessageContext.getMessage();
            if (response == null) {
                return Collections.emptyMap();
            }
            List assertions = response.getAssertions();
            Stream assertionsStream = assertions.stream();
            List<Attribute> bearerAssertionAttributes = assertionsStream.filter(assertion -> {
                Subject subject = assertion.getSubject();
                if (subject == null) {
                    return false;
                }
                List subjectConfirmations = subject.getSubjectConfirmations();
                if (subjectConfirmations == null) {
                    return false;
                }
                Stream subjectConfirmationsStream = subjectConfirmations.stream();
                long count = subjectConfirmationsStream.filter(subjectConfirmation -> "urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())).count();
                return count > 0L;
            }).map(Assertion::getAttributeStatements).flatMap(Collection::stream).map(AttributeStatement::getAttributes).flatMap(Collection::stream).collect(Collectors.toList());
            return SamlUtil.getAttributesMap(bearerAssertionAttributes, userAttributeMappingsProperties);
        }));
    }

    public static Resolver.SAMLCommand<List<String>, AttributeResolver> ssoServicesLocationForBinding(String binding) {
        return new AttributeResolverSAMLCommand<List<String>, AttributeResolver>((Function<MessageContext<AuthnRequest>, List<String>>)((Function<MessageContext, List>)messageContext -> {
            SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)messageContext.getSubcontext(SAMLMetadataContext.class, false);
            IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlMetadataContext.getRoleDescriptor();
            if (idpSSODescriptor == null) {
                return null;
            }
            List singleSignOnServices = idpSSODescriptor.getSingleSignOnServices();
            if (singleSignOnServices == null) {
                return null;
            }
            Stream singleSignOnServicesStream = singleSignOnServices.stream();
            return singleSignOnServicesStream.filter(ssos -> binding.equals(ssos.getBinding())).map(Endpoint::getLocation).collect(Collectors.toList());
        }));
    }
}

