/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.saml.opensaml.integration.internal.resolver.DefaultServiceReferenceMapper;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NameIdResolverRegistry.class})
public class NameIdResolverRegistry {
    private static final Log _log = LogFactoryUtil.getLog(NameIdResolverRegistry.class);
    private NameIdResolver _defaultNameIdResolver;
    private ServiceTrackerMap<String, NameIdResolver> _nameIdResolvers;

    public NameIdResolver getNameIdResolver(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        NameIdResolver nameIdResolver = (NameIdResolver)this._nameIdResolvers.getService((Object)(companyId + "," + entityId));
        if (nameIdResolver == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No attribute resolver for company ID " + companyId + " and entity ID " + entityId));
            }
            nameIdResolver = this._defaultNameIdResolver;
        }
        return nameIdResolver;
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, target="(!(companyId=*))", unbind="-")
    public void setDefaultNameIdResolver(NameIdResolver defaultNameIdResolver) {
        this._defaultNameIdResolver = defaultNameIdResolver;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._nameIdResolvers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, NameIdResolver.class, (String)"(companyId=*)", (ServiceReferenceMapper)new DefaultServiceReferenceMapper(_log));
    }

    @Deactivate
    protected void deactivate() {
        this._nameIdResolvers.close();
    }
}

