/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.binding;

import com.liferay.saml.opensaml.integration.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpPostBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpRedirectBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpSoap11Binding;
import com.liferay.saml.opensaml.integration.internal.velocity.VelocityEngineFactory;
import java.util.Hashtable;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.opensaml.xml.parse.ParserPool;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HttpBindingsRegistrator.class})
public class HttpBindingsRegistrator {
    @Reference
    private HttpClient _httpClient;
    @Reference
    private ParserPool _parserPool;
    private ServiceRegistration<SamlBinding> _samlHttpPostBindingServiceRegistration;
    private ServiceRegistration<SamlBinding> _samlHttpRedirectBindingServiceRegistration;
    private ServiceRegistration<SamlBinding> _samlHttpSoap11BindingServiceRegistration;
    @Reference
    private VelocityEngineFactory _velocityEngineFactory;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> propertiesMap) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(propertiesMap);
        HttpPostBinding httpPostBinding = new HttpPostBinding(this._parserPool, this._velocityEngineFactory.getVelocityEngine());
        HttpRedirectBinding httpRedirectBinding = new HttpRedirectBinding(this._parserPool);
        HttpSoap11Binding httpSoap11Binding = new HttpSoap11Binding(this._parserPool, this._httpClient);
        this._samlHttpPostBindingServiceRegistration = bundleContext.registerService(SamlBinding.class, (Object)httpPostBinding, properties);
        this._samlHttpRedirectBindingServiceRegistration = bundleContext.registerService(SamlBinding.class, (Object)httpRedirectBinding, properties);
        this._samlHttpSoap11BindingServiceRegistration = bundleContext.registerService(SamlBinding.class, (Object)httpSoap11Binding, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._samlHttpPostBindingServiceRegistration.unregister();
        this._samlHttpRedirectBindingServiceRegistration.unregister();
        this._samlHttpSoap11BindingServiceRegistration.unregister();
    }
}

