/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class UnixCodec
extends Codec {
    public String encodeCharacter(char[] immune, Character c) {
        char ch = c.charValue();
        if (UnixCodec.containsCharacter(ch, immune)) {
            return "" + ch;
        }
        String hex = Codec.getHexForNonAlphanumeric(ch);
        if (hex == null) {
            return "" + ch;
        }
        return "\\" + c;
    }

    public Character decodeCharacter(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = input.next();
        return second;
    }
}

