/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostDecoder
extends BaseSAML2MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostDecoder.class);

    public HTTPPostDecoder() {
    }

    public HTTPPostDecoder(ParserPool pool) {
        super(pool);
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    @Override
    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return this.isMessageSigned(samlMsgCtx);
    }

    @Override
    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        if (!inTransport.getHTTPMethod().equalsIgnoreCase("POST")) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        String relayState = inTransport.getParameterValue("RelayState");
        samlMsgCtx.setRelayState(relayState);
        this.log.debug("Decoded SAML relay state of: {}", (Object)relayState);
        InputStream base64DecodedMessage = this.getBase64DecodedMessage(inTransport);
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(base64DecodedMessage);
        samlMsgCtx.setInboundMessage(inboundMessage);
        samlMsgCtx.setInboundSAMLMessage(inboundMessage);
        this.log.debug("Decoded SAML message");
        this.populateMessageContext(samlMsgCtx);
    }

    protected InputStream getBase64DecodedMessage(HTTPInTransport transport) throws MessageDecodingException {
        this.log.debug("Getting Base64 encoded message from request");
        String encodedMessage = transport.getParameterValue("SAMLRequest");
        if (DatatypeHelper.isEmpty(encodedMessage)) {
            encodedMessage = transport.getParameterValue("SAMLResponse");
        }
        if (DatatypeHelper.isEmpty(encodedMessage)) {
            this.log.error("Request did not contain either a SAMLRequest or SAMLResponse paramter.  Invalid request for SAML 2 HTTP POST binding.");
            throw new MessageDecodingException("No SAML message present in request");
        }
        this.log.trace("Base64 decoding SAML message:\n{}", (Object)encodedMessage);
        byte[] decodedBytes = Base64.decode(encodedMessage);
        if (decodedBytes == null) {
            this.log.error("Unable to Base64 decode SAML message");
            throw new MessageDecodingException("Unable to Base64 decode SAML message");
        }
        this.log.trace("Decoded SAML message:\n{}", (Object)new String(decodedBytes));
        return new ByteArrayInputStream(decodedBytes);
    }
}

