/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.Collections;
import java.util.List;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IndexingObjectStore;
import org.opensaml.xml.validation.AbstractValidatingXMLObject;

public class X509CertificateImpl
extends AbstractValidatingXMLObject
implements X509Certificate {
    private static final IndexingObjectStore<String> B64_CERT_STORE = new IndexingObjectStore();
    private String b64CertIndex;

    protected X509CertificateImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public String getValue() {
        return B64_CERT_STORE.get(this.b64CertIndex);
    }

    @Override
    public void setValue(String newValue) {
        String b64Cert;
        String currentCert = B64_CERT_STORE.get(this.b64CertIndex);
        if (!DatatypeHelper.safeEquals(currentCert, b64Cert = this.prepareForAssignment(currentCert, newValue))) {
            B64_CERT_STORE.remove(this.b64CertIndex);
            this.b64CertIndex = B64_CERT_STORE.put(b64Cert);
        }
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        B64_CERT_STORE.remove(this.b64CertIndex);
    }
}

