/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.AuthenticationHostException;
import org.owasp.esapi.errors.EncryptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface User
extends Principal,
Serializable {
    public static final User ANONYMOUS = new User(){
        private static final long serialVersionUID = -1850916950784965502L;
        private String csrfToken = "";
        private Set sessions = new HashSet();
        private Locale locale = null;

        @Override
        public void addRole(String role) throws AuthenticationException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        public void addRoles(Set newRoles) throws AuthenticationException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void changePassword(String oldPassword, String newPassword1, String newPassword2) throws AuthenticationException, EncryptionException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void disable() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void enable() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public long getAccountId() {
            return 0L;
        }

        @Override
        public String getAccountName() {
            return "Anonymous";
        }

        @Override
        public String getName() {
            return this.getAccountName();
        }

        @Override
        public String getCSRFToken() {
            return this.csrfToken;
        }

        @Override
        public Date getExpirationTime() {
            return null;
        }

        @Override
        public int getFailedLoginCount() {
            return 0;
        }

        @Override
        public Date getLastFailedLoginTime() throws AuthenticationException {
            return null;
        }

        @Override
        public String getLastHostAddress() {
            return "unknown";
        }

        @Override
        public Date getLastLoginTime() {
            return null;
        }

        @Override
        public Date getLastPasswordChangeTime() {
            return null;
        }

        @Override
        public Set<String> getRoles() {
            return new HashSet<String>();
        }

        @Override
        public String getScreenName() {
            return "Anonymous";
        }

        @Override
        public void addSession(HttpSession s) {
        }

        @Override
        public void removeSession(HttpSession s) {
        }

        @Override
        public Set getSessions() {
            return this.sessions;
        }

        @Override
        public void incrementFailedLoginCount() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public boolean isAnonymous() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public boolean isInRole(String role) {
            return false;
        }

        @Override
        public boolean isLocked() {
            return false;
        }

        @Override
        public boolean isLoggedIn() {
            return false;
        }

        @Override
        public boolean isSessionAbsoluteTimeout() {
            return false;
        }

        @Override
        public boolean isSessionTimeout() {
            return false;
        }

        @Override
        public void lock() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void loginWithPassword(String password) throws AuthenticationException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void logout() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void removeRole(String role) throws AuthenticationException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public String resetCSRFToken() throws AuthenticationException {
            this.csrfToken = ESAPI.randomizer().getRandomString(8, Encoder.CHAR_ALPHANUMERICS);
            return this.csrfToken;
        }

        @Override
        public void setAccountName(String accountName) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        public void setRoles(Set roles) throws AuthenticationException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setScreenName(String screenName) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void unlock() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public boolean verifyPassword(String password) throws EncryptionException {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setLastFailedLoginTime(Date lastFailedLoginTime) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setLastLoginTime(Date lastLoginTime) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setLastHostAddress(String remoteHost) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public void setLastPasswordChangeTime(Date lastPasswordChangeTime) {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public HashMap getEventMap() {
            throw new RuntimeException("Invalid operation for the anonymous user");
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }

        @Override
        public void setLocale(Locale locale) {
            this.locale = locale;
        }
    };

    public Locale getLocale();

    public void setLocale(Locale var1);

    public void addRole(String var1) throws AuthenticationException;

    public void addRoles(Set<String> var1) throws AuthenticationException;

    public void changePassword(String var1, String var2, String var3) throws AuthenticationException, EncryptionException;

    public void disable();

    public void enable();

    public long getAccountId();

    public String getAccountName();

    public String getCSRFToken();

    public Date getExpirationTime();

    public int getFailedLoginCount();

    public String getLastHostAddress();

    public Date getLastFailedLoginTime() throws AuthenticationException;

    public Date getLastLoginTime();

    public Date getLastPasswordChangeTime();

    public Set<String> getRoles();

    public String getScreenName();

    public void addSession(HttpSession var1);

    public void removeSession(HttpSession var1);

    public Set getSessions();

    public void incrementFailedLoginCount();

    public boolean isAnonymous();

    public boolean isEnabled();

    public boolean isExpired();

    public boolean isInRole(String var1);

    public boolean isLocked();

    public boolean isLoggedIn();

    public boolean isSessionAbsoluteTimeout();

    public boolean isSessionTimeout();

    public void lock();

    public void loginWithPassword(String var1) throws AuthenticationException;

    public void logout();

    public void removeRole(String var1) throws AuthenticationException;

    public String resetCSRFToken() throws AuthenticationException;

    public void setAccountName(String var1);

    public void setExpirationTime(Date var1);

    public void setRoles(Set<String> var1) throws AuthenticationException;

    public void setScreenName(String var1);

    public void unlock();

    public boolean verifyPassword(String var1) throws EncryptionException;

    public void setLastFailedLoginTime(Date var1);

    public void setLastHostAddress(String var1) throws AuthenticationHostException;

    public void setLastLoginTime(Date var1);

    public void setLastPasswordChangeTime(Date var1);

    public HashMap getEventMap();
}

