/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class RequestedAuthnContextSchemaValidator
implements Validator<RequestedAuthnContext> {
    @Override
    public void validate(RequestedAuthnContext requestedAuthnContext) throws ValidationException {
        this.validateChildren(requestedAuthnContext);
    }

    protected void validateChildren(RequestedAuthnContext rac) throws ValidationException {
        int classRefCount = rac.getAuthnContextClassRefs().size();
        int declRefCount = rac.getAuthnContextDeclRefs().size();
        if (classRefCount == 0 && declRefCount == 0) {
            throw new ValidationException("At least one of either AuthnContextClassRef or AuthnContextDeclRef is required");
        }
        if (classRefCount > 0 && declRefCount > 0) {
            throw new ValidationException("AuthnContextClassRef and AuthnContextDeclRef are mutually exclusive");
        }
    }
}

