/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.util.MetadataUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.XMLObjectHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.MetadataUtilConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={MetadataUtil.class})
public class MetadataUtilImpl
implements MetadataUtil {
    @Reference
    protected HttpClient httpClient;
    @Reference
    protected ParserPool parserPool;
    private static final Log _log = LogFactoryUtil.getLog(MetadataUtilImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public InputStream getMetadata(String url) {
        HttpGet httpGet = new HttpGet(url);
        try {
            ByteArrayInputStream byteArrayInputStream;
            Throwable throwable;
            CloseableHttpResponse closeableHttpResponse;
            block31: {
                block32: {
                    block28: {
                        InputStream inputStream;
                        block29: {
                            block30: {
                                closeableHttpResponse = (CloseableHttpResponse)this.httpClient.execute(httpGet);
                                throwable = null;
                                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                                if (statusLine.getStatusCode() == 200) break block28;
                                inputStream = null;
                                if (closeableHttpResponse == null) break block29;
                                if (throwable == null) break block30;
                                try {
                                    closeableHttpResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block29;
                            }
                            closeableHttpResponse.close();
                        }
                        return inputStream;
                    }
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    InputStream inputStream = httpEntity.getContent();
                    Header header = httpEntity.getContentEncoding();
                    if (header != null) {
                        String contentEncoding = header.getValue();
                        if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"deflate")) {
                            inputStream = new InflaterInputStream(inputStream);
                        } else if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"gzip")) {
                            inputStream = new GZIPInputStream(inputStream);
                        }
                    }
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
                    byte[] bytes = unsyncByteArrayOutputStream.toByteArray();
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                    if (closeableHttpResponse == null) break block31;
                    if (throwable == null) break block32;
                    try {
                        closeableHttpResponse.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block31;
                }
                closeableHttpResponse.close();
            }
            return byteArrayInputStream;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (closeableHttpResponse != null) {
                            if (throwable != null) {
                                try {
                                    closeableHttpResponse.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                closeableHttpResponse.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to get SAML metadata from " + url), (Throwable)e);
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get SAML metadata from " + url + ": " + e.getMessage()));
                    }
                }
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return null;
    }

    public String parseMetadataXml(InputStream inputStream, String entityId) throws Exception {
        try (InputStream is = inputStream;){
            XMLObject xmlObject = XMLObjectHelper.unmarshallFromInputStream(this.parserPool, inputStream);
            EntityDescriptor entityDescriptor = SamlUtil.getEntityDescriptorById(entityId, xmlObject);
            if (entityDescriptor == null) {
                String string = null;
                return string;
            }
            StringWriter stringWriter = new StringWriter();
            XMLObjectHelper.marshallToWriter(entityDescriptor, stringWriter);
            String string = stringWriter.toString();
            return string;
        }
    }
}

