/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.metadata;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataGeneratorUtil;
import com.liferay.saml.opensaml.integration.internal.provider.CachingChainingMetadataProvider;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import com.liferay.saml.util.SamlHttpRequestUtil;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.xml.security.utils.Base64;
import org.opensaml.Configuration;
import org.opensaml.common.binding.security.SAMLProtocolMessageXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.binding.security.SAML2HTTPPostSimpleSignRule;
import org.opensaml.saml2.binding.security.SAML2HTTPRedirectDeflateSignatureRule;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCredentialResolver;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.HTTPRule;
import org.opensaml.ws.security.provider.MandatoryAuthenticatedMessageRule;
import org.opensaml.ws.security.provider.MandatoryIssuerRule;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.ChainingSignatureTrustEngine;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={LocalEntityManager.class, MetadataManager.class, SamlHttpRequestUtil.class})
public class MetadataManagerImpl
implements LocalEntityManager,
MetadataManager,
SamlHttpRequestUtil {
    private static final Log _log = LogFactoryUtil.getLog(MetadataManagerImpl.class);
    private final CachingChainingMetadataProvider _cachingChainingMetadataProvider = new CachingChainingMetadataProvider();
    private CredentialResolver _credentialResolver;
    private Http _http;
    private ParserPool _parserPool;
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;

    @Override
    public int getAssertionLifetime(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.getAssertionLifetime();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
            return samlProviderConfiguration.defaultAssertionLifetime();
        }
    }

    @Override
    public String[] getAttributeNames(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return StringUtil.splitLines((String)samlIdpSpConnection.getAttributeNames());
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public long getClockSkew() {
        return this.getSamlProviderConfiguration().clockSkew();
    }

    @Override
    public String getDefaultIdpEntityId() {
        return this.getSamlProviderConfiguration().defaultIdPEntityId();
    }

    public String getEncodedLocalEntityCertificate() throws SamlException {
        try {
            X509Certificate x509Certificate = this.getLocalEntityCertificate();
            if (x509Certificate == null) {
                return null;
            }
            return Base64.encode(x509Certificate.getEncoded(), 76);
        }
        catch (CertificateEncodingException cee) {
            throw new SamlException((Throwable)cee);
        }
    }

    @Override
    public EntityDescriptor getEntityDescriptor(HttpServletRequest request) throws SamlException {
        try {
            if (this._samlProviderConfigurationHelper.isRoleIdp()) {
                return MetadataGeneratorUtil.buildIdpEntityDescriptor(request, this.getLocalEntityId(), this.isWantAuthnRequestSigned(), this.isSignMetadata(), this.isSSLRequired(), this.getSigningCredential());
            }
            if (this._samlProviderConfigurationHelper.isRoleSp()) {
                return MetadataGeneratorUtil.buildSpEntityDescriptor(request, this.getLocalEntityId(), this.isSignAuthnRequest(), this.isSignMetadata(), this.isSSLRequired(), this.isWantAssertionsSigned(), this.getSigningCredential());
            }
            return null;
        }
        catch (Exception e) {
            throw new SamlException((Throwable)e);
        }
    }

    public String getEntityDescriptorString(HttpServletRequest request) throws SamlException {
        try {
            EntityDescriptor entityDescriptor = this.getEntityDescriptor(request);
            return OpenSamlUtil.marshall(entityDescriptor);
        }
        catch (Exception e) {
            throw new SamlException((Throwable)e);
        }
    }

    public X509Certificate getLocalEntityCertificate() throws SamlException {
        X509Credential x509Credential = (X509Credential)this.getSigningCredential();
        X509Certificate x509Certificate = null;
        if (x509Credential != null) {
            x509Certificate = x509Credential.getEntityCertificate();
        }
        return x509Certificate;
    }

    public String getLocalEntityId() {
        return this.getSamlProviderConfiguration().entityId();
    }

    @Override
    public MetadataProvider getMetadataProvider() throws SamlException {
        return this._cachingChainingMetadataProvider;
    }

    @Override
    public String getNameIdAttribute(String entityId) {
        String nameIdAttributeName;
        block3: {
            long companyId = CompanyThreadLocal.getCompanyId();
            nameIdAttributeName = "";
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                nameIdAttributeName = samlIdpSpConnection.getNameIdAttribute();
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        if (Validator.isNotNull((String)nameIdAttributeName)) {
            return nameIdAttributeName;
        }
        return "emailAddress";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getNameIdFormat(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (this._samlProviderConfigurationHelper.isRoleIdp()) {
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                return samlIdpSpConnection.getNameIdFormat();
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) return null;
                _log.debug((Object)e, (Throwable)e);
                return null;
            }
        } else {
            if (!this._samlProviderConfigurationHelper.isRoleSp()) return null;
            try {
                SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
                return samlSpIdpConnection.getNameIdFormat();
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) return null;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public String getRequestPath(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (Validator.isNotNull((String)contextPath) && !contextPath.equals("/")) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return this._http.removePathParameters(requestURI);
    }

    @Override
    public SecurityPolicyResolver getSecurityPolicyResolver(String communicationProfileId, boolean requireSignature) throws SamlException {
        BasicSecurityPolicy securityPolicy = new BasicSecurityPolicy();
        List<SecurityPolicyRule> securityPolicyRules = securityPolicy.getPolicyRules();
        if (requireSignature) {
            SecurityPolicyRule securityPolicyRule;
            SignatureTrustEngine signatureTrustEngine = this.getSignatureTrustEngine();
            if (communicationProfileId.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                securityPolicyRule = new SAML2HTTPRedirectDeflateSignatureRule(signatureTrustEngine);
                securityPolicyRules.add(securityPolicyRule);
            } else if (communicationProfileId.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign")) {
                SecurityConfiguration securityConfiguration = Configuration.getGlobalSecurityConfiguration();
                KeyInfoCredentialResolver keyInfoCredentialResolver = securityConfiguration.getDefaultKeyInfoCredentialResolver();
                SAML2HTTPPostSimpleSignRule securityPolicyRule2 = new SAML2HTTPPostSimpleSignRule(signatureTrustEngine, this._parserPool, keyInfoCredentialResolver);
                securityPolicyRules.add(securityPolicyRule2);
            } else {
                securityPolicyRule = new SAMLProtocolMessageXMLSignatureSecurityPolicyRule(signatureTrustEngine);
                securityPolicyRules.add(securityPolicyRule);
            }
            MandatoryAuthenticatedMessageRule mandatoryAuthenticatedMessageRule = new MandatoryAuthenticatedMessageRule();
            securityPolicyRules.add(mandatoryAuthenticatedMessageRule);
        }
        HTTPRule httpRule = new HTTPRule(null, null, this.isSSLRequired());
        securityPolicyRules.add(httpRule);
        MandatoryIssuerRule mandatoryIssuerRule = new MandatoryIssuerRule();
        securityPolicyRules.add(mandatoryIssuerRule);
        StaticSecurityPolicyResolver securityPolicyResolver = new StaticSecurityPolicyResolver(securityPolicy);
        return securityPolicyResolver;
    }

    @Override
    public SignatureTrustEngine getSignatureTrustEngine() throws SamlException {
        ChainingSignatureTrustEngine chainingSignatureTrustEngine = new ChainingSignatureTrustEngine();
        List<SignatureTrustEngine> signatureTrustEngines = chainingSignatureTrustEngine.getChain();
        MetadataCredentialResolver metadataCredentialResolver = new MetadataCredentialResolver(this.getMetadataProvider());
        SecurityConfiguration securityConfiguration = Configuration.getGlobalSecurityConfiguration();
        KeyInfoCredentialResolver keyInfoCredentialResolver = securityConfiguration.getDefaultKeyInfoCredentialResolver();
        ExplicitKeySignatureTrustEngine signatureTrustEngine = new ExplicitKeySignatureTrustEngine(metadataCredentialResolver, keyInfoCredentialResolver);
        signatureTrustEngines.add(signatureTrustEngine);
        signatureTrustEngine = new ExplicitKeySignatureTrustEngine(this._credentialResolver, keyInfoCredentialResolver);
        signatureTrustEngines.add(signatureTrustEngine);
        return chainingSignatureTrustEngine;
    }

    @Override
    public Credential getSigningCredential() throws SamlException {
        try {
            CriteriaSet criteriaSet = new CriteriaSet();
            String entityId = this.getLocalEntityId();
            if (Validator.isNull((String)entityId)) {
                return null;
            }
            EntityIDCriteria entityIdCriteria = new EntityIDCriteria(entityId);
            criteriaSet.add(entityIdCriteria);
            return (Credential)this._credentialResolver.resolveSingle(criteriaSet);
        }
        catch (SecurityException se) {
            throw new SamlException((Throwable)se);
        }
    }

    @Override
    public String getUserAttributeMappings(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
            return samlSpIdpConnection.getUserAttributeMappings();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    public boolean hasDefaultIdpRole() {
        String defaultIdpEntityId = this.getDefaultIdpEntityId();
        try {
            MetadataProvider metadataProvider = this.getMetadataProvider();
            return !Validator.isNull((String)defaultIdpEntityId) && metadataProvider.getRole(defaultIdpEntityId, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol") != null;
        }
        catch (SamlException | MetadataProviderException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Error retrieving metadata information", e);
            }
            return false;
        }
    }

    @Override
    public boolean isAttributesEnabled(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.isAttributesEnabled();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean isAttributesNamespaceEnabled(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        try {
            SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
            return samlIdpSpConnection.isAttributesNamespaceEnabled();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    @Reference(unbind="-")
    public void setCredentialResolver(CredentialResolver credentialResolver) {
        this._credentialResolver = credentialResolver;
    }

    @Reference(unbind="-")
    public void setHttp(Http http) {
        this._http = http;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetMetadataProvider")
    public void setMetadataProvider(MetadataProvider metadataProvider) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding metadata provider " + metadataProvider));
        }
        this._cachingChainingMetadataProvider.addMetadataProvider(metadataProvider);
    }

    @Reference(unbind="-")
    public void setParserPool(ParserPool parserPool) {
        this._parserPool = parserPool;
    }

    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this._samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    @Deactivate
    public void shutdown() {
        this._cachingChainingMetadataProvider.destroy();
    }

    public void unsetMetadataProvider(MetadataProvider metadataProvider) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removing metadata provider " + metadataProvider));
        }
        this._cachingChainingMetadataProvider.removeMetadataProvider(metadataProvider);
    }

    protected SamlProviderConfiguration getSamlProviderConfiguration() {
        return this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
    }

    protected boolean isSignAuthnRequest() {
        return this.getSamlProviderConfiguration().signAuthnRequest();
    }

    protected boolean isSignMetadata() {
        return this.getSamlProviderConfiguration().signMetadata();
    }

    protected boolean isSSLRequired() {
        return this.getSamlProviderConfiguration().sslRequired();
    }

    protected boolean isWantAssertionsSigned() {
        return this.getSamlProviderConfiguration().assertionSignatureRequired();
    }

    protected boolean isWantAuthnRequestSigned() {
        return this.getSamlProviderConfiguration().authnRequestSignatureRequired();
    }
}

