/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.transport;

import com.liferay.saml.opensaml.integration.internal.transport.OutputStreamHttpEntity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.security.credential.Credential;

public class HttpClientOutTransport
implements HTTPOutTransport {
    private HttpEntity _httpEntity;
    private final HttpPost _httpPost;

    public HttpClientOutTransport(HttpPost httpPost) {
        this._httpPost = httpPost;
        this._httpEntity = this._httpPost.getEntity();
    }

    @Override
    public void addParameter(String name, String value) {
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        ContentType contentType = ContentType.get(this._httpEntity);
        if (contentType != null) {
            Charset charset = contentType.getCharset();
            return charset.name();
        }
        return Consts.ISO_8859_1.name();
    }

    @Override
    public String getHeaderValue(String name) {
        Header header = this._httpPost.getFirstHeader(name);
        return header.getValue();
    }

    @Override
    public String getHTTPMethod() {
        return this._httpPost.getMethod();
    }

    public HttpPost getHttpPost() {
        return this._httpPost;
    }

    @Override
    public Credential getLocalCredential() {
        return null;
    }

    @Override
    public OutputStream getOutgoingStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this._httpEntity == null) {
            this._httpEntity = new OutputStreamHttpEntity(byteArrayOutputStream);
            this._httpPost.setEntity(this._httpEntity);
        }
        return byteArrayOutputStream;
    }

    @Override
    public String getParameterValue(String name) {
        return null;
    }

    @Override
    public List<String> getParameterValues(String name) {
        return null;
    }

    @Override
    public Credential getPeerCredential() {
        return null;
    }

    @Override
    public int getStatusCode() {
        return -1;
    }

    @Override
    public HTTPTransport.HTTP_VERSION getVersion() {
        ProtocolVersion protocolVersion = this._httpPost.getProtocolVersion();
        if (protocolVersion.equals(HttpVersion.HTTP_1_1)) {
            return HTTPTransport.HTTP_VERSION.HTTP1_1;
        }
        return HTTPTransport.HTTP_VERSION.HTTP1_0;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isConfidential() {
        URI uri = this._httpPost.getURI();
        String scheme = uri.getScheme();
        return scheme.equals("https");
    }

    @Override
    public boolean isIntegrityProtected() {
        return false;
    }

    @Override
    public void sendRedirect(String redirect) {
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public void setAuthenticated(boolean uthenticated) {
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this._httpPost.setHeader("http.protocol.content-charset", characterEncoding);
    }

    @Override
    public void setConfidential(boolean confidential) {
    }

    @Override
    public void setHeader(String name, String value) {
        this._httpPost.setHeader(name, value);
    }

    @Override
    public void setIntegrityProtected(boolean integrityProtected) {
    }

    @Override
    public void setStatusCode(int statusCode) {
    }

    @Override
    public void setVersion(HTTPTransport.HTTP_VERSION httpVersion) {
        if (httpVersion.equals((Object)HTTPTransport.HTTP_VERSION.HTTP1_0)) {
            this._httpPost.setProtocolVersion(HttpVersion.HTTP_1_0);
        } else if (httpVersion.equals((Object)HTTPTransport.HTTP_VERSION.HTTP1_1)) {
            this._httpPost.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
    }
}

