/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.provider;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.NamespaceManager;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.LazySet;
import org.opensaml.xml.validation.Validator;
import org.w3c.dom.Element;

public class CachingChainingMetadataProvider
extends BaseMetadataProvider {
    private static final Log _log = LogFactoryUtil.getLog(CachingChainingMetadataProvider.class);
    private final List<MetadataProvider> _metadataProviders = new CopyOnWriteArrayList<MetadataProvider>();
    private final Map<String, MetadataProvider> _metadataProvidersMap = new ConcurrentHashMap<String, MetadataProvider>();
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);

    public void addMetadataProvider(MetadataProvider metadataProvider) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            if (metadataProvider != null) {
                metadataProvider.setRequireValidMetadata(this.requireValidMetadata());
                this._metadataProviders.add(metadataProvider);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            this._metadataProvidersMap.clear();
            for (MetadataProvider metadataProvider : this._metadataProviders) {
                if (!(metadataProvider instanceof BaseMetadataProvider)) continue;
                BaseMetadataProvider baseMetadataProvider = (BaseMetadataProvider)metadataProvider;
                baseMetadataProvider.destroy();
            }
            this._metadataProviders.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            for (MetadataProvider metadataProvider : this._metadataProviders) {
                try {
                    EntitiesDescriptor entitiesDescriptor = metadataProvider.getEntitiesDescriptor(name);
                    if (entitiesDescriptor == null) continue;
                    EntitiesDescriptor entitiesDescriptor2 = entitiesDescriptor;
                    return entitiesDescriptor2;
                }
                catch (MetadataProviderException mpe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to retrieve metadata from provider " + metadataProvider.getClass()), (Throwable)mpe);
                }
            }
            Iterator<MetadataProvider> iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityDescriptor getEntityDescriptor(String entityId) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            MetadataProvider metadataProvider = this._metadataProvidersMap.get(entityId);
            if (metadataProvider != null) {
                try {
                    EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(entityId);
                    if (entityDescriptor != null) {
                        EntityDescriptor entityDescriptor2 = entityDescriptor;
                        return entityDescriptor2;
                    }
                }
                catch (MetadataProviderException metadataProviderException) {
                    // empty catch block
                }
                this._metadataProvidersMap.remove(entityId);
            }
            Iterator<MetadataProvider> iterator = this._metadataProviders.iterator();
            while (iterator.hasNext()) {
                MetadataProvider curMetadataProvider;
                metadataProvider = curMetadataProvider = iterator.next();
                try {
                    EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(entityId);
                    if (entityDescriptor == null) continue;
                    this._metadataProvidersMap.put(entityId, metadataProvider);
                    EntityDescriptor entityDescriptor3 = entityDescriptor;
                    return entityDescriptor3;
                }
                catch (MetadataProviderException mpe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to retrieve metadata from provider " + metadataProvider.getClass()), (Throwable)mpe);
                }
            }
            iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public XMLObject getMetadata() {
        return new ChainingEntitiesDescriptor();
    }

    public List<MetadataProvider> getProviders() {
        return Collections.unmodifiableList(this._metadataProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoleDescriptor> getRole(String entityId, QName qName) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            MetadataProvider metadataProvider = this._metadataProvidersMap.get(entityId);
            if (metadataProvider != null) {
                try {
                    List<RoleDescriptor> roleDescriptors = metadataProvider.getRole(entityId, qName);
                    if (roleDescriptors != null) {
                        List<RoleDescriptor> list = roleDescriptors;
                        return list;
                    }
                }
                catch (MetadataProviderException metadataProviderException) {
                    // empty catch block
                }
                this._metadataProvidersMap.remove(entityId);
            }
            Iterator<MetadataProvider> iterator = this._metadataProviders.iterator();
            while (iterator.hasNext()) {
                MetadataProvider curMetadataProvider;
                metadataProvider = curMetadataProvider = iterator.next();
                try {
                    List<RoleDescriptor> roleDescriptors = metadataProvider.getRole(entityId, qName);
                    if (roleDescriptors == null || roleDescriptors.isEmpty()) continue;
                    this._metadataProvidersMap.put(entityId, metadataProvider);
                    List<RoleDescriptor> list = roleDescriptors;
                    return list;
                }
                catch (MetadataProviderException mpe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to retrieve metadata from provider " + metadataProvider.getClass()), (Throwable)mpe);
                }
            }
            iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleDescriptor getRole(String entityId, QName qName, String supportedProtocol) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            MetadataProvider metadataProvider = this._metadataProvidersMap.get(entityId);
            if (metadataProvider != null) {
                try {
                    RoleDescriptor roleDescriptor = metadataProvider.getRole(entityId, qName, supportedProtocol);
                    if (roleDescriptor != null) {
                        RoleDescriptor roleDescriptor2 = roleDescriptor;
                        return roleDescriptor2;
                    }
                }
                catch (MetadataProviderException metadataProviderException) {
                    // empty catch block
                }
                this._metadataProvidersMap.remove(entityId);
            }
            Iterator<MetadataProvider> iterator = this._metadataProviders.iterator();
            while (iterator.hasNext()) {
                MetadataProvider curMetadataProvider;
                metadataProvider = curMetadataProvider = iterator.next();
                try {
                    RoleDescriptor roleDescriptor = metadataProvider.getRole(entityId, qName, supportedProtocol);
                    if (roleDescriptor == null) continue;
                    this._metadataProvidersMap.put(entityId, metadataProvider);
                    RoleDescriptor roleDescriptor3 = roleDescriptor;
                    return roleDescriptor3;
                }
                catch (MetadataProviderException mpe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to retrieve metadata from provider " + metadataProvider.getClass()), (Throwable)mpe);
                }
            }
            iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    public void removeMetadataProvider(MetadataProvider metadataProvider) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            this._metadataProvidersMap.clear();
            this._metadataProviders.remove(metadataProvider);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            for (MetadataProvider metadataProvider : this._metadataProviders) {
                metadataProvider.setRequireValidMetadata(requireValidMetadata);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private class ChainingEntitiesDescriptor
    implements EntitiesDescriptor {
        private final List<XMLObject> _xmlObjects = new ArrayList<XMLObject>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChainingEntitiesDescriptor() {
            Lock lock = CachingChainingMetadataProvider.this._readWriteLock.readLock();
            lock.lock();
            try {
                for (MetadataProvider metadataProvider : CachingChainingMetadataProvider.this._metadataProviders) {
                    this._xmlObjects.add(metadataProvider.getMetadata());
                }
            }
            catch (MetadataProviderException mpe) {
                _log.error((Object)"Unable to get metadata from metadata provider", (Throwable)mpe);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void addNamespace(Namespace namespace) {
        }

        @Override
        public void deregisterValidator(Validator validator) {
        }

        @Override
        public void detach() {
        }

        @Override
        public Long getCacheDuration() {
            return null;
        }

        @Override
        public Element getDOM() {
            return null;
        }

        @Override
        public QName getElementQName() {
            return EntitiesDescriptor.DEFAULT_ELEMENT_NAME;
        }

        @Override
        public List<EntitiesDescriptor> getEntitiesDescriptors() {
            ArrayList<EntitiesDescriptor> entitiesDescriptors = new ArrayList<EntitiesDescriptor>();
            for (XMLObject xmlObject : this._xmlObjects) {
                if (!(xmlObject instanceof EntitiesDescriptor)) continue;
                EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)xmlObject;
                entitiesDescriptors.add(entitiesDescriptor);
            }
            return entitiesDescriptors;
        }

        @Override
        public List<EntityDescriptor> getEntityDescriptors() {
            ArrayList<EntityDescriptor> entityDescriptors = new ArrayList<EntityDescriptor>();
            for (XMLObject xmlObject : this._xmlObjects) {
                if (!(xmlObject instanceof EntityDescriptor)) continue;
                EntityDescriptor entityDescriptor = (EntityDescriptor)xmlObject;
                entityDescriptors.add(entityDescriptor);
            }
            return entityDescriptors;
        }

        @Override
        public Extensions getExtensions() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public IDIndex getIDIndex() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public NamespaceManager getNamespaceManager() {
            return null;
        }

        @Override
        public Set<Namespace> getNamespaces() {
            return new LazySet<Namespace>();
        }

        @Override
        public String getNoNamespaceSchemaLocation() {
            return null;
        }

        @Override
        public List<XMLObject> getOrderedChildren() {
            ArrayList<XMLObject> xmlObjects = new ArrayList<XMLObject>();
            try {
                for (MetadataProvider metadataProvider : CachingChainingMetadataProvider.this._metadataProviders) {
                    XMLObject xmlObject = metadataProvider.getMetadata();
                    xmlObjects.add(xmlObject);
                }
            }
            catch (MetadataProviderException mpe) {
                _log.error((Object)"Unable to build a list of metadata descriptors", (Throwable)mpe);
            }
            return xmlObjects;
        }

        @Override
        public XMLObject getParent() {
            return null;
        }

        @Override
        public String getSchemaLocation() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return EntitiesDescriptor.TYPE_NAME;
        }

        @Override
        public Signature getSignature() {
            return null;
        }

        @Override
        public String getSignatureReferenceID() {
            return null;
        }

        @Override
        public List<Validator> getValidators() {
            return new ArrayList<Validator>();
        }

        @Override
        public DateTime getValidUntil() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            List<XMLObject> xmlObjects = this.getOrderedChildren();
            return !xmlObjects.isEmpty();
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        public Boolean isNil() {
            return Boolean.FALSE;
        }

        @Override
        public XSBooleanValue isNilXSBoolean() {
            return new XSBooleanValue(Boolean.FALSE, false);
        }

        @Override
        public boolean isSigned() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void registerValidator(Validator validator) {
        }

        @Override
        public void releaseChildrenDOM(boolean propagateRelease) {
        }

        @Override
        public void releaseDOM() {
        }

        @Override
        public void releaseParentDOM(boolean propagateRelease) {
        }

        @Override
        public void removeNamespace(Namespace namespace) {
        }

        @Override
        public XMLObject resolveID(String id) {
            return null;
        }

        @Override
        public XMLObject resolveIDFromRoot(String id) {
            return null;
        }

        @Override
        public void setCacheDuration(Long duration) {
        }

        @Override
        public void setDOM(Element element) {
        }

        @Override
        public void setExtensions(Extensions extensions) {
        }

        @Override
        public void setID(String id) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setNil(Boolean value) {
        }

        @Override
        public void setNil(XSBooleanValue value) {
        }

        @Override
        public void setNoNamespaceSchemaLocation(String location) {
        }

        @Override
        public void setParent(XMLObject xmlObject) {
        }

        @Override
        public void setSchemaLocation(String location) {
        }

        @Override
        public void setSignature(Signature signature) {
        }

        @Override
        public void setValidUntil(DateTime validUntil) {
        }

        @Override
        public void validate(boolean validateDescendants) {
        }
    }
}

