/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.profile;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.transport.ProxyPathRequestWrapper;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlSpSessionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.io.MarshallingException;

public abstract class BaseProfile {
    protected MetadataManager metadataManager;
    protected Portal portal;
    protected SamlProviderConfigurationHelper samlProviderConfigurationHelper;
    protected SamlSpSessionLocalService samlSpSessionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseProfile.class);
    private IdentifierGenerator _identifierGenerator;
    private List<SamlBinding> _samlBindings = new ArrayList<SamlBinding>();

    public SAMLMessageContext<?, ?, ?> decodeSamlMessage(HttpServletRequest request, HttpServletResponse response, SamlBinding samlBinding, boolean requireSignature) throws Exception {
        EntityDescriptor entityDescriptor;
        SAMLMessageContext<?, ?, ?> samlMessageContext = this.getSamlMessageContext(request, response);
        samlMessageContext.setCommunicationProfileId(samlBinding.getCommunicationProfileId());
        SecurityPolicyResolver securityPolicyResolver = this.metadataManager.getSecurityPolicyResolver(samlMessageContext.getCommunicationProfileId(), requireSignature);
        samlMessageContext.setSecurityPolicyResolver(securityPolicyResolver);
        MessageDecoder messageDecoder = samlBinding.getMessageDecoder();
        messageDecoder.decode(samlMessageContext);
        if (_log.isDebugEnabled()) {
            Object samlObject = samlMessageContext.getInboundSAMLMessage();
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Received message using binding ", samlMessageContext.getCommunicationProfileId(), " ", OpenSamlUtil.marshall(samlObject)}));
        }
        if ((entityDescriptor = samlMessageContext.getPeerEntityMetadata()) == null) {
            throw new SamlException("Unable to resolve metadata for issuer " + samlMessageContext.getInboundMessageIssuer());
        }
        samlMessageContext.setPeerEntityId(entityDescriptor.getEntityID());
        SSODescriptor roleDescriptor = null;
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        samlMessageContext.setPeerEntityRoleMetadata(roleDescriptor);
        return samlMessageContext;
    }

    public String generateIdentifier(int length) {
        return this._identifierGenerator.generateIdentifier(length);
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this._identifierGenerator;
    }

    public SamlBinding getSamlBinding(String communicationProfileId) throws PortalException {
        for (SamlBinding samlBinding : this._samlBindings) {
            if (!communicationProfileId.equals(samlBinding.getCommunicationProfileId())) continue;
            return samlBinding;
        }
        throw new SamlException("Unsupported binding " + communicationProfileId);
    }

    public SAMLMessageContext<?, ?, ?> getSamlMessageContext(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BasicSAMLMessageContext samlMessageContext = new BasicSAMLMessageContext();
        HttpServletRequestAdapter httpServletRequestAdapter = new HttpServletRequestAdapter((HttpServletRequest)new ProxyPathRequestWrapper(request));
        samlMessageContext.setInboundMessageTransport(httpServletRequestAdapter);
        samlMessageContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SSODescriptor roleDescriptor = null;
        EntityDescriptor entityDescriptor = this.metadataManager.getEntityDescriptor(request);
        samlMessageContext.setLocalEntityMetadata(entityDescriptor);
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        samlMessageContext.setLocalEntityId(entityDescriptor.getEntityID());
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            samlMessageContext.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            samlMessageContext.setLocalEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        }
        samlMessageContext.setLocalEntityRoleMetadata(roleDescriptor);
        MetadataProvider metadataProvider = this.metadataManager.getMetadataProvider();
        samlMessageContext.setMetadataProvider(metadataProvider);
        HttpServletResponseAdapter httpServletResponseAdapter = new HttpServletResponseAdapter(response, request.isSecure());
        samlMessageContext.setOutboundMessageTransport(httpServletResponseAdapter);
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            samlMessageContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            samlMessageContext.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        }
        return samlMessageContext;
    }

    public SAMLMessageContext<?, ?, ?> getSamlMessageContext(HttpServletRequest request, HttpServletResponse response, String peerEntityId) throws Exception {
        SAMLMessageContext<?, ?, ?> samlMessageContext = this.getSamlMessageContext(request, response);
        samlMessageContext.setPeerEntityId(peerEntityId);
        MetadataProvider metadataProvider = samlMessageContext.getMetadataProvider();
        EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(peerEntityId);
        if (entityDescriptor == null) {
            throw new SamlException("Unknown peer entity ID " + peerEntityId);
        }
        samlMessageContext.setPeerEntityMetadata(entityDescriptor);
        SSODescriptor roleDescriptor = null;
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            roleDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            roleDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        samlMessageContext.setPeerEntityRoleMetadata(roleDescriptor);
        return samlMessageContext;
    }

    public SamlSpSession getSamlSpSession(HttpServletRequest request) {
        SamlSpSession samlSpSession;
        String samlSpSessionKey = this.getSamlSpSessionKey(request);
        if (Validator.isNotNull((String)samlSpSessionKey) && (samlSpSession = this.samlSpSessionLocalService.fetchSamlSpSessionBySamlSpSessionKey(samlSpSessionKey)) != null) {
            return samlSpSession;
        }
        HttpSession session = request.getSession();
        return this.samlSpSessionLocalService.fetchSamlSpSessionByJSessionId(session.getId());
    }

    public String getSamlSpSessionKey(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String samlSpSessionKey = (String)session.getAttribute("SAML_SP_SESSION_KEY");
        if (Validator.isNull((String)samlSpSessionKey)) {
            samlSpSessionKey = CookieKeys.getCookie((HttpServletRequest)request, (String)"SAML_SP_SESSION_KEY");
        }
        return samlSpSessionKey;
    }

    public String getSamlSsoSessionId(HttpServletRequest request) {
        return CookieKeys.getCookie((HttpServletRequest)request, (String)"SAML_SSO_SESSION_ID");
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        String domain = CookieKeys.getDomain((HttpServletRequest)request);
        Cookie companyIdCookie = new Cookie("COMPANY_ID", "");
        if (Validator.isNotNull((String)domain)) {
            companyIdCookie.setDomain(domain);
        }
        companyIdCookie.setMaxAge(0);
        companyIdCookie.setPath("/");
        Cookie idCookie = new Cookie("ID", "");
        if (Validator.isNotNull((String)domain)) {
            idCookie.setDomain(domain);
        }
        idCookie.setMaxAge(0);
        idCookie.setPath("/");
        Cookie passwordCookie = new Cookie("PASSWORD", "");
        if (Validator.isNotNull((String)domain)) {
            passwordCookie.setDomain(domain);
        }
        passwordCookie.setMaxAge(0);
        passwordCookie.setPath("/");
        boolean rememberMe = GetterUtil.getBoolean((String)CookieKeys.getCookie((HttpServletRequest)request, (String)"REMEMBER_ME"));
        if (!rememberMe) {
            Cookie loginCookie = new Cookie("LOGIN", "");
            if (Validator.isNotNull((String)domain)) {
                loginCookie.setDomain(domain);
            }
            loginCookie.setMaxAge(0);
            loginCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)loginCookie);
        }
        Cookie rememberMeCookie = new Cookie("REMEMBER_ME", "");
        if (Validator.isNotNull((String)domain)) {
            rememberMeCookie.setDomain(domain);
        }
        rememberMeCookie.setMaxAge(0);
        rememberMeCookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)companyIdCookie);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)idCookie);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)passwordCookie);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)rememberMeCookie);
        HttpSession session = request.getSession();
        try {
            session.invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSamlMessage(SAMLMessageContext<?, ?, ?> samlMessageContext) throws PortalException {
        Endpoint endpoint = samlMessageContext.getPeerEntityEndpoint();
        SamlBinding samlBinding = this.getSamlBinding(endpoint.getBinding());
        if (_log.isDebugEnabled()) {
            try {
                Object xmlObject = samlMessageContext.getOutboundSAMLMessage();
                String samlMessage = OpenSamlUtil.marshall(xmlObject);
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Sending SAML message ", samlMessage, " to ", endpoint.getLocation(), " with binding ", endpoint.getBinding()}));
            }
            catch (MarshallingException xmlObject) {
                // empty catch block
            }
        }
        MessageEncoder messageEncoder = samlBinding.getMessageEncoder();
        try {
            messageEncoder.encode(samlMessageContext);
        }
        catch (MessageEncodingException mee) {
            throw new SamlException(StringBundler.concat((String[])new String[]{"Unable to send SAML message to ", endpoint.getLocation(), " with binding ", endpoint.getBinding()}), (Throwable)mee);
        }
    }

    protected void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int maxAge) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(maxAge);
        if (Validator.isNull((String)this.portal.getPathContext())) {
            cookie.setPath("/");
        } else {
            cookie.setPath(this.portal.getPathContext());
        }
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    protected void addSamlBinding(SamlBinding samlBinding) {
        this._samlBindings.add(samlBinding);
    }

    protected void removeSamlBinding(SamlBinding samlBinding) {
        this._samlBindings.remove(samlBinding);
    }

    protected void setIdentifierGenerator(IdentifierGenerator identifierGenerator) {
        this._identifierGenerator = identifierGenerator;
    }

    protected void setMetadataManager(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    protected void setSamlBindings(List<SamlBinding> samlBindings) {
        this._samlBindings = samlBindings;
    }

    protected void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this.samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    protected void unsetSamlBinding(SamlBinding samlBinding) {
        this.removeSamlBinding(samlBinding);
    }
}

