/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.text.StrTokenizer;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.configuration.EsapiPropertyManager;
import org.owasp.esapi.errors.ConfigurationException;

public class DefaultSecurityConfiguration
implements SecurityConfiguration {
    private static volatile SecurityConfiguration instance = null;
    private Properties properties = null;
    private String cipherXformFromESAPIProp = null;
    private String cipherXformCurrent = null;
    public static final String DEFAULT_RESOURCE_FILE = "ESAPI.properties";
    public static final String REMEMBER_TOKEN_DURATION = "Authenticator.RememberTokenDuration";
    public static final String IDLE_TIMEOUT_DURATION = "Authenticator.IdleTimeoutDuration";
    public static final String ABSOLUTE_TIMEOUT_DURATION = "Authenticator.AbsoluteTimeoutDuration";
    public static final String ALLOWED_LOGIN_ATTEMPTS = "Authenticator.AllowedLoginAttempts";
    public static final String USERNAME_PARAMETER_NAME = "Authenticator.UsernameParameterName";
    public static final String PASSWORD_PARAMETER_NAME = "Authenticator.PasswordParameterName";
    public static final String MAX_OLD_PASSWORD_HASHES = "Authenticator.MaxOldPasswordHashes";
    public static final String ALLOW_MULTIPLE_ENCODING = "Encoder.AllowMultipleEncoding";
    public static final String ALLOW_MIXED_ENCODING = "Encoder.AllowMixedEncoding";
    public static final String CANONICALIZATION_CODECS = "Encoder.DefaultCodecList";
    public static final String DISABLE_INTRUSION_DETECTION = "IntrusionDetector.Disable";
    public static final String MASTER_KEY = "Encryptor.MasterKey";
    public static final String MASTER_SALT = "Encryptor.MasterSalt";
    public static final String KEY_LENGTH = "Encryptor.EncryptionKeyLength";
    public static final String ENCRYPTION_ALGORITHM = "Encryptor.EncryptionAlgorithm";
    public static final String HASH_ALGORITHM = "Encryptor.HashAlgorithm";
    public static final String HASH_ITERATIONS = "Encryptor.HashIterations";
    public static final String CHARACTER_ENCODING = "Encryptor.CharacterEncoding";
    public static final String RANDOM_ALGORITHM = "Encryptor.RandomAlgorithm";
    public static final String DIGITAL_SIGNATURE_ALGORITHM = "Encryptor.DigitalSignatureAlgorithm";
    public static final String DIGITAL_SIGNATURE_KEY_LENGTH = "Encryptor.DigitalSignatureKeyLength";
    public static final String PREFERRED_JCE_PROVIDER = "Encryptor.PreferredJCEProvider";
    public static final String CIPHER_TRANSFORMATION_IMPLEMENTATION = "Encryptor.CipherTransformation";
    public static final String CIPHERTEXT_USE_MAC = "Encryptor.CipherText.useMAC";
    public static final String PLAINTEXT_OVERWRITE = "Encryptor.PlainText.overwrite";
    public static final String IV_TYPE = "Encryptor.ChooseIVMethod";
    public static final String FIXED_IV = "Encryptor.fixedIV";
    public static final String COMBINED_CIPHER_MODES = "Encryptor.cipher_modes.combined_modes";
    public static final String ADDITIONAL_ALLOWED_CIPHER_MODES = "Encryptor.cipher_modes.additional_allowed";
    public static final String KDF_PRF_ALG = "Encryptor.KDF.PRF";
    public static final String PRINT_PROPERTIES_WHEN_LOADED = "ESAPI.printProperties";
    public static final String WORKING_DIRECTORY = "Executor.WorkingDirectory";
    public static final String APPROVED_EXECUTABLES = "Executor.ApprovedExecutables";
    public static final String FORCE_HTTPONLYSESSION = "HttpUtilities.ForceHttpOnlySession";
    public static final String FORCE_SECURESESSION = "HttpUtilities.SecureSession";
    public static final String FORCE_HTTPONLYCOOKIES = "HttpUtilities.ForceHttpOnlyCookies";
    public static final String FORCE_SECURECOOKIES = "HttpUtilities.ForceSecureCookies";
    public static final String MAX_HTTP_HEADER_SIZE = "HttpUtilities.MaxHeaderSize";
    public static final String UPLOAD_DIRECTORY = "HttpUtilities.UploadDir";
    public static final String UPLOAD_TEMP_DIRECTORY = "HttpUtilities.UploadTempDir";
    public static final String APPROVED_UPLOAD_EXTENSIONS = "HttpUtilities.ApprovedUploadExtensions";
    public static final String MAX_UPLOAD_FILE_BYTES = "HttpUtilities.MaxUploadFileBytes";
    public static final String RESPONSE_CONTENT_TYPE = "HttpUtilities.ResponseContentType";
    public static final String HTTP_SESSION_ID_NAME = "HttpUtilities.HttpSessionIdName";
    public static final String APPLICATION_NAME = "Logger.ApplicationName";
    public static final String LOG_LEVEL = "Logger.LogLevel";
    public static final String LOG_FILE_NAME = "Logger.LogFileName";
    public static final String MAX_LOG_FILE_SIZE = "Logger.MaxLogFileSize";
    public static final String LOG_ENCODING_REQUIRED = "Logger.LogEncodingRequired";
    public static final String LOG_APPLICATION_NAME = "Logger.LogApplicationName";
    public static final String LOG_SERVER_IP = "Logger.LogServerIP";
    public static final String VALIDATION_PROPERTIES = "Validator.ConfigurationFile";
    public static final String VALIDATION_PROPERTIES_MULTIVALUED = "Validator.ConfigurationFile.MultiValued";
    public static final String ACCEPT_LENIENT_DATES = "Validator.AcceptLenientDates";
    public static final int DEFAULT_MAX_LOG_FILE_SIZE = 10000000;
    protected final int MAX_REDIRECT_LOCATION = 1000;
    protected final int MAX_FILE_NAME_LENGTH = 1000;
    public static final String LOG_IMPLEMENTATION = "ESAPI.Logger";
    public static final String AUTHENTICATION_IMPLEMENTATION = "ESAPI.Authenticator";
    public static final String ENCODER_IMPLEMENTATION = "ESAPI.Encoder";
    public static final String ACCESS_CONTROL_IMPLEMENTATION = "ESAPI.AccessControl";
    public static final String ENCRYPTION_IMPLEMENTATION = "ESAPI.Encryptor";
    public static final String INTRUSION_DETECTION_IMPLEMENTATION = "ESAPI.IntrusionDetector";
    public static final String RANDOMIZER_IMPLEMENTATION = "ESAPI.Randomizer";
    public static final String EXECUTOR_IMPLEMENTATION = "ESAPI.Executor";
    public static final String VALIDATOR_IMPLEMENTATION = "ESAPI.Validator";
    public static final String HTTP_UTILITIES_IMPLEMENTATION = "ESAPI.HTTPUtilities";
    public static final String DEFAULT_LOG_IMPLEMENTATION = "org.owasp.esapi.reference.JavaLogFactory";
    public static final String DEFAULT_AUTHENTICATION_IMPLEMENTATION = "org.owasp.esapi.reference.FileBasedAuthenticator";
    public static final String DEFAULT_ENCODER_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultEncoder";
    public static final String DEFAULT_ACCESS_CONTROL_IMPLEMENTATION = "org.owasp.esapi.reference.accesscontrol.DefaultAccessController";
    public static final String DEFAULT_ENCRYPTION_IMPLEMENTATION = "org.owasp.esapi.reference.crypto.JavaEncryptor";
    public static final String DEFAULT_INTRUSION_DETECTION_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultIntrusionDetector";
    public static final String DEFAULT_RANDOMIZER_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultRandomizer";
    public static final String DEFAULT_EXECUTOR_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultExecutor";
    public static final String DEFAULT_HTTP_UTILITIES_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultHTTPUtilities";
    public static final String DEFAULT_VALIDATOR_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultValidator";
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private static final String userHome = System.getProperty("user.home");
    private static String customDirectory = System.getProperty("org.owasp.esapi.resources");
    private String resourceDirectory = ".esapi";
    private final String resourceFile;
    private EsapiPropertyManager esapiPropertyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityConfiguration getInstance() {
        if (instance != null) return instance;
        Class<DefaultSecurityConfiguration> clazz = DefaultSecurityConfiguration.class;
        synchronized (DefaultSecurityConfiguration.class) {
            if (instance != null) return instance;
            instance = new DefaultSecurityConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    DefaultSecurityConfiguration(String resourceFile) {
        this.resourceFile = resourceFile;
        this.esapiPropertyManager = new EsapiPropertyManager();
        try {
            this.loadConfiguration();
            this.setCipherXProperties();
        }
        catch (IOException e) {
            this.logSpecial("Failed to load security configuration", e);
            throw new ConfigurationException("Failed to load security configuration", e);
        }
    }

    public DefaultSecurityConfiguration(Properties properties) {
        this.resourceFile = DEFAULT_RESOURCE_FILE;
        this.properties = properties;
        this.setCipherXProperties();
    }

    public DefaultSecurityConfiguration() {
        this(DEFAULT_RESOURCE_FILE);
    }

    private void setCipherXProperties() {
        this.cipherXformCurrent = this.cipherXformFromESAPIProp = this.getESAPIProperty(CIPHER_TRANSFORMATION_IMPLEMENTATION, "AES/CBC/PKCS5Padding");
    }

    @Override
    public String getApplicationName() {
        return this.getESAPIProperty(APPLICATION_NAME, "DefaultName");
    }

    @Override
    public String getLogImplementation() {
        return this.getESAPIProperty(LOG_IMPLEMENTATION, DEFAULT_LOG_IMPLEMENTATION);
    }

    @Override
    public String getAuthenticationImplementation() {
        return this.getESAPIProperty(AUTHENTICATION_IMPLEMENTATION, DEFAULT_AUTHENTICATION_IMPLEMENTATION);
    }

    @Override
    public String getEncoderImplementation() {
        return this.getESAPIProperty(ENCODER_IMPLEMENTATION, DEFAULT_ENCODER_IMPLEMENTATION);
    }

    @Override
    public String getAccessControlImplementation() {
        return this.getESAPIProperty(ACCESS_CONTROL_IMPLEMENTATION, DEFAULT_ACCESS_CONTROL_IMPLEMENTATION);
    }

    @Override
    public String getEncryptionImplementation() {
        return this.getESAPIProperty(ENCRYPTION_IMPLEMENTATION, DEFAULT_ENCRYPTION_IMPLEMENTATION);
    }

    @Override
    public String getIntrusionDetectionImplementation() {
        return this.getESAPIProperty(INTRUSION_DETECTION_IMPLEMENTATION, DEFAULT_INTRUSION_DETECTION_IMPLEMENTATION);
    }

    @Override
    public String getRandomizerImplementation() {
        return this.getESAPIProperty(RANDOMIZER_IMPLEMENTATION, DEFAULT_RANDOMIZER_IMPLEMENTATION);
    }

    @Override
    public String getExecutorImplementation() {
        return this.getESAPIProperty(EXECUTOR_IMPLEMENTATION, DEFAULT_EXECUTOR_IMPLEMENTATION);
    }

    @Override
    public String getHTTPUtilitiesImplementation() {
        return this.getESAPIProperty(HTTP_UTILITIES_IMPLEMENTATION, DEFAULT_HTTP_UTILITIES_IMPLEMENTATION);
    }

    @Override
    public String getValidationImplementation() {
        return this.getESAPIProperty(VALIDATOR_IMPLEMENTATION, DEFAULT_VALIDATOR_IMPLEMENTATION);
    }

    @Override
    public byte[] getMasterKey() {
        byte[] key = this.getESAPIPropertyEncoded(MASTER_KEY, null);
        if (key == null || key.length == 0) {
            throw new ConfigurationException("Property 'Encryptor.MasterKey' missing or empty in ESAPI.properties file.");
        }
        return key;
    }

    @Override
    public void setResourceDirectory(String dir) {
        this.resourceDirectory = dir;
        this.logSpecial("Reset resource directory to: " + dir, null);
        try {
            this.loadConfiguration();
        }
        catch (IOException e) {
            this.logSpecial("Failed to load security configuration from " + dir, e);
        }
    }

    @Override
    public int getEncryptionKeyLength() {
        return this.getESAPIProperty(KEY_LENGTH, 128);
    }

    @Override
    public byte[] getMasterSalt() {
        byte[] salt = this.getESAPIPropertyEncoded(MASTER_SALT, null);
        if (salt == null || salt.length == 0) {
            throw new ConfigurationException("Property 'Encryptor.MasterSalt' missing or empty in ESAPI.properties file.");
        }
        return salt;
    }

    @Override
    public List<String> getAllowedExecutables() {
        String def = "";
        String[] exList = this.getESAPIProperty(APPROVED_EXECUTABLES, def).split(",");
        return Arrays.asList(exList);
    }

    @Override
    public List<String> getAllowedFileExtensions() {
        String def = ".zip,.pdf,.tar,.gz,.xls,.properties,.txt,.xml";
        String[] extList = this.getESAPIProperty(APPROVED_UPLOAD_EXTENSIONS, def).split(",");
        return Arrays.asList(extList);
    }

    @Override
    public int getAllowedFileUploadSize() {
        return this.getESAPIProperty(MAX_UPLOAD_FILE_BYTES, 5000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromStream(InputStream is, String name) throws IOException {
        Properties config = new Properties();
        try {
            config.load(is);
            this.logSpecial("Loaded '" + name + "' properties file", null);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return config;
    }

    protected void loadConfiguration() throws IOException {
        try {
            this.logSpecial("Attempting to load " + this.resourceFile + " via file I/O.");
            this.properties = this.loadPropertiesFromStream(this.getResourceStream(this.resourceFile), this.resourceFile);
        }
        catch (Exception iae) {
            this.logSpecial("Loading " + this.resourceFile + " via file I/O failed. Exception was: " + iae);
            this.logSpecial("Attempting to load " + this.resourceFile + " via the classpath.");
            try {
                this.properties = this.loadConfigurationFromClasspath(this.resourceFile);
            }
            catch (Exception e) {
                this.logSpecial(this.resourceFile + " could not be loaded by any means. Fail.", e);
                throw new ConfigurationException(this.resourceFile + " could not be loaded by any means. Fail.", e);
            }
        }
        if (this.properties != null) {
            boolean multivalued = this.getESAPIProperty(VALIDATION_PROPERTIES_MULTIVALUED, false);
            String validationPropValue = this.getESAPIProperty(VALIDATION_PROPERTIES, "validation.properties");
            Iterator<Object> validationPropFileNames = multivalued ? StrTokenizer.getCSVInstance(validationPropValue) : Collections.singletonList(validationPropValue).iterator();
            patternCache.clear();
            while (validationPropFileNames.hasNext()) {
                String validationPropFileName = (String)validationPropFileNames.next();
                Properties validationProperties = null;
                try {
                    this.logSpecial("Attempting to load " + validationPropFileName + " via file I/O.");
                    validationProperties = this.loadPropertiesFromStream(this.getResourceStream(validationPropFileName), validationPropFileName);
                }
                catch (Exception iae) {
                    this.logSpecial("Loading " + validationPropFileName + " via file I/O failed.");
                    this.logSpecial("Attempting to load " + validationPropFileName + " via the classpath.");
                    try {
                        validationProperties = this.loadConfigurationFromClasspath(validationPropFileName);
                    }
                    catch (Exception exception) {
                        this.logSpecial(validationPropFileName + " could not be loaded by any means. fail.", exception);
                    }
                }
                if (validationProperties != null) {
                    for (String string : validationProperties.keySet()) {
                        String value = validationProperties.getProperty(string);
                        this.properties.put(string, value);
                    }
                }
                if (!this.shouldPrintProperties()) continue;
            }
        }
    }

    @Override
    public InputStream getResourceStream(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        try {
            File f = this.getResourceFile(filename);
            if (f != null && f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException();
    }

    @Override
    public File getResourceFile(String filename) {
        this.logSpecial("Attempting to load " + filename + " as resource file via file I/O.");
        if (filename == null) {
            this.logSpecial("Failed to load properties via FileIO. Filename is null.");
            return null;
        }
        File f = null;
        f = new File(customDirectory, filename);
        if (customDirectory != null && f.canRead()) {
            this.logSpecial("Found in 'org.owasp.esapi.resources' directory: " + f.getAbsolutePath());
            return f;
        }
        this.logSpecial("Not found in 'org.owasp.esapi.resources' directory or file not readable: " + f.getAbsolutePath());
        URL fileUrl = ClassLoader.getSystemResource(this.resourceDirectory + "/" + filename);
        if (fileUrl == null) {
            fileUrl = ClassLoader.getSystemResource("esapi/" + filename);
        }
        if (fileUrl != null) {
            String fileLocation = fileUrl.getFile();
            f = new File(fileLocation);
            if (f.exists()) {
                this.logSpecial("Found in SystemResource Directory/resourceDirectory: " + f.getAbsolutePath());
                return f;
            }
            this.logSpecial("Not found in SystemResource Directory/resourceDirectory (this should never happen): " + f.getAbsolutePath());
        } else {
            this.logSpecial("Not found in SystemResource Directory/resourceDirectory: " + this.resourceDirectory + File.separator + filename);
        }
        String homeDir = userHome;
        if (homeDir == null) {
            homeDir = "";
        }
        if ((f = new File(homeDir + "/.esapi", filename)).canRead()) {
            this.logSpecial("[Compatibility] Found in 'user.home' directory: " + f.getAbsolutePath());
            return f;
        }
        f = new File(homeDir + "/esapi", filename);
        if (f.canRead()) {
            this.logSpecial("Found in 'user.home' directory: " + f.getAbsolutePath());
            return f;
        }
        this.logSpecial("Not found in 'user.home' (" + homeDir + ") directory: " + f.getAbsolutePath());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationFromClasspath(String fileName) throws IllegalArgumentException {
        Properties result = null;
        InputStream in = null;
        ClassLoader[] loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), this.getClass().getClassLoader()};
        String[] classLoaderNames = new String[]{"current thread context class loader", "system class loader", "class loader for DefaultSecurityConfiguration class"};
        ClassLoader currentLoader = null;
        for (int i = 0; i < loaders.length; ++i) {
            if (loaders[i] == null) continue;
            currentLoader = loaders[i];
            try {
                String currentClasspathSearchLocation = "/ (root)";
                in = loaders[i].getResourceAsStream(fileName);
                if (in == null) {
                    currentClasspathSearchLocation = this.resourceDirectory + "/";
                    in = currentLoader.getResourceAsStream(this.resourceDirectory + "/" + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = ".esapi/";
                    in = currentLoader.getResourceAsStream(".esapi/" + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = "esapi/";
                    in = currentLoader.getResourceAsStream("esapi/" + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = "src/main/resources/";
                    in = currentLoader.getResourceAsStream("src/main/resources/" + fileName);
                }
                if (in == null) continue;
                result = new Properties();
                result.load(in);
                this.logSpecial("SUCCESSFULLY LOADED " + fileName + " via the CLASSPATH from '" + currentClasspathSearchLocation + "' using " + classLoaderNames[i] + "!");
                break;
            }
            catch (Exception e) {
                result = null;
                continue;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to load " + this.resourceFile + " as a classloader resource.");
        }
        return result;
    }

    private void logSpecial(String message, Throwable e) {
        StringBuffer msg = new StringBuffer(message);
        if (e != null) {
            msg.append(" Exception was: ").append(e.toString());
        }
        System.out.println(msg.toString());
    }

    private void logSpecial(String message) {
        System.out.println(message);
    }

    @Override
    public String getPasswordParameterName() {
        return this.getESAPIProperty(PASSWORD_PARAMETER_NAME, "password");
    }

    @Override
    public String getUsernameParameterName() {
        return this.getESAPIProperty(USERNAME_PARAMETER_NAME, "username");
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.getESAPIProperty(ENCRYPTION_ALGORITHM, "AES");
    }

    @Override
    public String getCipherTransformation() {
        assert (this.cipherXformCurrent != null) : "Current cipher transformation is null";
        return this.cipherXformCurrent;
    }

    @Override
    public String setCipherTransformation(String cipherXform) {
        String previous = this.getCipherTransformation();
        if (cipherXform == null) {
            this.cipherXformCurrent = this.cipherXformFromESAPIProp;
        } else {
            assert (!cipherXform.trim().equals("")) : "Cipher transformation cannot be just white space or empty string";
            this.cipherXformCurrent = cipherXform;
        }
        return previous;
    }

    @Override
    public boolean useMACforCipherText() {
        return this.getESAPIProperty(CIPHERTEXT_USE_MAC, true);
    }

    @Override
    public boolean overwritePlainText() {
        return this.getESAPIProperty(PLAINTEXT_OVERWRITE, true);
    }

    @Override
    public String getIVType() {
        String value = this.getESAPIProperty(IV_TYPE, "random");
        if (value.equalsIgnoreCase("fixed") || value.equalsIgnoreCase("random")) {
            return value;
        }
        if (value.equalsIgnoreCase("specified")) {
            throw new ConfigurationException("'Encryptor.ChooseIVMethod=specified' is not yet implemented. Use 'fixed' or 'random'");
        }
        throw new ConfigurationException(value + " is illegal value for " + IV_TYPE + ". Use 'random' (preferred) or 'fixed'.");
    }

    @Override
    public String getFixedIV() {
        if (this.getIVType().equalsIgnoreCase("fixed")) {
            String ivAsHex = this.getESAPIProperty(FIXED_IV, "");
            if (ivAsHex == null || ivAsHex.trim().equals("")) {
                throw new ConfigurationException("Fixed IV requires property Encryptor.fixedIV to be set, but it is not.");
            }
            return ivAsHex;
        }
        throw new ConfigurationException("IV type not 'fixed' (set to '" + this.getIVType() + "'), so no fixed IV applicable.");
    }

    @Override
    public String getHashAlgorithm() {
        return this.getESAPIProperty(HASH_ALGORITHM, "SHA-512");
    }

    @Override
    public int getHashIterations() {
        return this.getESAPIProperty(HASH_ITERATIONS, 1024);
    }

    @Override
    public String getKDFPseudoRandomFunction() {
        return this.getESAPIProperty(KDF_PRF_ALG, "HmacSHA256");
    }

    @Override
    public String getCharacterEncoding() {
        return this.getESAPIProperty(CHARACTER_ENCODING, "UTF-8");
    }

    @Override
    public boolean getAllowMultipleEncoding() {
        return this.getESAPIProperty(ALLOW_MULTIPLE_ENCODING, false);
    }

    @Override
    public boolean getAllowMixedEncoding() {
        return this.getESAPIProperty(ALLOW_MIXED_ENCODING, false);
    }

    @Override
    public List<String> getDefaultCanonicalizationCodecs() {
        ArrayList<String> def = new ArrayList<String>();
        def.add("org.owasp.esapi.codecs.HTMLEntityCodec");
        def.add("org.owasp.esapi.codecs.PercentCodec");
        def.add("org.owasp.esapi.codecs.JavaScriptCodec");
        return this.getESAPIProperty(CANONICALIZATION_CODECS, def);
    }

    @Override
    public String getDigitalSignatureAlgorithm() {
        return this.getESAPIProperty(DIGITAL_SIGNATURE_ALGORITHM, "SHAwithDSA");
    }

    @Override
    public int getDigitalSignatureKeyLength() {
        return this.getESAPIProperty(DIGITAL_SIGNATURE_KEY_LENGTH, 1024);
    }

    @Override
    public String getRandomAlgorithm() {
        return this.getESAPIProperty(RANDOM_ALGORITHM, "SHA1PRNG");
    }

    @Override
    public int getAllowedLoginAttempts() {
        return this.getESAPIProperty(ALLOWED_LOGIN_ATTEMPTS, 5);
    }

    @Override
    public int getMaxOldPasswordHashes() {
        return this.getESAPIProperty(MAX_OLD_PASSWORD_HASHES, 12);
    }

    @Override
    public File getUploadDirectory() {
        String dir = this.getESAPIProperty(UPLOAD_DIRECTORY, "UploadDir");
        return new File(dir);
    }

    @Override
    public File getUploadTempDirectory() {
        String dir = this.getESAPIProperty(UPLOAD_TEMP_DIRECTORY, System.getProperty("java.io.tmpdir", "UploadTempDir"));
        return new File(dir);
    }

    @Override
    public boolean getDisableIntrusionDetection() {
        String value = this.properties.getProperty(DISABLE_INTRUSION_DETECTION);
        return "true".equalsIgnoreCase(value);
    }

    @Override
    public SecurityConfiguration.Threshold getQuota(String eventName) {
        int count = this.getESAPIProperty("IntrusionDetector." + eventName + ".count", 0);
        int interval = this.getESAPIProperty("IntrusionDetector." + eventName + ".interval", 0);
        ArrayList<String> actions2 = new ArrayList();
        String actionString = this.getESAPIProperty("IntrusionDetector." + eventName + ".actions", "");
        if (actionString != null) {
            String[] actionList = actionString.split(",");
            actions2 = Arrays.asList(actionList);
        }
        if (count > 0 && interval > 0 && actions2.size() > 0) {
            return new SecurityConfiguration.Threshold(eventName, count, interval, actions2);
        }
        return null;
    }

    @Override
    public int getLogLevel() {
        String level = this.getESAPIProperty(LOG_LEVEL, "WARNING");
        if (level.equalsIgnoreCase("OFF")) {
            return Integer.MAX_VALUE;
        }
        if (level.equalsIgnoreCase("FATAL")) {
            return 1000;
        }
        if (level.equalsIgnoreCase("ERROR")) {
            return 800;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            return 600;
        }
        if (level.equalsIgnoreCase("INFO")) {
            return 400;
        }
        if (level.equalsIgnoreCase("DEBUG")) {
            return 200;
        }
        if (level.equalsIgnoreCase("TRACE")) {
            return 100;
        }
        if (level.equalsIgnoreCase("ALL")) {
            return Integer.MIN_VALUE;
        }
        this.logSpecial("The LOG-LEVEL property in the ESAPI properties file has the unrecognized value: " + level + ". Using default: WARNING", null);
        return 600;
    }

    @Override
    public String getLogFileName() {
        return this.getESAPIProperty(LOG_FILE_NAME, "ESAPI_logging_file");
    }

    @Override
    public int getMaxLogFileSize() {
        return this.getESAPIProperty(MAX_LOG_FILE_SIZE, 10000000);
    }

    @Override
    public boolean getLogEncodingRequired() {
        return this.getESAPIProperty(LOG_ENCODING_REQUIRED, false);
    }

    @Override
    public boolean getLogApplicationName() {
        return this.getESAPIProperty(LOG_APPLICATION_NAME, true);
    }

    @Override
    public boolean getLogServerIP() {
        return this.getESAPIProperty(LOG_SERVER_IP, true);
    }

    @Override
    public boolean getForceHttpOnlySession() {
        return this.getESAPIProperty(FORCE_HTTPONLYSESSION, true);
    }

    @Override
    public boolean getForceSecureSession() {
        return this.getESAPIProperty(FORCE_SECURESESSION, true);
    }

    @Override
    public boolean getForceHttpOnlyCookies() {
        return this.getESAPIProperty(FORCE_HTTPONLYCOOKIES, true);
    }

    @Override
    public boolean getForceSecureCookies() {
        return this.getESAPIProperty(FORCE_SECURECOOKIES, true);
    }

    @Override
    public int getMaxHttpHeaderSize() {
        return this.getESAPIProperty(MAX_HTTP_HEADER_SIZE, 4096);
    }

    @Override
    public String getResponseContentType() {
        return this.getESAPIProperty(RESPONSE_CONTENT_TYPE, "text/html; charset=UTF-8");
    }

    @Override
    public String getHttpSessionIdName() {
        return this.getESAPIProperty(HTTP_SESSION_ID_NAME, "JSESSIONID");
    }

    @Override
    public long getRememberTokenDuration() {
        int days = this.getESAPIProperty(REMEMBER_TOKEN_DURATION, 14);
        return 86400000 * days;
    }

    @Override
    public int getSessionIdleTimeoutLength() {
        int minutes = this.getESAPIProperty(IDLE_TIMEOUT_DURATION, 20);
        return 60000 * minutes;
    }

    @Override
    public int getSessionAbsoluteTimeoutLength() {
        int minutes = this.getESAPIProperty(ABSOLUTE_TIMEOUT_DURATION, 20);
        return 60000 * minutes;
    }

    @Override
    public Pattern getValidationPattern(String key) {
        String value = this.getESAPIProperty("Validator." + key, "");
        Pattern p = patternCache.get(value);
        if (p != null) {
            return p;
        }
        if (value == null || value.equals("")) {
            return null;
        }
        try {
            Pattern q = Pattern.compile(value);
            patternCache.put(value, q);
            return q;
        }
        catch (PatternSyntaxException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not a valid regex in ESAPI.properties. Returning null", null);
            return null;
        }
    }

    @Override
    public File getWorkingDirectory() {
        String dir = this.getESAPIProperty(WORKING_DIRECTORY, System.getProperty("user.dir"));
        if (dir != null) {
            return new File(dir);
        }
        return null;
    }

    @Override
    public String getPreferredJCEProvider() {
        return this.properties.getProperty(PREFERRED_JCE_PROVIDER);
    }

    @Override
    public List<String> getCombinedCipherModes() {
        ArrayList<String> empty = new ArrayList<String>();
        return this.getESAPIProperty(COMBINED_CIPHER_MODES, empty);
    }

    @Override
    public List<String> getAdditionalAllowedCipherModes() {
        ArrayList<String> empty = new ArrayList<String>();
        return this.getESAPIProperty(ADDITIONAL_ALLOWED_CIPHER_MODES, empty);
    }

    @Override
    public boolean getLenientDatesAccepted() {
        return this.getESAPIProperty(ACCEPT_LENIENT_DATES, false);
    }

    protected String getESAPIProperty(String key, String def) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        return value;
    }

    protected boolean getESAPIProperty(String key, boolean def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
            return true;
        }
        if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
            return false;
        }
        this.logSpecial("SecurityConfiguration for " + key + " not either \"true\" or \"false\" in ESAPI.properties. Using default: " + def, null);
        return def;
    }

    protected byte[] getESAPIPropertyEncoded(String key, byte[] def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        try {
            return ESAPI.encoder().decodeFromBase64(property);
        }
        catch (IOException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not properly Base64 encoded in ESAPI.properties. Using default: " + def, null);
            return null;
        }
    }

    protected int getESAPIProperty(String key, int def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not an integer in ESAPI.properties. Using default: " + def, null);
            return def;
        }
    }

    protected List<String> getESAPIProperty(String key, List<String> def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        String[] parts = property.split(",");
        return Arrays.asList(parts);
    }

    @Override
    public int getIntProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getIntProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect " + "type");
            }
        }
    }

    @Override
    public byte[] getByteArrayProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getByteArrayProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            try {
                return ESAPI.encoder().decodeFromBase64(property);
            }
            catch (IOException e) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect " + "type");
            }
        }
    }

    @Override
    public Boolean getBooleanProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getBooleanProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
                return true;
            }
            if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
                return false;
            }
            throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect " + "type");
        }
    }

    @Override
    public String getStringProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getStringProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            return property;
        }
    }

    protected boolean shouldPrintProperties() {
        return this.getESAPIProperty(PRINT_PROPERTIES_WHEN_LOADED, false);
    }

    protected Properties getESAPIProperties() {
        return this.properties;
    }
}

