/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAMLSimpleSignatureSecurityPolicyRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLSimpleSignatureSecurityPolicyRule.class);
    private SignatureTrustEngine trustEngine;

    protected BaseSAMLSimpleSignatureSecurityPolicyRule(SignatureTrustEngine engine) {
        this.trustEngine = engine;
    }

    @Override
    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        this.log.debug("Evaluating simple signature rule of type: {}", (Object)this.getClass().getName());
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HttpServletRequestAdapter)) {
            this.log.debug("Invalid inbound message transport type, this rule only supports HttpServletRequestAdapter");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HttpServletRequestAdapter requestAdapter = (HttpServletRequestAdapter)messageContext.getInboundMessageTransport();
        HttpServletRequest request = requestAdapter.getWrappedRequest();
        if (!this.ruleHandles(request, samlMsgCtx)) {
            this.log.debug("Rule can not handle this request, skipping processing");
            return;
        }
        byte[] signature = this.getSignature(request);
        if (signature == null || signature.length == 0) {
            this.log.debug("HTTP request was not signed via simple signature mechanism, skipping");
            return;
        }
        String sigAlg = this.getSignatureAlgorithm(request);
        if (DatatypeHelper.isEmpty(sigAlg)) {
            this.log.warn("Signature algorithm could not be extracted from request, can not validate simple signature");
            return;
        }
        byte[] signedContent = this.getSignedContent(request);
        if (signedContent == null || signedContent.length == 0) {
            this.log.warn("Signed content could not be extracted from HTTP request, can not validate");
            return;
        }
        this.doEvaluate(signature, signedContent, sigAlg, request, samlMsgCtx);
    }

    private void doEvaluate(byte[] signature, byte[] signedContent, String algorithmURI, HttpServletRequest request, SAMLMessageContext samlMsgCtx) throws SecurityPolicyException {
        List<Credential> candidateCredentials = this.getRequestCredentials(request, samlMsgCtx);
        String contextIssuer = samlMsgCtx.getInboundMessageIssuer();
        if (contextIssuer != null) {
            this.log.debug("Attempting to validate SAML protocol message simple signature using context issuer: {}", (Object)contextIssuer);
            CriteriaSet criteriaSet = this.buildCriteriaSet(contextIssuer, samlMsgCtx);
            if (this.validateSignature(signature, signedContent, algorithmURI, criteriaSet, candidateCredentials)) {
                this.log.info("Validation of request simple signature succeeded");
                if (!samlMsgCtx.isInboundSAMLMessageAuthenticated()) {
                    this.log.info("Authentication via request simple signature succeeded for context issuer entity ID {}", (Object)contextIssuer);
                    samlMsgCtx.setInboundSAMLMessageAuthenticated(true);
                }
                return;
            }
            this.log.warn("Validation of request simple signature failed for context issuer: {}", (Object)contextIssuer);
            throw new SecurityPolicyException("Validation of request simple signature failed for context issuer");
        }
        String derivedIssuer = this.deriveSignerEntityID(samlMsgCtx);
        if (derivedIssuer != null) {
            this.log.debug("Attempting to validate SAML protocol message simple signature using derived issuer: {}", (Object)derivedIssuer);
            CriteriaSet criteriaSet = this.buildCriteriaSet(derivedIssuer, samlMsgCtx);
            if (this.validateSignature(signature, signedContent, algorithmURI, criteriaSet, candidateCredentials)) {
                this.log.info("Validation of request simple signature succeeded");
                if (!samlMsgCtx.isInboundSAMLMessageAuthenticated()) {
                    this.log.info("Authentication via request simple signature succeeded for derived issuer {}", (Object)derivedIssuer);
                    samlMsgCtx.setInboundMessageIssuer(derivedIssuer);
                    samlMsgCtx.setInboundSAMLMessageAuthenticated(true);
                }
                return;
            }
            this.log.warn("Validation of request simple signature failed for derived issuer: {}", (Object)derivedIssuer);
            throw new SecurityPolicyException("Validation of request simple signature failed for derived issuer");
        }
        this.log.warn("Neither context nor derived issuer available, can not attempt SAML simple signature validation");
        throw new SecurityPolicyException("No message issuer available, can not attempt simple signature validation");
    }

    protected boolean validateSignature(byte[] signature, byte[] signedContent, String algorithmURI, CriteriaSet criteriaSet, List<Credential> candidateCredentials) throws SecurityPolicyException {
        SignatureTrustEngine engine = this.getTrustEngine();
        try {
            if (candidateCredentials == null || candidateCredentials.isEmpty()) {
                if (engine.validate(signature, signedContent, algorithmURI, criteriaSet, null)) {
                    this.log.debug("Simple signature validation (with no request-derived credentials) was successful");
                    return true;
                }
                this.log.warn("Simple signature validation (with no request-derived credentials) failed");
                return false;
            }
            for (Credential cred : candidateCredentials) {
                if (!engine.validate(signature, signedContent, algorithmURI, criteriaSet, cred)) continue;
                this.log.debug("Simple signature validation succeeded with a request-derived credential");
                return true;
            }
            this.log.warn("Signature validation using request-derived credentials failed");
            return false;
        }
        catch (SecurityException e) {
            this.log.warn("There was an error evaluating the request's simple signature using the trust engine", (Throwable)e);
            throw new SecurityPolicyException("Error during trust engine evaluation of the simple signature", e);
        }
    }

    protected List<Credential> getRequestCredentials(HttpServletRequest request, SAMLMessageContext samlContext) throws SecurityPolicyException {
        return null;
    }

    protected SignatureTrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    protected byte[] getSignature(HttpServletRequest request) throws SecurityPolicyException {
        String signature = request.getParameter("Signature");
        if (DatatypeHelper.isEmpty(signature)) {
            return null;
        }
        return Base64.decode(signature);
    }

    protected String getSignatureAlgorithm(HttpServletRequest request) throws SecurityPolicyException {
        return request.getParameter("SigAlg");
    }

    protected String deriveSignerEntityID(SAMLMessageContext samlContext) throws SecurityPolicyException {
        return null;
    }

    protected CriteriaSet buildCriteriaSet(String entityID, SAMLMessageContext samlContext) throws SecurityPolicyException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!DatatypeHelper.isEmpty(entityID)) {
            criteriaSet.add(new EntityIDCriteria(entityID));
        }
        MetadataCriteria mdCriteria = new MetadataCriteria(samlContext.getPeerEntityRole(), samlContext.getInboundSAMLProtocol());
        criteriaSet.add(mdCriteria);
        criteriaSet.add(new UsageCriteria(UsageType.SIGNING));
        return criteriaSet;
    }

    protected abstract byte[] getSignedContent(HttpServletRequest var1) throws SecurityPolicyException;

    protected abstract boolean ruleHandles(HttpServletRequest var1, SAMLMessageContext var2) throws SecurityPolicyException;
}

