/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.accesscontrol;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.apache.commons.collections.iterators.ArrayListIterator;
import org.owasp.esapi.reference.accesscontrol.BaseACR;
import org.owasp.esapi.reference.accesscontrol.DynaBeanACRParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingACR
extends BaseACR<DynaBeanACRParameter, Object[]> {
    protected Method delegateMethod;
    protected Object delegateInstance;

    @Override
    public void setPolicyParameters(DynaBeanACRParameter policyParameter) {
        String delegateClassName = policyParameter.getString("delegateClass", "").trim();
        String methodName = policyParameter.getString("delegateMethod", "").trim();
        String[] parameterClassNames = policyParameter.getStringArray("parameterClasses");
        Class delegateClass = this.getClass(delegateClassName, "delegate");
        Class[] parameterClasses = this.getParameters(parameterClassNames);
        try {
            this.delegateMethod = delegateClass.getMethod(methodName, parameterClasses);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.getMessage() + " delegateClass.delegateMethod(parameterClasses): \"" + delegateClassName + "." + methodName + "(" + parameterClassNames + ")\" must be public.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage() + " delegateClass.delegateMethod(parameterClasses): \"" + delegateClassName + "." + methodName + "(" + parameterClassNames + ")\" does not exist.", e);
        }
        if (!Modifier.isStatic(this.delegateMethod.getModifiers())) {
            try {
                this.delegateInstance = delegateClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException(" Delegate class \"" + delegateClassName + "\" must be concrete, because method " + delegateClassName + "." + methodName + "(" + parameterClassNames + ") is not static.", ex);
            }
            catch (IllegalAccessException ex) {
                new IllegalArgumentException(" Delegate class \"" + delegateClassName + "\" must must have a zero-argument constructor, because " + "method delegateClass.delegateMethod(parameterClasses): \"" + delegateClassName + "." + methodName + "(" + parameterClassNames + ")\" is not static.", ex);
            }
        } else {
            this.delegateInstance = null;
        }
    }

    protected final Class[] getParameters(String[] parameterClassNames) {
        if (parameterClassNames == null) {
            return new Class[0];
        }
        Vector<Class> classes = new Vector<Class>();
        ArrayListIterator classNames = new ArrayListIterator(parameterClassNames);
        while (classNames.hasNext()) {
            classes.add(this.getClass((String)classNames.next(), "parameter"));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected final Class getClass(String className, String purpose) {
        try {
            Class<?> theClass = Class.forName(className);
            return theClass;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " " + purpose + " Class " + className + " must be in the classpath", ex);
        }
    }

    @Override
    public boolean isAuthorized(Object[] runtimeParameters) throws Exception {
        return (Boolean)this.delegateMethod.invoke(this.delegateInstance, runtimeParameters);
    }
}

