/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverSAMLCommand;
import com.liferay.saml.opensaml.integration.internal.resolver.SAMLCommandImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.UserResolverSAMLCommand;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import com.liferay.saml.opensaml.integration.resolver.Resolver;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;

public interface SAMLCommands {
    public static final Resolver.SAMLCommand<String, Resolver> peerEntityId = new SAMLCommandImpl(SAMLMessageContext::getPeerEntityId);
    public static final Resolver.SAMLCommand<String, Resolver> subjectNameFormat = new SAMLCommandImpl(samlMessageContext -> {
        NameID nameId = (NameID)samlMessageContext.getSubjectNameIdentifier();
        if (nameId == null) {
            return null;
        }
        return nameId.getFormat();
    });
    public static final Resolver.SAMLCommand<String, Resolver> subjectNameIdentifier = new SAMLCommandImpl(samlMessageContext -> {
        NameID nameId = (NameID)samlMessageContext.getSubjectNameIdentifier();
        if (nameId == null) {
            return null;
        }
        return nameId.getValue();
    });

    public static Resolver.SAMLCommand<Map<String, List<Serializable>>, UserResolver> bearerAssertionAttributesWithMapping(Properties userAttributeMappingsProperties) {
        return new UserResolverSAMLCommand<Map<String, List<Serializable>>, UserResolver>((Function<SAMLMessageContext<Response, SAMLObject, NameID>, Map<String, List<Serializable>>>)((Function<SAMLMessageContext, Map>)samlMessageContext -> {
            Response response = (Response)samlMessageContext.getInboundSAMLMessage();
            if (response == null) {
                return Collections.emptyMap();
            }
            List<Assertion> assertions = response.getAssertions();
            Stream assertionsStream = assertions.stream();
            List<Attribute> bearerAssertionAttributes = assertionsStream.filter(assertion -> {
                Subject subject = assertion.getSubject();
                if (subject == null) {
                    return false;
                }
                List<SubjectConfirmation> subjectConfirmations = subject.getSubjectConfirmations();
                if (subjectConfirmations == null) {
                    return false;
                }
                Stream subjectConfirmationsStream = subjectConfirmations.stream();
                long count = subjectConfirmationsStream.filter(subjectConfirmation -> "urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())).count();
                return count > 0L;
            }).map(Assertion::getAttributeStatements).flatMap(Collection::stream).map(AttributeStatement::getAttributes).flatMap(Collection::stream).collect(Collectors.toList());
            return SamlUtil.getAttributesMap(bearerAssertionAttributes, userAttributeMappingsProperties);
        }));
    }

    public static Resolver.SAMLCommand<List<String>, AttributeResolver> ssoServicesLocationForBinding(String binding) {
        return new AttributeResolverSAMLCommand<List<String>, AttributeResolver>((Function<SAMLMessageContext<AuthnRequest, Response, NameID>, List<String>>)((Function<SAMLMessageContext, List>)samlMessageContext -> {
            IDPSSODescriptor idpSsoDescriptor = (IDPSSODescriptor)samlMessageContext.getLocalEntityRoleMetadata();
            if (idpSsoDescriptor == null) {
                return null;
            }
            List<SingleSignOnService> singleSignOnServices = idpSsoDescriptor.getSingleSignOnServices();
            if (singleSignOnServices == null) {
                return null;
            }
            Stream singleSignOnServicesStream = singleSignOnServices.stream();
            return singleSignOnServicesStream.filter(ssos -> binding.equals(ssos.getBinding())).map(Endpoint::getLocation).collect(Collectors.toList());
        }));
    }
}

