/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.saml.opensaml.integration.internal.resolver.DefaultServiceReferenceMapper;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={AttributeResolverRegistry.class})
public class AttributeResolverRegistry {
    private static final Log _log = LogFactoryUtil.getLog(AttributeResolverRegistry.class);
    private ServiceTrackerMap<String, AttributeResolver> _attributeResolvers;
    private AttributeResolver _defaultAttributeResolver;

    public AttributeResolver getAttributeResolver(String entityId) {
        long companyId = CompanyThreadLocal.getCompanyId();
        AttributeResolver attributeResolver = (AttributeResolver)this._attributeResolvers.getService((Object)(companyId + "," + entityId));
        if (attributeResolver == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No attribute resolver for company ID " + companyId + " and entity ID " + entityId));
            }
            attributeResolver = this._defaultAttributeResolver;
        }
        return attributeResolver;
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, target="(!(companyId=*))", unbind="-")
    public void setDefaultAttributeResolver(AttributeResolver defaultAttributeResolver) {
        this._defaultAttributeResolver = defaultAttributeResolver;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._attributeResolvers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AttributeResolver.class, (String)"(companyId=*)", (ServiceReferenceMapper)new DefaultServiceReferenceMapper(_log));
    }

    @Deactivate
    protected void deactivate() {
        this._attributeResolvers.close();
    }
}

