/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.binding;

import com.liferay.saml.opensaml.integration.internal.transport.HttpClientOutTransport;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.opensaml.saml2.binding.encoding.HTTPSOAP11Encoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.OutTransport;

public class HttpSoap11Encoder
extends HTTPSOAP11Encoder {
    private final HttpClient _httpClient;

    public HttpSoap11Encoder() {
        this(new HttpClient());
    }

    public HttpSoap11Encoder(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    @Override
    public void encode(MessageContext messageContext) throws MessageEncodingException {
        super.encode(messageContext);
        OutTransport outTransport = messageContext.getOutboundMessageTransport();
        if (outTransport instanceof HttpClientOutTransport) {
            HttpClientOutTransport httpClientTransport = (HttpClientOutTransport)outTransport;
            PostMethod postMethod = httpClientTransport.getPostMethod();
            try {
                this._httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (Exception e) {
                throw new MessageEncodingException(e);
            }
        }
    }
}

