/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.profile;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.profile.BaseProfile;
import com.liferay.saml.opensaml.integration.internal.profile.ExceptionHandlerUtil;
import com.liferay.saml.opensaml.integration.internal.profile.SamlSsoRequestContext;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributePublisherImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverRegistry;
import com.liferay.saml.opensaml.integration.internal.resolver.AttributeResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.NameIdResolverRegistry;
import com.liferay.saml.opensaml.integration.internal.resolver.NameIdResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.resolver.UserResolverSAMLContextImpl;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException;
import com.liferay.saml.persistence.exception.NoSuchSpIdpConnectionException;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlSpAuthRequest;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.model.SamlSpMessage;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSsoSessionLocalService;
import com.liferay.saml.persistence.service.SamlSpAuthRequestLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlSpMessageLocalService;
import com.liferay.saml.persistence.service.SamlSpSessionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.exception.AssertionException;
import com.liferay.saml.runtime.exception.AudienceException;
import com.liferay.saml.runtime.exception.DestinationException;
import com.liferay.saml.runtime.exception.ExpiredException;
import com.liferay.saml.runtime.exception.InResponseToException;
import com.liferay.saml.runtime.exception.IssuerException;
import com.liferay.saml.runtime.exception.ReplayException;
import com.liferay.saml.runtime.exception.SignatureException;
import com.liferay.saml.runtime.exception.StatusException;
import com.liferay.saml.runtime.exception.SubjectException;
import com.liferay.saml.runtime.profile.WebSsoProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true)
public class WebSsoProfileImpl
extends BaseProfile
implements WebSsoProfile {
    private static final Log _log = LogFactoryUtil.getLog(WebSsoProfileImpl.class);
    private static final SAMLSignatureProfileValidator _samlSignatureProfileValidator = new SAMLSignatureProfileValidator();
    private AttributeResolverRegistry _attributeResolverRegistry;
    private NameIdResolverRegistry _nameIdResolverRegistry;
    private SamlConfiguration _samlConfiguration;
    @Reference
    private SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    @Reference
    private SamlIdpSsoSessionLocalService _samlIdpSsoSessionLocalService;
    private SamlSpAuthRequestLocalService _samlSpAuthRequestLocalService;
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;
    private SamlSpMessageLocalService _samlSpMessageLocalService;
    @Reference
    private UserLocalService _userLocalService;
    private UserResolver _userResolver;

    public void processAuthnRequest(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        try {
            this.doProcessAuthnRequest(request, response);
        }
        catch (Exception e) {
            ExceptionHandlerUtil.handleException(e);
        }
    }

    public void processResponse(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        try {
            this.doProcessResponse(request, response);
        }
        catch (Exception e) {
            ExceptionHandlerUtil.handleException(e);
        }
    }

    public void sendAuthnRequest(HttpServletRequest request, HttpServletResponse response, String relayState) throws PortalException {
        try {
            this.doSendAuthnRequest(request, response, relayState);
        }
        catch (Exception e) {
            ExceptionHandlerUtil.handleException(e);
        }
    }

    public void updateSamlSpSession(HttpServletRequest request, HttpServletResponse response) {
        block3: {
            SamlSpSession samlSpSession = this.getSamlSpSession(request);
            HttpSession session = request.getSession();
            String jSessionId = session.getId();
            if (samlSpSession != null && !jSessionId.equals(samlSpSession.getJSessionId())) {
                try {
                    this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession.getPrimaryKey(), jSessionId);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._samlConfiguration = (SamlConfiguration)ConfigurableUtil.createConfigurable(SamlConfiguration.class, properties);
    }

    protected void addSamlSsoSession(HttpServletRequest request, HttpServletResponse response, SamlSsoRequestContext samlSsoRequestContext, NameID nameID) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.addSamlIdpSsoSession(samlSsoRequestContext.getSamlSsoSessionId(), serviceContext);
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        this._samlIdpSpSessionLocalService.addSamlIdpSpSession(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlMessageContext.getPeerEntityId(), nameID.getFormat(), nameID.getValue(), serviceContext);
        this.addCookie(request, response, "SAML_SSO_SESSION_ID", samlSsoRequestContext.getSamlSsoSessionId(), -1);
    }

    protected SamlSsoRequestContext decodeAuthnConversationAfterLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        SamlSsoRequestContext samlSsoRequestContext = (SamlSsoRequestContext)session.getAttribute("SAML_SSO_REQUEST_CONTEXT");
        if (samlSsoRequestContext != null) {
            session.removeAttribute("SAML_SSO_REQUEST_CONTEXT");
            SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = this.getSamlMessageContext(request, response, samlSsoRequestContext.getPeerEntityId());
            samlSsoRequestContext.setSAMLMessageContext(samlMessageContext);
            String authnRequestXml = samlSsoRequestContext.getAutnRequestXml();
            if (Validator.isNotNull((String)authnRequestXml)) {
                AuthnRequest authnRequest = (AuthnRequest)OpenSamlUtil.unmarshall(authnRequestXml);
                samlMessageContext.setInboundSAMLMessage(authnRequest);
                samlMessageContext.setInboundSAMLMessageId(authnRequest.getID());
            }
            String relayState = samlSsoRequestContext.getRelayState();
            samlMessageContext.setRelayState(relayState);
            String samlSsoSessionId = this.getSamlSsoSessionId(request);
            if (Validator.isNotNull((String)samlSsoSessionId)) {
                samlSsoRequestContext.setSamlSsoSessionId(samlSsoSessionId);
            } else {
                samlSsoRequestContext.setNewSession(true);
                samlSsoRequestContext.setSamlSsoSessionId(this.generateIdentifier(30));
            }
            samlSsoRequestContext.setStage(1);
            long userId = this.portal.getUserId(request);
            samlSsoRequestContext.setUserId(userId);
            return samlSsoRequestContext;
        }
        return null;
    }

    protected SamlSsoRequestContext decodeAuthnRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext;
        SamlSsoRequestContext samlSsoRequestContext;
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext2;
        SamlSsoRequestContext samlSsoRequestContext2;
        String samlMessageId = ParamUtil.getString((HttpServletRequest)request, (String)"saml_message_id");
        if (!Validator.isBlank((String)samlMessageId) && (samlSsoRequestContext2 = this.decodeAuthnConversationAfterLogin(request, response)) != null && (samlMessageContext2 = samlSsoRequestContext2.getSAMLMessageContext()) != null && samlMessageId.equals(samlMessageContext2.getInboundSAMLMessageId())) {
            return samlSsoRequestContext2;
        }
        boolean idpInitiatedSSO = false;
        String entityId = ParamUtil.getString((HttpServletRequest)request, (String)"entityId");
        String samlRequest = ParamUtil.getString((HttpServletRequest)request, (String)"SAMLRequest");
        if (Validator.isNotNull((String)entityId) && Validator.isNull((String)samlRequest)) {
            idpInitiatedSSO = true;
        }
        if (idpInitiatedSSO && (samlSsoRequestContext = this.decodeAuthnConversationAfterLogin(request, response)) != null && (samlMessageContext = samlSsoRequestContext.getSAMLMessageContext()) != null && entityId.equals(samlMessageContext.getPeerEntityId())) {
            return samlSsoRequestContext;
        }
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext3 = null;
        SamlBinding samlBinding = null;
        samlBinding = StringUtil.equalsIgnoreCase((String)request.getMethod(), (String)"GET") ? this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") : this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SamlSsoRequestContext samlSsoRequestContext3 = null;
        if (idpInitiatedSSO) {
            samlMessageContext3 = this.getSamlMessageContext(request, response, entityId);
            samlMessageContext3.setCommunicationProfileId(samlBinding.getCommunicationProfileId());
            String relayState = ParamUtil.getString((HttpServletRequest)request, (String)"RelayState");
            samlMessageContext3.setRelayState(relayState);
            samlSsoRequestContext3 = new SamlSsoRequestContext(samlMessageContext3.getPeerEntityId(), relayState, samlMessageContext3, this._userLocalService);
        } else {
            SamlProviderConfiguration samlProviderConfiguration = this.samlProviderConfigurationHelper.getSamlProviderConfiguration();
            samlMessageContext3 = this.decodeSamlMessage(request, response, samlBinding, samlProviderConfiguration.authnRequestSignatureRequired());
            AuthnRequest authnRequest = (AuthnRequest)samlMessageContext3.getInboundSAMLMessage();
            String authnRequestXml = OpenSamlUtil.marshall(authnRequest);
            samlSsoRequestContext3 = new SamlSsoRequestContext(authnRequestXml, samlMessageContext3.getPeerEntityId(), samlMessageContext3.getRelayState(), samlMessageContext3, this._userLocalService);
        }
        String samlSsoSessionId = this.getSamlSsoSessionId(request);
        if (Validator.isNotNull((String)samlSsoSessionId)) {
            samlSsoRequestContext3.setSamlSsoSessionId(samlSsoSessionId);
        } else {
            samlSsoRequestContext3.setNewSession(true);
            samlSsoRequestContext3.setSamlSsoSessionId(this.generateIdentifier(30));
        }
        samlSsoRequestContext3.setStage(0);
        long userId = this.portal.getUserId(request);
        samlSsoRequestContext3.setUserId(userId);
        return samlSsoRequestContext3;
    }

    protected void doProcessAuthnRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SamlSsoRequestContext samlSsoRequestContext = this.decodeAuthnRequest(request, response);
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        AuthnRequest authnRequest = samlMessageContext.getInboundSAMLMessage();
        User user = samlSsoRequestContext.getUser();
        if (authnRequest != null && authnRequest.isPassive().booleanValue() && user == null) {
            this.sendFailureResponse(samlSsoRequestContext, "urn:oasis:names:tc:SAML:2.0:status:NoPassive");
            return;
        }
        boolean sessionExpired = false;
        if (!samlSsoRequestContext.isNewSession()) {
            String samlSsoSessionId = samlSsoRequestContext.getSamlSsoSessionId();
            SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId);
            if (samlIdpSsoSession != null) {
                sessionExpired = samlIdpSsoSession.isExpired();
            } else {
                samlSsoSessionId = null;
                samlSsoRequestContext.setSamlSsoSessionId(null);
            }
            if (sessionExpired || Validator.isNull((String)samlSsoSessionId)) {
                this.addCookie(request, response, "SAML_SSO_SESSION_ID", "", 0);
                samlSsoRequestContext.setNewSession(true);
                samlSsoRequestContext.setSamlSsoSessionId(this.generateIdentifier(30));
            }
        }
        if (sessionExpired || user == null || authnRequest != null && authnRequest.isForceAuthn().booleanValue() && user != null && samlSsoRequestContext.getStage() == 0) {
            boolean forceAuthn = false;
            if (authnRequest != null && authnRequest.isForceAuthn().booleanValue()) {
                forceAuthn = true;
            }
            this.redirectToLogin(request, response, samlSsoRequestContext, forceAuthn);
        } else {
            this.sendSuccessResponse(request, response, samlSsoRequestContext);
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute("FORCE_REAUTHENTICATION");
            }
        }
    }

    protected void doProcessResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<AuthnStatement> authnStatements;
        SAMLMessageContext<Response, SAMLObject, NameID> samlMessageContext = this.decodeSamlMessage(request, response, this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"), true);
        Response samlResponse = (Response)samlMessageContext.getInboundSAMLMessage();
        Status status = samlResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        String statusCodeURI = statusCode.getValue();
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            StatusCode childStatusCode = statusCode.getStatusCode();
            if (childStatusCode != null && Validator.isNotNull((String)childStatusCode.getValue())) {
                throw new StatusException(childStatusCode.getValue());
            }
            throw new StatusException(statusCodeURI);
        }
        this.verifyInResponseTo(samlResponse);
        this.verifyDestination(samlMessageContext, samlResponse.getDestination());
        this.verifyIssuer(samlMessageContext, samlResponse.getIssuer());
        Assertion assertion = null;
        SignatureTrustEngine signatureTrustEngine = this.metadataManager.getSignatureTrustEngine();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Assertion curAssertion : samlResponse.getAssertions()) {
            Object subject;
            try {
                this.verifyAssertion(curAssertion, samlMessageContext, signatureTrustEngine);
            }
            catch (SamlException se) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Rejecting assertion " + curAssertion.getID()), (Throwable)se);
                continue;
            }
            authnStatements = curAssertion.getAuthnStatements();
            if (!authnStatements.isEmpty() && (subject = curAssertion.getSubject()) != null && subject.getSubjectConfirmations() != null) {
                for (SubjectConfirmation subjectConfirmation : subject.getSubjectConfirmations()) {
                    if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())) continue;
                    assertion = curAssertion;
                    break;
                }
            }
            if (assertion == null) continue;
            for (AttributeStatement attributeStatement : curAssertion.getAttributeStatements()) {
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    attributes.add(attribute);
                }
            }
        }
        if (assertion == null) {
            throw new AssertionException("Response does not contain any acceptable assertions");
        }
        NameID nameID = (NameID)samlMessageContext.getSubjectNameIdentifier();
        if (nameID == null) {
            throw new SamlException("Name ID not present in subject");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SAML authenticated user " + nameID.getValue()));
        }
        String assertionXml = OpenSamlUtil.marshall(assertion);
        authnStatements = assertion.getAuthnStatements();
        AuthnStatement authnStatement = authnStatements.get(0);
        String sessionIndex = authnStatement.getSessionIndex();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        User user = this._userResolver.resolveUser(new UserResolverSAMLContextImpl(samlMessageContext), serviceContext);
        serviceContext.setUserId(user.getUserId());
        HttpSession session = request.getSession();
        SamlSpSession samlSpSession = this.getSamlSpSession(request);
        if (samlSpSession != null) {
            this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession.getSamlSpSessionId(), samlSpSession.getSamlSpSessionKey(), assertionXml, session.getId(), nameID.getFormat(), nameID.getNameQualifier(), nameID.getSPNameQualifier(), nameID.getValue(), sessionIndex, serviceContext);
        } else {
            String samlSpSessionKey = this.generateIdentifier(30);
            samlSpSession = this.samlSpSessionLocalService.addSamlSpSession(samlSpSessionKey, assertionXml, session.getId(), nameID.getFormat(), nameID.getNameQualifier(), nameID.getSPNameQualifier(), nameID.getValue(), sessionIndex, serviceContext);
        }
        session.setAttribute("SAML_SP_SESSION_KEY", (Object)samlSpSession.getSamlSpSessionKey());
        this.addCookie(request, response, "SAML_SP_SESSION_KEY", samlSpSession.getSamlSpSessionKey(), -1);
        StringBundler sb = new StringBundler(3);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/saml/auth_redirect?redirect=");
        String relayState = this.portal.escapeRedirect(samlMessageContext.getRelayState());
        if (Validator.isNull((String)relayState)) {
            relayState = this.portal.getHomeURL(request);
        }
        sb.append(URLCodec.encodeURL((String)relayState));
        response.sendRedirect(sb.toString());
    }

    protected void doSendAuthnRequest(HttpServletRequest request, HttpServletResponse response, String relayState) throws Exception {
        String entityId = this.metadataManager.getDefaultIdpEntityId();
        SAMLMessageContext<?, ?, ?> samlMessageContext = this.getSamlMessageContext(request, response, entityId);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getLocalEntityRoleMetadata();
        AssertionConsumerService assertionConsumerService = SamlUtil.getAssertionConsumerServiceForBinding(spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleSignOnService singleSignOnService = SamlUtil.resolveSingleSignOnService(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        NameIDPolicy nameIDPolicy = OpenSamlUtil.buildNameIdPolicy();
        nameIDPolicy.setAllowCreate(true);
        nameIDPolicy.setFormat(this.metadataManager.getNameIdFormat(entityId));
        AuthnRequest authnRequest = OpenSamlUtil.buildAuthnRequest(samlMessageContext.getLocalEntityId(), assertionConsumerService, singleSignOnService, nameIDPolicy);
        authnRequest.setID(this.generateIdentifier(20));
        long companyId = this.portal.getCompanyId(request);
        boolean forceAuthn = false;
        try {
            SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
            forceAuthn = samlSpIdpConnection.isForceAuthn();
        }
        catch (NoSuchSpIdpConnectionException samlSpIdpConnection) {
            // empty catch block
        }
        authnRequest.setForceAuthn(forceAuthn);
        samlMessageContext.setOutboundSAMLMessage(authnRequest);
        if (spSSODescriptor.isAuthnRequestsSigned().booleanValue() || idpSSODescriptor.getWantAuthnRequestsSigned().booleanValue()) {
            Credential credential = this.metadataManager.getSigningCredential();
            samlMessageContext.setOutboundSAMLMessageSigningCredential(credential);
            OpenSamlUtil.signObject(authnRequest, credential);
        }
        samlMessageContext.setPeerEntityEndpoint(singleSignOnService);
        samlMessageContext.setRelayState(relayState);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        this._samlSpAuthRequestLocalService.addSamlSpAuthRequest(samlMessageContext.getPeerEntityId(), authnRequest.getID(), serviceContext);
        this.sendSamlMessage(samlMessageContext);
    }

    protected Assertion getSuccessAssertion(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, NameID nameID) {
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        Assertion assertion = OpenSamlUtil.buildAssertion();
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        SubjectConfirmationData subjectConfirmationData = this.getSuccessSubjectConfirmationData(samlSsoRequestContext, assertionConsumerService, issueInstantDateTime);
        Conditions conditions = this.getSuccessConditions(samlSsoRequestContext, issueInstantDateTime, subjectConfirmationData.getNotOnOrAfter());
        assertion.setConditions(conditions);
        assertion.setID(this.generateIdentifier(20));
        assertion.setIssueInstant(issueInstantDateTime);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        assertion.setIssuer(issuer);
        Subject subject = this.getSuccessSubject(samlSsoRequestContext, assertionConsumerService, nameID, subjectConfirmationData);
        assertion.setSubject(subject);
        assertion.setVersion(SAMLVersion.VERSION_20);
        List<AuthnStatement> authnStatements = assertion.getAuthnStatements();
        authnStatements.add(this.getSuccessAuthnStatement(samlSsoRequestContext, assertion));
        boolean attributesEnabled = this.metadataManager.isAttributesEnabled(samlMessageContext.getPeerEntityId());
        if (!attributesEnabled) {
            return assertion;
        }
        User user = samlSsoRequestContext.getUser();
        AttributeResolver attributeResolver = this._attributeResolverRegistry.getAttributeResolver(samlMessageContext.getPeerEntityId());
        AttributePublisherImpl attributePublisherImpl = new AttributePublisherImpl();
        attributeResolver.resolve(user, new AttributeResolverSAMLContextImpl(samlMessageContext), attributePublisherImpl);
        List<Attribute> attributes = attributePublisherImpl.getAttributes();
        if (attributes.isEmpty()) {
            return assertion;
        }
        List<AttributeStatement> attributeStatements = assertion.getAttributeStatements();
        AttributeStatement attributeStatement = OpenSamlUtil.buildAttributeStatement();
        attributeStatements.add(attributeStatement);
        List<Attribute> attributeStatementAttributes = attributeStatement.getAttributes();
        attributeStatementAttributes.addAll(attributes);
        return assertion;
    }

    protected AudienceRestriction getSuccessAudienceRestriction(String entityId) {
        AudienceRestriction audienceRestriction = OpenSamlUtil.buildAudienceRestriction();
        List<Audience> audiences = audienceRestriction.getAudiences();
        Audience audience = OpenSamlUtil.buildAudience();
        audience.setAudienceURI(entityId);
        audiences.add(audience);
        return audienceRestriction;
    }

    protected AuthnContext getSuccessAuthnContext() {
        AuthnContext authnContext = OpenSamlUtil.buildAuthnContext();
        AuthnContextClassRef authnContextClassRef = OpenSamlUtil.buildAuthnContextClassRef();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        return authnContext;
    }

    protected AuthnStatement getSuccessAuthnStatement(SamlSsoRequestContext samlSsoRequestContext, Assertion assertion) {
        AuthnStatement authnStatement = OpenSamlUtil.buildAuthnStatement();
        AuthnContext authnContext = this.getSuccessAuthnContext();
        authnStatement.setAuthnContext(authnContext);
        authnStatement.setAuthnInstant(assertion.getIssueInstant());
        authnStatement.setSessionIndex(samlSsoRequestContext.getSamlSsoSessionId());
        return authnStatement;
    }

    protected Conditions getSuccessConditions(SamlSsoRequestContext samlSsoRequestContext, DateTime notBeforeDateTime, DateTime notOnOrAfterDateTime) {
        Conditions conditions = OpenSamlUtil.buildConditions();
        conditions.setNotBefore(notBeforeDateTime);
        conditions.setNotOnOrAfter(notOnOrAfterDateTime);
        List<AudienceRestriction> audienceRestrictions = conditions.getAudienceRestrictions();
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        AudienceRestriction audienceRestriction = this.getSuccessAudienceRestriction(samlMessageContext.getPeerEntityId());
        audienceRestrictions.add(audienceRestriction);
        return conditions;
    }

    protected NameID getSuccessNameId(SamlSsoRequestContext samlSsoRequestContext) throws Exception {
        NameIDPolicy nameIDPolicy;
        String nameIdFormat = null;
        String spNameQualifier = null;
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        NameIdResolver nameIdResolver = this._nameIdResolverRegistry.getNameIdResolver(samlMessageContext.getPeerEntityId());
        boolean allowCreate = false;
        AuthnRequest authnRequest = samlMessageContext.getInboundSAMLMessage();
        if (authnRequest != null && (nameIDPolicy = authnRequest.getNameIDPolicy()) != null) {
            nameIdFormat = nameIDPolicy.getFormat();
            spNameQualifier = nameIDPolicy.getSPNameQualifier();
            allowCreate = nameIDPolicy.getAllowCreate();
        }
        if (nameIdFormat == null) {
            nameIdFormat = this.metadataManager.getNameIdFormat(samlMessageContext.getPeerEntityId());
        }
        return OpenSamlUtil.buildNameId(nameIdFormat, null, spNameQualifier, nameIdResolver.resolve(samlSsoRequestContext.getUser(), samlMessageContext.getPeerEntityId(), nameIdFormat, spNameQualifier, allowCreate, new NameIdResolverSAMLContextImpl(samlMessageContext)));
    }

    protected Response getSuccessResponse(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, Assertion assertion) {
        Response response = OpenSamlUtil.buildResponse();
        response.setDestination(assertionConsumerService.getLocation());
        response.setID(this.generateIdentifier(20));
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        if (Validator.isNotNull((String)samlMessageContext.getInboundSAMLMessageId())) {
            response.setInResponseTo(samlMessageContext.getInboundSAMLMessageId());
        }
        response.setIssueInstant(assertion.getIssueInstant());
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        response.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode("urn:oasis:names:tc:SAML:2.0:status:Success");
        Status status = OpenSamlUtil.buildStatus(statusCode);
        response.setStatus(status);
        response.setVersion(SAMLVersion.VERSION_20);
        List<Assertion> assertions = response.getAssertions();
        assertions.add(assertion);
        return response;
    }

    protected Subject getSuccessSubject(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, NameID nameID, SubjectConfirmationData subjectConfirmationData) {
        SubjectConfirmation subjectConfirmation = OpenSamlUtil.buildSubjectConfirmation();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        Subject subject = OpenSamlUtil.buildSubject(nameID);
        List<SubjectConfirmation> subjectConfirmations = subject.getSubjectConfirmations();
        subjectConfirmations.add(subjectConfirmation);
        return subject;
    }

    protected SubjectConfirmationData getSuccessSubjectConfirmationData(SamlSsoRequestContext samlSsoRequestContext, AssertionConsumerService assertionConsumerService, DateTime issueInstantDateTime) {
        SubjectConfirmationData subjectConfirmationData = OpenSamlUtil.buildSubjectConfirmationData();
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        subjectConfirmationData.setInResponseTo(samlMessageContext.getInboundSAMLMessageId());
        subjectConfirmationData.setRecipient(assertionConsumerService.getLocation());
        int assertionLifetime = this.metadataManager.getAssertionLifetime(samlMessageContext.getPeerEntityId());
        DateTime notOnOrAfterDateTime = issueInstantDateTime.plusSeconds(assertionLifetime);
        subjectConfirmationData.setNotOnOrAfter(notOnOrAfterDateTime);
        return subjectConfirmationData;
    }

    protected void redirectToLogin(HttpServletRequest request, HttpServletResponse response, SamlSsoRequestContext samlSsoRequestContext, boolean forceAuthn) {
        HttpSession session = request.getSession();
        if (forceAuthn) {
            this.logout(request, response);
            session = request.getSession(true);
            session.setAttribute("FORCE_REAUTHENTICATION", (Object)Boolean.TRUE);
        }
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        samlSsoRequestContext.setSAMLMessageContext(null);
        session.setAttribute("SAML_SSO_REQUEST_CONTEXT", (Object)samlSsoRequestContext);
        response.addHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        response.addHeader("Pragma", "no-cache");
        StringBundler sb = new StringBundler(3);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/login?redirect=");
        StringBundler redirectSB = new StringBundler(4);
        redirectSB.append(themeDisplay.getPathMain());
        redirectSB.append("/portal/saml/sso");
        if (samlMessageContext.getInboundSAMLMessageId() != null) {
            redirectSB.append("?saml_message_id=");
            redirectSB.append(URLCodec.encodeURL((String)samlMessageContext.getInboundSAMLMessageId()));
        } else if (samlMessageContext.getPeerEntityId() != null) {
            redirectSB.append("?entityId=");
            redirectSB.append(URLCodec.encodeURL((String)samlMessageContext.getPeerEntityId()));
        }
        sb.append(URLCodec.encodeURL((String)redirectSB.toString()));
        String redirect = sb.toString();
        try {
            response.sendRedirect(redirect);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void sendFailureResponse(SamlSsoRequestContext samlSsoRequestContext, String statusURI) throws PortalException {
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        AssertionConsumerService assertionConsumerService = SamlUtil.resolverAssertionConsumerService(samlMessageContext, samlBinding.getCommunicationProfileId());
        samlMessageContext.setPeerEntityEndpoint(assertionConsumerService);
        Credential credential = this.metadataManager.getSigningCredential();
        samlMessageContext.setOutboundSAMLMessageSigningCredential(credential);
        Response response = OpenSamlUtil.buildResponse();
        response.setDestination(assertionConsumerService.getLocation());
        response.setInResponseTo(samlMessageContext.getInboundSAMLMessageId());
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        response.setIssueInstant(issueInstantDateTime);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        response.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusURI);
        Status status = OpenSamlUtil.buildStatus(statusCode);
        response.setStatus(status);
        samlMessageContext.setOutboundSAMLMessage(response);
        this.sendSamlMessage(samlMessageContext);
    }

    protected void sendSuccessResponse(HttpServletRequest request, HttpServletResponse response, SamlSsoRequestContext samlSsoRequestContext) throws Exception {
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        AssertionConsumerService assertionConsumerService = SamlUtil.resolverAssertionConsumerService(samlMessageContext, samlBinding.getCommunicationProfileId());
        NameID nameID = this.getSuccessNameId(samlSsoRequestContext);
        Assertion assertion = this.getSuccessAssertion(samlSsoRequestContext, assertionConsumerService, nameID);
        Credential credential = this.metadataManager.getSigningCredential();
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        if (spSSODescriptor.getWantAssertionsSigned().booleanValue()) {
            OpenSamlUtil.signObject(assertion, credential);
        }
        Response samlResponse = this.getSuccessResponse(samlSsoRequestContext, assertionConsumerService, assertion);
        samlMessageContext.setOutboundSAMLMessage(samlResponse);
        samlMessageContext.setOutboundSAMLMessageSigningCredential(credential);
        samlMessageContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        samlMessageContext.setPeerEntityEndpoint(assertionConsumerService);
        if (samlSsoRequestContext.isNewSession()) {
            this.addSamlSsoSession(request, response, samlSsoRequestContext, nameID);
        } else {
            this.updateSamlSsoSession(request, samlSsoRequestContext, nameID);
        }
        this.sendSamlMessage(samlMessageContext);
    }

    @Reference(unbind="-")
    protected void setAttributeResolverRegistry(AttributeResolverRegistry attributeResolverRegistry) {
        this._attributeResolverRegistry = attributeResolverRegistry;
    }

    @Override
    @Reference(unbind="-")
    protected void setIdentifierGenerator(IdentifierGenerator identifierGenerator) {
        super.setIdentifierGenerator(identifierGenerator);
    }

    @Override
    @Reference(unbind="-")
    protected void setMetadataManager(MetadataManager metadataManager) {
        super.setMetadataManager(metadataManager);
    }

    @Reference(unbind="-")
    protected void setNameIdResolverRegistry(NameIdResolverRegistry nameIdResolverRegistry) {
        this._nameIdResolverRegistry = nameIdResolverRegistry;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this.portal = portal;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetSamlBinding")
    protected void setSamlBinding(SamlBinding samlBinding) {
        this.addSamlBinding(samlBinding);
    }

    @Override
    @Reference(unbind="-")
    protected void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        super.setSamlProviderConfigurationHelper(samlProviderConfigurationHelper);
    }

    @Reference(unbind="-")
    protected void setSamlSpAuthRequestLocalService(SamlSpAuthRequestLocalService samlSpAuthRequestLocalService) {
        this._samlSpAuthRequestLocalService = samlSpAuthRequestLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlSpIdpConnectionLocalService(SamlSpIdpConnectionLocalService samlSpIdpConnectionLocalService) {
        this._samlSpIdpConnectionLocalService = samlSpIdpConnectionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlSpMessageLocalService(SamlSpMessageLocalService samlSpMessageLocalService) {
        this._samlSpMessageLocalService = samlSpMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlSpSessionLocalService(SamlSpSessionLocalService samlSpSessionLocalService) {
        this.samlSpSessionLocalService = samlSpSessionLocalService;
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, unbind="-")
    protected void setUserResolver(UserResolver userResolver) {
        this._userResolver = userResolver;
    }

    @Override
    protected void unsetSamlBinding(SamlBinding samlBinding) {
        this.removeSamlBinding(samlBinding);
    }

    protected void updateSamlSsoSession(HttpServletRequest request, SamlSsoRequestContext samlSsoRequestContext, NameID nameID) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.updateModifiedDate(samlSsoRequestContext.getSamlSsoSessionId());
        SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext = samlSsoRequestContext.getSAMLMessageContext();
        try {
            this._samlIdpSpSessionLocalService.updateModifiedDate(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlMessageContext.getPeerEntityId());
        }
        catch (NoSuchIdpSpSessionException nsisse) {
            this._samlIdpSpSessionLocalService.addSamlIdpSpSession(samlIdpSsoSession.getSamlIdpSsoSessionId(), samlMessageContext.getPeerEntityId(), nameID.getFormat(), nameID.getValue(), serviceContext);
        }
    }

    protected void verifyAssertion(Assertion assertion, SAMLMessageContext<?, ?, NameID> samlMessageContext, TrustEngine<Signature> trustEngine) throws PortalException {
        this.verifyReplay(samlMessageContext, assertion);
        this.verifyIssuer(samlMessageContext, assertion.getIssuer());
        this.verifyAssertionSignature(assertion.getSignature(), samlMessageContext, trustEngine);
        this.verifyConditions(samlMessageContext, assertion.getConditions());
        this.verifySubject(samlMessageContext, assertion.getSubject());
    }

    protected void verifyAssertionSignature(Signature signature, SAMLMessageContext<?, ?, ?> samlMessageContext, TrustEngine<Signature> trustEngine) throws PortalException {
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getLocalEntityRoleMetadata();
        if (signature != null) {
            this.verifySignature(samlMessageContext, signature, trustEngine);
        } else if (spSSODescriptor.getWantAssertionsSigned().booleanValue()) {
            throw new SignatureException("SAML assertion is not signed");
        }
    }

    protected void verifyAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, SAMLMessageContext<?, ?, ?> samlMessageContext) throws PortalException {
        if (audienceRestrictions.isEmpty()) {
            return;
        }
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            for (Audience audience : audienceRestriction.getAudiences()) {
                String audienceURI = audience.getAudienceURI();
                if (!audienceURI.equals(samlMessageContext.getLocalEntityId())) continue;
                return;
            }
        }
        throw new AudienceException("Unable verify audience");
    }

    protected void verifyConditions(SAMLMessageContext<?, ?, ?> samlMessageContext, Conditions conditions) throws PortalException {
        DateTime notOnOrAfterDateTime;
        this.verifyAudienceRestrictions(conditions.getAudienceRestrictions(), samlMessageContext);
        DateTime nowDateTime = new DateTime(DateTimeZone.UTC);
        DateTime notBeforeDateTime = conditions.getNotBefore();
        if (notBeforeDateTime != null) {
            this.verifyNotBeforeDateTime(nowDateTime, this.metadataManager.getClockSkew(), notBeforeDateTime);
        }
        if ((notOnOrAfterDateTime = conditions.getNotOnOrAfter()) != null) {
            this.verifyNotOnOrAfterDateTime(nowDateTime, this.metadataManager.getClockSkew(), notOnOrAfterDateTime);
        }
    }

    protected void verifyDestination(SAMLMessageContext<?, ?, ?> samlMessageContext, String destination) throws PortalException {
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getLocalEntityRoleMetadata();
        List<AssertionConsumerService> assertionConsumerServices = spSSODescriptor.getAssertionConsumerServices();
        for (AssertionConsumerService assertionConsumerService : assertionConsumerServices) {
            String binding = assertionConsumerService.getBinding();
            if (!destination.equals(assertionConsumerService.getLocation()) || !binding.equals(samlMessageContext.getCommunicationProfileId())) continue;
            return;
        }
        throw new DestinationException(StringBundler.concat((String[])new String[]{"Destination ", destination, " does not match any assertion ", "consumer location with binding ", samlMessageContext.getCommunicationProfileId()}));
    }

    protected void verifyInResponseTo(Response samlResponse) throws PortalException {
        String inResponseTo;
        if (Validator.isNull((String)samlResponse.getInResponseTo())) {
            return;
        }
        Issuer issuer = samlResponse.getIssuer();
        String issuerEntityId = issuer.getValue();
        SamlSpAuthRequest samlSpAuthRequest = this._samlSpAuthRequestLocalService.fetchSamlSpAuthRequest(issuerEntityId, inResponseTo = samlResponse.getInResponseTo());
        if (samlSpAuthRequest == null) {
            throw new InResponseToException(StringBundler.concat((String[])new String[]{"Response in response to ", inResponseTo, " does not match any authentication requests"}));
        }
        this._samlSpAuthRequestLocalService.deleteSamlSpAuthRequest(samlSpAuthRequest);
    }

    protected void verifyIssuer(SAMLMessageContext<?, ?, ?> samlMessageContext, Issuer issuer) throws PortalException {
        String issuerFormat = issuer.getFormat();
        if (issuerFormat != null && !issuerFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new IssuerException("Invalid issuer format " + issuerFormat);
        }
        String peerEntityId = samlMessageContext.getPeerEntityId();
        if (!peerEntityId.equals(issuer.getValue())) {
            throw new IssuerException("Issuer does not match expected peer entity ID " + peerEntityId);
        }
    }

    protected void verifyNotBeforeDateTime(DateTime nowDateTime, long clockSkew, DateTime dateTime) throws PortalException {
        DateTime lowerBoundDateTime = dateTime.minus(new Duration(clockSkew));
        if (!nowDateTime.isBefore(lowerBoundDateTime)) {
            return;
        }
        throw new AssertionException(StringBundler.concat((Object[])new Object[]{"Date ", nowDateTime.toString(), " is before ", lowerBoundDateTime.toString(), " including clock skew ", clockSkew}));
    }

    protected void verifyNotOnOrAfterDateTime(DateTime nowDateTime, long clockSkew, DateTime dateTime) throws PortalException {
        DateTime upperBoundDateTime = dateTime.plus(new Duration(clockSkew));
        if (!nowDateTime.isEqual(upperBoundDateTime) && !nowDateTime.isAfter(upperBoundDateTime)) {
            return;
        }
        throw new ExpiredException(StringBundler.concat((Object[])new Object[]{"Date ", nowDateTime.toString(), " is after ", upperBoundDateTime.toString(), " including clock skew ", clockSkew}));
    }

    protected void verifyReplay(SAMLMessageContext<?, ?, ?> samlMessageContext, Assertion assertion) throws PortalException {
        Issuer issuer = assertion.getIssuer();
        String idpEntityId = issuer.getValue();
        String messageKey = assertion.getID();
        DateTime notOnOrAfterDateTime = new DateTime(DateTimeZone.UTC);
        notOnOrAfterDateTime = notOnOrAfterDateTime.plus((long)this._samlConfiguration.getReplayChacheDuration() + this.metadataManager.getClockSkew());
        try {
            SamlSpMessage samlSpMessage = this._samlSpMessageLocalService.fetchSamlSpMessage(idpEntityId, messageKey);
            if (samlSpMessage != null && !samlSpMessage.isExpired()) {
                throw new ReplayException(StringBundler.concat((String[])new String[]{"SAML assertion ", messageKey, " replayed from IdP ", idpEntityId}));
            }
            if (samlSpMessage != null) {
                this._samlSpMessageLocalService.deleteSamlSpMessage(samlSpMessage);
            }
            ServiceContext serviceContext = new ServiceContext();
            long companyId = CompanyThreadLocal.getCompanyId();
            serviceContext.setCompanyId(companyId);
            this._samlSpMessageLocalService.addSamlSpMessage(idpEntityId, messageKey, notOnOrAfterDateTime.toDate(), serviceContext);
        }
        catch (SystemException se) {
            throw new SamlException((Throwable)se);
        }
    }

    protected void verifySignature(SAMLMessageContext<?, ?, ?> samlMessageContext, Signature signature, TrustEngine<Signature> trustEngine) throws PortalException {
        try {
            _samlSignatureProfileValidator.validate(signature);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add(new EntityIDCriteria(samlMessageContext.getPeerEntityId()));
            criteriaSet.add(new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
            criteriaSet.add(new UsageCriteria(UsageType.SIGNING));
            if (!trustEngine.validate(signature, criteriaSet)) {
                throw new SignatureException("Unable validate signature trust");
            }
        }
        catch (Exception e) {
            if (e instanceof PortalException) {
                throw (PortalException)e;
            }
            throw new SignatureException("Unable to verify signature", (Throwable)e);
        }
    }

    protected void verifySubject(SAMLMessageContext<?, ?, NameID> samlMessageContext, Subject subject) throws PortalException {
        List<SubjectConfirmation> subjectConfirmations = subject.getSubjectConfirmations();
        for (SubjectConfirmation subjectConfirmation : subjectConfirmations) {
            DateTime notOnOrAfterDateTime;
            SubjectConfirmationData subjectConfirmationData;
            String method = subjectConfirmation.getMethod();
            if (!method.equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || (subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData()) == null) continue;
            DateTime nowDateTime = new DateTime(DateTimeZone.UTC);
            long clockSkew = this.metadataManager.getClockSkew();
            DateTime notBeforeDateTime = subjectConfirmationData.getNotBefore();
            if (notBeforeDateTime != null) {
                this.verifyNotBeforeDateTime(nowDateTime, clockSkew, notBeforeDateTime);
            }
            if ((notOnOrAfterDateTime = subjectConfirmationData.getNotOnOrAfter()) != null) {
                this.verifyNotOnOrAfterDateTime(nowDateTime, clockSkew, notOnOrAfterDateTime);
            }
            if (Validator.isNull((String)subjectConfirmationData.getRecipient())) continue;
            this.verifyDestination(samlMessageContext, subjectConfirmationData.getRecipient());
            NameID nameID = subject.getNameID();
            samlMessageContext.setSubjectNameIdentifier(nameID);
            return;
        }
        throw new SubjectException("Unable to verify subject");
    }
}

