/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.profile;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.profile.BaseProfile;
import com.liferay.saml.opensaml.integration.internal.profile.ExceptionHandlerUtil;
import com.liferay.saml.opensaml.integration.internal.profile.SamlSloContext;
import com.liferay.saml.opensaml.integration.internal.profile.SamlSloRequestInfo;
import com.liferay.saml.opensaml.integration.internal.transport.HttpClientInTransport;
import com.liferay.saml.opensaml.integration.internal.transport.HttpClientOutTransport;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSsoSessionLocalService;
import com.liferay.saml.persistence.service.SamlSpSessionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.exception.UnsolicitedLogoutResponseException;
import com.liferay.saml.runtime.exception.UnsupportedBindingException;
import com.liferay.saml.runtime.profile.SingleLogoutProfile;
import com.liferay.saml.util.JspUtil;
import com.liferay.saml.util.SamlHttpRequestUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.client.methods.HttpPost;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.security.credential.Credential;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SingleLogoutProfile.class})
public class SingleLogoutProfileImpl
extends BaseProfile
implements SingleLogoutProfile {
    private static final Log _log = LogFactoryUtil.getLog(SingleLogoutProfileImpl.class);
    private SamlHttpRequestUtil _samlHttpRequestUtil;
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    private SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    private SamlIdpSsoSessionLocalService _samlIdpSsoSessionLocalService;
    private UserLocalService _userLocalService;

    public boolean isSingleLogoutSupported(HttpServletRequest request) {
        block3: {
            try {
                String binding;
                MetadataProvider metadataProvider = this.metadataManager.getMetadataProvider();
                String entityId = this.metadataManager.getDefaultIdpEntityId();
                EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(entityId);
                IDPSSODescriptor idpSSODescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                if (singleLogoutService != null && !(binding = singleLogoutService.getBinding()).equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to verify single logout support", (Throwable)e);
            }
        }
        return false;
    }

    public void processIdpLogout(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        String requestPath = this._samlHttpRequestUtil.getRequestPath(request);
        try {
            response.addHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            response.addHeader("Pragma", "no-cache");
            if (requestPath.equals("/c/portal/logout")) {
                this.initiateIdpSingleLogout(request, response);
            } else if (requestPath.equals("/c/portal/saml/slo_logout")) {
                SamlSloContext samlSloContext = this.getSamlSloContext(request, null);
                if (samlSloContext == null) {
                    this.redirectToLogout(request, response);
                    return;
                }
                String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
                if (Validator.isNull((String)cmd)) {
                    request.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext.toJSONObject());
                    JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo.jsp", (String)"single-sign-out");
                } else if (cmd.equals("logout")) {
                    this.performIdpSpLogout(request, response, samlSloContext);
                } else if (cmd.equals("finish")) {
                    this.performIdpFinishLogout(request, response, samlSloContext);
                } else if (cmd.equals("status")) {
                    this.performIdpStatus(request, response, samlSloContext);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandlerUtil.handleException(e);
        }
    }

    public void processSingleLogout(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        block10: {
            SamlBinding samlBinding = null;
            String method = request.getMethod();
            String requestPath = this._samlHttpRequestUtil.getRequestPath(request);
            if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"GET")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            } else if (requestPath.endsWith("/slo_soap") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            } else {
                throw new UnsupportedBindingException();
            }
            try {
                SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext = this.decodeSamlMessage(request, response, samlBinding, true);
                Object inboundSamlMessage = samlMessageContext.getInboundSAMLMessage();
                if (inboundSamlMessage instanceof LogoutRequest) {
                    this.processSingleLogoutRequest(request, response, samlMessageContext);
                    break block10;
                }
                if (inboundSamlMessage instanceof LogoutResponse) {
                    this.processSingleLogoutResponse(request, response, samlMessageContext);
                    break block10;
                }
                throw new SamlException("Unrecognized inbound SAML message " + inboundSamlMessage.getClass());
            }
            catch (Exception e) {
                ExceptionHandlerUtil.handleException(e);
            }
        }
    }

    public void processSpLogout(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        try {
            this.sendSpLogoutRequest(request, response);
        }
        catch (Exception e) {
            ExceptionHandlerUtil.handleException(e);
        }
    }

    @Override
    @Reference(unbind="-")
    public void setIdentifierGenerator(IdentifierGenerator identifierGenerator) {
        super.setIdentifierGenerator(identifierGenerator);
    }

    @Override
    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        super.setMetadataManager(metadataManager);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetSamlBinding")
    public void setSamlBinding(SamlBinding samlBinding) {
        this.addSamlBinding(samlBinding);
    }

    @Override
    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        super.setSamlProviderConfigurationHelper(samlProviderConfigurationHelper);
    }

    public void terminateSpSession(HttpServletRequest request, HttpServletResponse response) {
        try {
            SamlSpSession samlSpSession = this.getSamlSpSession(request);
            if (samlSpSession == null) {
                return;
            }
            this.samlSpSessionLocalService.deleteSamlSpSession(samlSpSession);
            this.addCookie(request, response, "SAML_SP_SESSION_KEY", "", 0);
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
        }
    }

    public void terminateSsoSession(HttpServletRequest request, HttpServletResponse response) {
        String samlSsoSessionId = this.getSamlSsoSessionId(request);
        if (Validator.isNotNull((String)samlSsoSessionId)) {
            try {
                SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId);
                if (samlIdpSsoSession != null) {
                    this._samlIdpSsoSessionLocalService.deleteSamlIdpSsoSession(samlIdpSsoSession);
                    List samlIdpSpSessions = this._samlIdpSpSessionLocalService.getSamlIdpSpSessions(samlIdpSsoSession.getSamlIdpSsoSessionId());
                    for (SamlIdpSpSession samlIdpSpSession : samlIdpSpSessions) {
                        this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSession);
                    }
                }
            }
            catch (SystemException se) {
                _log.error((Object)se, (Throwable)se);
            }
        }
        this.addCookie(request, response, "SAML_SSO_SESSION_ID", "", 0);
    }

    protected void addSessionIndex(LogoutRequest logoutRequest, String sessionIndexString) {
        if (Validator.isNull((String)sessionIndexString)) {
            return;
        }
        List<SessionIndex> sessionIndexes = logoutRequest.getSessionIndexes();
        SessionIndex sessionIndex = OpenSamlUtil.buildSessionIndex(sessionIndexString);
        sessionIndexes.add(sessionIndex);
    }

    protected SamlSloContext getSamlSloContext(HttpServletRequest request, SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext) throws Exception {
        SamlIdpSsoSession samlIdpSsoSession;
        LogoutRequest logoutRequest;
        List<SessionIndex> sessionIndexes;
        HttpSession session = request.getSession();
        SamlSloContext samlSloContext = (SamlSloContext)session.getAttribute("SAML_SLO_CONTEXT");
        String samlSsoSessionId = this.getSamlSsoSessionId(request);
        if (samlMessageContext != null && !(sessionIndexes = (logoutRequest = samlMessageContext.getInboundSAMLMessage()).getSessionIndexes()).isEmpty()) {
            SessionIndex sessionIndex = sessionIndexes.get(0);
            samlSsoSessionId = sessionIndex.getSessionIndex();
        }
        if (samlSloContext == null && Validator.isNotNull((String)samlSsoSessionId) && (samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId)) != null) {
            samlSloContext = new SamlSloContext(samlIdpSsoSession, samlMessageContext, this._samlIdpSpConnectionLocalService, this._samlIdpSpSessionLocalService, this._userLocalService);
            samlSloContext.setSamlSsoSessionId(samlSsoSessionId);
            samlSloContext.setUserId(this.portal.getUserId(request));
            session.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext);
        }
        return samlSloContext;
    }

    protected void initiateIdpSingleLogout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(request, null);
        if (samlSloContext != null) {
            String portalURL = this.portal.getPortalURL(request);
            String pathMain = this.portal.getPathMain();
            String redirect = portalURL.concat(pathMain).concat("/portal/saml/slo_logout");
            response.sendRedirect(redirect);
        } else {
            this.redirectToLogout(request, response);
        }
    }

    protected void performIdpFinishLogout(HttpServletRequest request, HttpServletResponse response, SamlSloContext samlSloContext) throws Exception {
        if (samlSloContext.getSamlMessageContext() != null) {
            String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
            for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
                String samlRequestInfoStatusCode = samlRequestInfo.getStatusCode();
                if (samlRequestInfoStatusCode.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) continue;
                statusCode = "urn:oasis:names:tc:SAML:2.0:status:PartialLogout";
                break;
            }
            this.sendIdpLogoutResponse(request, response, statusCode, samlSloContext);
        } else {
            this.redirectToLogout(request, response);
        }
    }

    protected void performIdpSpLogout(HttpServletRequest request, HttpServletResponse response, SamlSloContext samlSloContext) throws Exception {
        String entityId = ParamUtil.getString((HttpServletRequest)request, (String)"entityId");
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Received logout request for service provider " + entityId + " that the user is not logged into"));
            }
            JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/error.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        if (samlSloRequestInfo.getStatus() == 2) {
            request.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        SAMLMessageContext<?, ?, ?> samlMessageContext = this.getSamlMessageContext(request, response, entityId);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (singleLogoutService == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Single logout not supported by " + entityId));
            }
            samlSloRequestInfo.setStatus(4);
            samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding");
            request.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            try {
                this.sendIdpLogoutRequest(request, response, samlSloContext, samlSloRequestInfo);
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(7);
                    sb.append("Unable to perform a single logout for service ");
                    sb.append("provider ");
                    sb.append(entityId);
                    sb.append(" with binding ");
                    sb.append(singleLogoutService.getBinding());
                    sb.append(" to ");
                    sb.append(singleLogoutService.getLocation());
                    _log.debug((Object)sb.toString(), (Throwable)e);
                }
                samlSloRequestInfo.setStatus(3);
                samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
                request.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
                JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            }
        }
    }

    protected void performIdpStatus(HttpServletRequest request, HttpServletResponse response, SamlSloContext samlSloContext) throws Exception {
        for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
            DateTime initiateDateTime;
            DateTime expireDateTime;
            int status = samlRequestInfo.getStatus();
            if (status != 1 || !(expireDateTime = (initiateDateTime = samlRequestInfo.getInitiateTime()).plusSeconds(10)).isBeforeNow()) continue;
            samlRequestInfo.setStatus(5);
            samlRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
        }
        response.setContentType("text/javascript");
        PrintWriter writer = response.getWriter();
        JSONObject jsonObject = samlSloContext.toJSONObject();
        ((Writer)writer).write(jsonObject.toString());
    }

    protected void processIdpLogoutRequest(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(request, samlMessageContext);
        Set<String> samlSpEntityIds = samlSloContext.getSamlSpEntityIds();
        String binding = samlMessageContext.getCommunicationProfileId();
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            this.sendIdpLogoutResponse(request, response, "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", samlSloContext);
        } else if (samlSloContext == null) {
            this.sendIdpLogoutResponse(request, response, "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", new SamlSloContext(null, samlMessageContext, this._samlIdpSpConnectionLocalService, this._samlIdpSpSessionLocalService, this._userLocalService));
        } else if (!samlSpEntityIds.isEmpty()) {
            this.initiateIdpSingleLogout(request, response);
        } else {
            this.sendIdpLogoutResponse(request, response, "urn:oasis:names:tc:SAML:2.0:status:Success", samlSloContext);
        }
    }

    protected void processIdpLogoutResponse(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutResponse, ?, ?> samlMessageContext) throws Exception {
        SamlSloContext samlSloContext = this.getSamlSloContext(request, null);
        if (samlSloContext == null) {
            throw new UnsolicitedLogoutResponseException("Received logout response from " + samlMessageContext.getPeerEntityId() + " without an active SSO session");
        }
        String entityId = samlMessageContext.getInboundMessageIssuer();
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            throw new UnsolicitedLogoutResponseException("Received unsolicited logout response from " + samlMessageContext.getPeerEntityId());
        }
        LogoutResponse logoutResponse = samlMessageContext.getInboundSAMLMessage();
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        samlSloRequestInfo.setStatusCode(statusCode.getValue());
        request.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
        JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
    }

    protected void processSingleLogoutRequest(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.processIdpLogoutRequest(request, response, samlMessageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.processSpLogoutRequest(request, response, samlMessageContext);
        }
    }

    protected void processSingleLogoutResponse(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutResponse, ?, ?> samlMessageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.processIdpLogoutResponse(request, response, samlMessageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.processSpLogoutResponse(request, response, samlMessageContext);
        }
    }

    protected void processSpLogoutRequest(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext) throws Exception {
        SamlSpSession samlSpSession;
        LogoutRequest logoutRequest = samlMessageContext.getInboundSAMLMessage();
        NameID nameID = logoutRequest.getNameID();
        List<SessionIndex> sessionIndexes = logoutRequest.getSessionIndexes();
        String statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:Success";
        if (sessionIndexes.isEmpty()) {
            List samlSpSessions = this.samlSpSessionLocalService.getSamlSpSessions(nameID.getValue());
            if (samlSpSessions.isEmpty()) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
            }
            Iterator iterator = samlSpSessions.iterator();
            while (iterator.hasNext()) {
                samlSpSession = (SamlSpSession)iterator.next();
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            }
        }
        for (SessionIndex sessionIndex : sessionIndexes) {
            samlSpSession = this.samlSpSessionLocalService.fetchSamlSpSessionBySessionIndex(sessionIndex.getSessionIndex());
            if (samlSpSession == null) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
                continue;
            }
            if (Objects.equals(samlSpSession.getNameIdValue(), nameID.getValue()) && Objects.equals(samlSpSession.getNameIdFormat(), nameID.getFormat())) {
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            } else if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:PartialLogout")) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
                continue;
            }
            if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal")) continue;
            statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:PartialLogout";
        }
        samlMessageContext.setOutboundSAMLMessageSigningCredential(this.metadataManager.getSigningCredential());
        LogoutResponse logoutResponse = OpenSamlUtil.buildLogoutResponse();
        samlMessageContext.setOutboundSAMLMessage(logoutResponse);
        logoutResponse.setID(this.generateIdentifier(20));
        logoutResponse.setInResponseTo(logoutRequest.getID());
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        logoutResponse.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusCodeURI);
        Status status = OpenSamlUtil.buildStatus(statusCode);
        logoutResponse.setStatus(status);
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        SSODescriptor ssoDescriptor = (SSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(ssoDescriptor, samlMessageContext.getCommunicationProfileId());
        samlMessageContext.setPeerEntityEndpoint(singleLogoutService);
        this.sendSamlMessage(samlMessageContext);
    }

    protected void processSpLogoutResponse(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<LogoutResponse, ?, ?> samlMessageContext) throws Exception {
        this.redirectToLogout(request, response);
    }

    protected void redirectToLogout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this.terminateSsoSession(request, response);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this.terminateSpSession(request, response);
        }
        String portalURL = this.portal.getPortalURL(request);
        String pathMain = this.portal.getPathMain();
        String redirect = portalURL.concat(pathMain).concat("/portal/logout");
        response.sendRedirect(redirect);
    }

    protected void sendAsyncLogoutRequest(SAMLMessageContext<LogoutResponse, LogoutRequest, NameID> samlMessageContext, SamlSloContext samlSloContext) throws Exception {
        SingleLogoutService singleLogoutService = (SingleLogoutService)samlMessageContext.getPeerEntityEndpoint();
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        logoutRequest.setIssuer(issuer);
        logoutRequest.setNameID(samlMessageContext.getSubjectNameIdentifier());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSloContext.getSamlSsoSessionId());
        samlMessageContext.setOutboundSAMLMessage(logoutRequest);
        Credential credential = this.metadataManager.getSigningCredential();
        samlMessageContext.setOutboundSAMLMessageSigningCredential(credential);
        samlMessageContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        OpenSamlUtil.signObject(logoutRequest, credential);
        SamlBinding samlBinding = this.getSamlBinding(singleLogoutService.getBinding());
        MessageEncoder messageEncoder = samlBinding.getMessageEncoder();
        messageEncoder.encode(samlMessageContext);
    }

    protected void sendIdpLogoutRequest(HttpServletRequest request, HttpServletResponse response, SamlSloContext samlSloContext, SamlSloRequestInfo samlSloRequestInfo) throws Exception {
        SAMLMessageContext<LogoutResponse, LogoutRequest, NameID> samlMessageContext = this.getSamlMessageContext(request, response, samlSloRequestInfo.getEntityId());
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlMessageContext.setPeerEntityEndpoint(singleLogoutService);
        SamlIdpSpSession samlIdpSpSession = samlSloRequestInfo.getSamlIdpSpSession();
        NameID nameID = OpenSamlUtil.buildNameId(samlIdpSpSession.getNameIdFormat(), samlIdpSpSession.getNameIdValue());
        samlMessageContext.setSubjectNameIdentifier(nameID);
        samlSloRequestInfo.setInitiateTime(new DateTime(DateTimeZone.UTC));
        samlSloRequestInfo.setStatus(1);
        String binding = singleLogoutService.getBinding();
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            String statusCode = this.sendSyncLogoutRequest(samlMessageContext, samlSloContext);
            samlSloRequestInfo.setStatusCode(statusCode);
            request.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)request, (HttpServletResponse)response, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            this.sendAsyncLogoutRequest(samlMessageContext, samlSloContext);
        }
    }

    protected void sendIdpLogoutResponse(HttpServletRequest request, HttpServletResponse response, String statusCodeURI, SamlSloContext samlSloContext) throws Exception {
        SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext = samlSloContext.getSamlMessageContext();
        LogoutResponse logoutResponse = OpenSamlUtil.buildLogoutResponse();
        SSODescriptor ssoDescriptor = (SSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(ssoDescriptor, samlMessageContext.getCommunicationProfileId());
        logoutResponse.setDestination(singleLogoutService.getLocation());
        logoutResponse.setID(this.generateIdentifier(20));
        LogoutRequest logoutRequest = samlMessageContext.getInboundSAMLMessage();
        logoutResponse.setInResponseTo(logoutRequest.getID());
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        logoutResponse.setIssuer(issuer);
        StatusCode statusCode = OpenSamlUtil.buildStatusCode(statusCodeURI);
        Status status = OpenSamlUtil.buildStatus(statusCode);
        logoutResponse.setStatus(status);
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        HttpServletRequestAdapter httpServletRequestAdapter = new HttpServletRequestAdapter(request);
        samlMessageContext.setInboundMessageTransport(httpServletRequestAdapter);
        HttpServletResponseAdapter httpServletResponseAdapter = new HttpServletResponseAdapter(response, request.isSecure());
        samlMessageContext.setOutboundMessageTransport(httpServletResponseAdapter);
        samlMessageContext.setOutboundSAMLMessage(logoutResponse);
        samlMessageContext.setOutboundSAMLMessageSigningCredential(this.metadataManager.getSigningCredential());
        samlMessageContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        samlMessageContext.setPeerEntityEndpoint(singleLogoutService);
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding")) {
            this.terminateSsoSession(request, response);
            this.logout(request, response);
        }
        this.sendSamlMessage(samlMessageContext);
    }

    protected void sendSpLogoutRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SamlSpSession samlSpSession = this.getSamlSpSession(request);
        if (samlSpSession == null || samlSpSession.isTerminated()) {
            this.redirectToLogout(request, response);
            return;
        }
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        String entityId = this.metadataManager.getDefaultIdpEntityId();
        SAMLMessageContext<?, ?, ?> samlMessageContext = this.getSamlMessageContext(request, response, entityId);
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlMessageContext.getPeerEntityRoleMetadata();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        DateTime issueInstantDateTime = new DateTime(DateTimeZone.UTC);
        logoutRequest.setIssueInstant(issueInstantDateTime);
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        logoutRequest.setIssuer(issuer);
        String nameIdFormat = samlSpSession.getNameIdFormat();
        String nameIdNameQualifier = samlSpSession.getNameIdNameQualifier();
        String nameIdSPNameQualifier = samlSpSession.getNameIdSPNameQualifier();
        String nameIdValue = samlSpSession.getNameIdValue();
        NameID nameID = OpenSamlUtil.buildNameId(nameIdFormat, nameIdNameQualifier, nameIdSPNameQualifier, nameIdValue);
        logoutRequest.setNameID(nameID);
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSpSession.getSessionIndex());
        samlMessageContext.setOutboundSAMLMessage(logoutRequest);
        samlMessageContext.setOutboundSAMLMessageSigningCredential(this.metadataManager.getSigningCredential());
        samlMessageContext.setPeerEntityEndpoint(singleLogoutService);
        this.sendSamlMessage(samlMessageContext);
    }

    protected String sendSyncLogoutRequest(SAMLMessageContext<LogoutResponse, LogoutRequest, NameID> samlMessageContext, SamlSloContext samlSloContext) throws Exception {
        SingleLogoutService singleLogoutService = (SingleLogoutService)samlMessageContext.getPeerEntityEndpoint();
        HttpPost httpPost = new HttpPost(singleLogoutService.getLocation());
        HttpClientInTransport httpClientInTransport = new HttpClientInTransport(httpPost, singleLogoutService.getLocation());
        samlMessageContext.setInboundMessageTransport(httpClientInTransport);
        HttpClientOutTransport httpClientOutTransport = new HttpClientOutTransport(httpPost);
        samlMessageContext.setOutboundMessageTransport(httpClientOutTransport);
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(singleLogoutService.getLocation());
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        Issuer issuer = OpenSamlUtil.buildIssuer(samlMessageContext.getLocalEntityId());
        logoutRequest.setIssuer(issuer);
        logoutRequest.setNameID(samlMessageContext.getSubjectNameIdentifier());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this.addSessionIndex(logoutRequest, samlSloContext.getSamlSsoSessionId());
        samlMessageContext.setOutboundSAMLMessage(logoutRequest);
        Credential credential = this.metadataManager.getSigningCredential();
        samlMessageContext.setOutboundSAMLMessageSigningCredential(credential);
        samlMessageContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        OpenSamlUtil.signObject(logoutRequest, credential);
        SamlBinding samlBinding = this.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        MessageEncoder messageEncoder = samlBinding.getMessageEncoder();
        messageEncoder.encode(samlMessageContext);
        SecurityPolicyResolver securityPolicyResolver = this.metadataManager.getSecurityPolicyResolver(samlBinding.getCommunicationProfileId(), true);
        samlMessageContext.setSecurityPolicyResolver(securityPolicyResolver);
        MessageDecoder messageDecoder = samlBinding.getMessageDecoder();
        messageDecoder.decode(samlMessageContext);
        LogoutResponse logoutResponse = samlMessageContext.getInboundSAMLMessage();
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        return statusCode.getValue();
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this.portal = portal;
    }

    @Reference(unbind="-")
    protected void setSamlHttpRequestUtil(SamlHttpRequestUtil samlHttpRequestUtil) {
        this._samlHttpRequestUtil = samlHttpRequestUtil;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSpConnectionLocalService(SamlIdpSpConnectionLocalService samlIdpSpConnectionLocalService) {
        this._samlIdpSpConnectionLocalService = samlIdpSpConnectionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSpSessionLocalService(SamlIdpSpSessionLocalService samlIdpSpSessionLocalService) {
        this._samlIdpSpSessionLocalService = samlIdpSpSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlIdpSsoSessionLocalService(SamlIdpSsoSessionLocalService samlIdpSsoSessionLocalService) {
        this._samlIdpSsoSessionLocalService = samlIdpSsoSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setSamlSpSessionLocalService(SamlSpSessionLocalService samlSpSessionLocalService) {
        this.samlSpSessionLocalService = samlSpSessionLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

