/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.SigningUtil;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.KeyAlgorithmCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.trust.ExplicitKeyTrustEvaluator;
import org.opensaml.xml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.BaseSignatureTrustEngine;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitKeySignatureTrustEngine
extends BaseSignatureTrustEngine<Iterable<Credential>>
implements TrustedCredentialTrustEngine<Signature> {
    private final Logger log = LoggerFactory.getLogger(ExplicitKeySignatureTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitKeyTrustEvaluator keyTrust;

    public ExplicitKeySignatureTrustEngine(CredentialResolver resolver2, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver2 == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver2;
        this.keyTrust = new ExplicitKeyTrustEvaluator();
    }

    @Override
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        String jcaAlgorithm;
        this.checkParams(signature, trustBasisCriteria);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll(trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriteria.class)) {
            criteriaSet.add(new UsageCriteria(UsageType.SIGNING));
        }
        if (!DatatypeHelper.isEmpty(jcaAlgorithm = SecurityHelper.getKeyAlgorithmFromURI(signature.getSignatureAlgorithm()))) {
            criteriaSet.add(new KeyAlgorithmCriteria(jcaAlgorithm), true);
        }
        if (this.validate(signature, trustedCredentials = this.getCredentialResolver().resolve(criteriaSet))) {
            return true;
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            if (!this.verifySignature(signature, trustedCredential)) continue;
            this.log.debug("Successfully verified signature using resolved trusted credential");
            return true;
        }
        this.log.debug("Failed to verify signature using either KeyInfo-derived or directly trusted credentials");
        return false;
    }

    @Override
    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        String jcaAlgorithm;
        this.checkParamsRaw(signature, content, algorithmURI, trustBasisCriteria);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll(trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriteria.class)) {
            criteriaSet.add(new UsageCriteria(UsageType.SIGNING));
        }
        if (!DatatypeHelper.isEmpty(jcaAlgorithm = SecurityHelper.getKeyAlgorithmFromURI(algorithmURI))) {
            criteriaSet.add(new KeyAlgorithmCriteria(jcaAlgorithm), true);
        }
        Iterable<Credential> trustedCredentials = this.getCredentialResolver().resolve(criteriaSet);
        if (candidateCredential != null) {
            try {
                if (SigningUtil.verifyWithURI(candidateCredential, algorithmURI, signature, content)) {
                    this.log.debug("Successfully verified signature using supplied candidate credential");
                    this.log.debug("Attempting to establish trust of supplied candidate credential");
                    if (this.evaluateTrust(candidateCredential, trustedCredentials)) {
                        this.log.debug("Successfully established trust of supplied candidate credential");
                        return true;
                    }
                    this.log.debug("Failed to establish trust of supplied candidate credential");
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            try {
                if (!SigningUtil.verifyWithURI(trustedCredential, algorithmURI, signature, content)) continue;
                this.log.debug("Successfully verified signature using resolved trusted credential");
                return true;
            }
            catch (SecurityException e) {
            }
        }
        this.log.debug("Failed to verify signature using either supplied candidate credential or directly trusted credentials");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Iterable<Credential> trustedCredentials) throws SecurityException {
        return this.keyTrust.validate(untrustedCredential, trustedCredentials);
    }
}

