/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRedirectDeflateDecoder
extends BaseSAML2MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateDecoder.class);

    public HTTPRedirectDeflateDecoder() {
    }

    public HTTPRedirectDeflateDecoder(ParserPool pool) {
        super(pool);
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Override
    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return this.isMessageSigned(samlMsgCtx);
    }

    @Override
    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        InputStream samlMessageIns;
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        String relayState = inTransport.getParameterValue("RelayState");
        samlMsgCtx.setRelayState(relayState);
        this.log.debug("Decoded RelayState: {}", (Object)relayState);
        if (!DatatypeHelper.isEmpty(inTransport.getParameterValue("SAMLRequest"))) {
            samlMessageIns = this.decodeMessage(inTransport.getParameterValue("SAMLRequest"));
        } else if (!DatatypeHelper.isEmpty(inTransport.getParameterValue("SAMLResponse"))) {
            samlMessageIns = this.decodeMessage(inTransport.getParameterValue("SAMLResponse"));
        } else {
            throw new MessageDecodingException("No SAMLRequest or SAMLResponse query path parameter, invalid SAML 2 HTTP Redirect message");
        }
        SAMLObject samlMessage = (SAMLObject)this.unmarshallMessage(samlMessageIns);
        samlMsgCtx.setInboundSAMLMessage(samlMessage);
        samlMsgCtx.setInboundMessage(samlMessage);
        this.log.debug("Decoded SAML message");
        this.populateMessageContext(samlMsgCtx);
    }

    @Override
    protected boolean isMessageSigned(SAMLMessageContext messageContext) {
        HTTPInTransport inTransport = (HTTPInTransport)messageContext.getInboundMessageTransport();
        String sigParam = inTransport.getParameterValue("Signature");
        return !DatatypeHelper.isEmpty(sigParam) || super.isMessageSigned(messageContext);
    }

    protected InputStream decodeMessage(String message) throws MessageDecodingException {
        this.log.debug("Base64 decoding and inflating SAML message");
        byte[] decodedBytes = Base64.decode(message);
        if (decodedBytes == null) {
            this.log.error("Unable to Base64 decode incoming message");
            throw new MessageDecodingException("Unable to Base64 decode incoming message");
        }
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(decodedBytes);
            InflaterInputStream inflater = new InflaterInputStream(bytesIn, new Inflater(true));
            return inflater;
        }
        catch (Exception e) {
            this.log.error("Unable to Base64 decode and inflate SAML message", (Throwable)e);
            throw new MessageDecodingException("Unable to Base64 decode and inflate SAML message", e);
        }
    }
}

