/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.joda.time.DateTime;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={UserResolver.class})
public class DefaultUserResolver
implements UserResolver {
    private static final String _SUBJECT_NAME_TYPE_EMAIL_ADDRESS = "emailAddress";
    private static final String _SUBJECT_NAME_TYPE_SCREENNAME = "screenName";
    private static final String _SUBJECT_NAME_TYPE_UNSPECIFIED = "unspecified";
    private static final String _SUBJECT_NAME_TYPE_UUID = "uuid";
    private static final Log _log = LogFactoryUtil.getLog(DefaultUserResolver.class);
    private MetadataManager _metadataManager;
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    private UserImporter _userImporter;
    private UserLocalService _userLocalService;

    @Override
    public User resolveUser(UserResolver.UserResolverSAMLContext userResolverSAMLContext, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled()) {
            String subjectNameIdentifier = userResolverSAMLContext.resolveSubjectNameIdentifier();
            String subjectNameFormat = userResolverSAMLContext.resolveSubjectNameFormat();
            _log.debug((Object)("Resolving user with name ID format " + subjectNameFormat + " and value " + subjectNameIdentifier));
        }
        User user = null;
        long companyId = CompanyThreadLocal.getCompanyId();
        String subjectNameIdentifier = this.getSubjectNameIdentifier(userResolverSAMLContext);
        String subjectNameIdentifierType = this.getSubjectNameIdentifierType(userResolverSAMLContext);
        if (this._samlProviderConfigurationHelper.isLDAPImportEnabled()) {
            user = this.importLdapUser(companyId, subjectNameIdentifier, subjectNameIdentifierType);
        }
        if (user == null) {
            return this.importUser(companyId, subjectNameIdentifier, subjectNameIdentifierType, userResolverSAMLContext, serviceContext);
        }
        return user;
    }

    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        this._metadataManager = metadataManager;
    }

    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this._samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    @Reference(unbind="-")
    public void setUserImporter(UserImporter userImporter) {
        this._userImporter = userImporter;
    }

    @Reference(unbind="-")
    public void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected User addUser(long companyId, Map<String, List<Serializable>> attributesMap, ServiceContext serviceContext) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user with attributes map " + MapUtil.toString(attributesMap)));
        }
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String screenName = this.getValueAsString(_SUBJECT_NAME_TYPE_SCREENNAME, attributesMap);
        String emailAddress = this.getValueAsString(_SUBJECT_NAME_TYPE_EMAIL_ADDRESS, attributesMap);
        long facebookId = 0L;
        String openId = "";
        Locale locale = serviceContext.getLocale();
        String firstName = this.getValueAsString("firstName", attributesMap);
        String middleName = "";
        String lastName = this.getValueAsString("lastName", attributesMap);
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        String uuid = this.getValueAsString(_SUBJECT_NAME_TYPE_UUID, attributesMap);
        serviceContext.setUuid(uuid);
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, (long)prefixId, (long)suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        user = this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        Date modifiedDate = this.getValueAsDate("modifiedDate", attributesMap);
        if (modifiedDate != null) {
            user = this._userLocalService.updateModifiedDate(user.getUserId(), modifiedDate);
        }
        return user;
    }

    protected Map<String, List<Serializable>> getAttributesMap(UserResolver.UserResolverSAMLContext userResolverSAMLContext) {
        String peerEntityId = userResolverSAMLContext.resolvePeerEntityId();
        try {
            String userAttributeMappings = this._metadataManager.getUserAttributeMappings(peerEntityId);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Attributes mapping for " + peerEntityId + " " + userAttributeMappings));
            }
            Properties userAttributeMappingsProperties = new Properties();
            if (Validator.isNotNull((String)userAttributeMappings)) {
                userAttributeMappingsProperties = PropertiesUtil.load((String)userAttributeMappings);
            }
            return userResolverSAMLContext.resolveBearerAssertionAttributesWithMapping(userAttributeMappingsProperties);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return Collections.emptyMap();
        }
    }

    protected String getSubjectNameIdentifier(UserResolver.UserResolverSAMLContext userResolverSAMLContext) {
        return userResolverSAMLContext.resolveSubjectNameIdentifier();
    }

    protected String getSubjectNameIdentifierType(UserResolver.UserResolverSAMLContext userResolverSAMLContext) {
        String format = userResolverSAMLContext.resolveSubjectNameFormat();
        if (Validator.isNull((String)format)) {
            return _SUBJECT_NAME_TYPE_UNSPECIFIED;
        }
        if (format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")) {
            return _SUBJECT_NAME_TYPE_EMAIL_ADDRESS;
        }
        return _SUBJECT_NAME_TYPE_SCREENNAME;
    }

    protected User getUser(long companyId, String subjectNameIdentifier, String subjectNameIdentifierType) throws PortalException {
        block5: {
            try {
                if (subjectNameIdentifierType.endsWith(_SUBJECT_NAME_TYPE_EMAIL_ADDRESS)) {
                    return this._userLocalService.getUserByEmailAddress(companyId, subjectNameIdentifier);
                }
                if (subjectNameIdentifierType.endsWith(_SUBJECT_NAME_TYPE_SCREENNAME)) {
                    return this._userLocalService.getUserByScreenName(companyId, subjectNameIdentifier);
                }
                if (subjectNameIdentifierType.endsWith(_SUBJECT_NAME_TYPE_UUID)) {
                    return this._userLocalService.getUserByUuidAndCompanyId(subjectNameIdentifier, companyId);
                }
            }
            catch (NoSuchUserException nsue) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)nsue, (Throwable)nsue);
            }
        }
        return null;
    }

    protected Date getValueAsDate(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        DateTime dateTime = new DateTime(values.get(0));
        return dateTime.toDate();
    }

    protected String getValueAsString(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        return String.valueOf(values.get(0));
    }

    protected User importLdapUser(long companyId, String subjectNameIdentifier, String subjectNameIdentifierType) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing user from LDAP with identifier " + subjectNameIdentifier + " of type " + subjectNameIdentifierType));
        }
        User user = null;
        user = subjectNameIdentifierType.endsWith(_SUBJECT_NAME_TYPE_EMAIL_ADDRESS) ? this._userImporter.importUser(companyId, subjectNameIdentifier, "") : this._userImporter.importUser(companyId, "", subjectNameIdentifier);
        return user;
    }

    protected User importUser(long companyId, String subjectNameIdentifier, String subjectNameIdentifierType, UserResolver.UserResolverSAMLContext userResolverSAMLContext, ServiceContext serviceContext) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing user with identifier " + subjectNameIdentifier + " of type " + subjectNameIdentifierType));
        }
        Map<String, List<Serializable>> attributesMap = this.getAttributesMap(userResolverSAMLContext);
        User user = this.getUser(companyId, subjectNameIdentifier, subjectNameIdentifierType);
        if (user != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found user " + user.toString()));
            }
            user = this.updateUser(companyId, user, attributesMap, serviceContext);
        } else {
            user = this.addUser(companyId, attributesMap, serviceContext);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added user " + user.toString()));
            }
        }
        return user;
    }

    protected User updateUser(long companyId, User user, Map<String, List<Serializable>> attributesMap, ServiceContext serviceContext) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating user " + user.getUserId() + " with attributes map " + MapUtil.toString(attributesMap)));
        }
        Date modifiedDate = null;
        String screenName = null;
        String emailAddress = null;
        String firstName = null;
        String lastName = null;
        modifiedDate = this.getValueAsDate("modifiedDate", attributesMap) != null ? this.getValueAsDate("modifiedDate", attributesMap) : user.getModifiedDate();
        screenName = Validator.isNotNull((String)this.getValueAsString(_SUBJECT_NAME_TYPE_SCREENNAME, attributesMap)) ? this.getValueAsString(_SUBJECT_NAME_TYPE_SCREENNAME, attributesMap) : user.getScreenName();
        emailAddress = Validator.isNotNull((String)this.getValueAsString(_SUBJECT_NAME_TYPE_EMAIL_ADDRESS, attributesMap)) ? this.getValueAsString(_SUBJECT_NAME_TYPE_EMAIL_ADDRESS, attributesMap) : user.getEmailAddress();
        firstName = Validator.isNotNull((String)this.getValueAsString("firstName", attributesMap)) ? this.getValueAsString("firstName", attributesMap) : user.getFirstName();
        lastName = Validator.isNotNull((String)this.getValueAsString("lastName", attributesMap)) ? this.getValueAsString("lastName", attributesMap) : user.getLastName();
        Contact contact = user.getContact();
        if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            user = this._userLocalService.updateEmailAddress(user.getUserId(), "", emailAddress, emailAddress);
            user = this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        }
        if (!(Objects.equals(user.getFirstName(), firstName) && Objects.equals(user.getLastName(), lastName) && Objects.equals(user.getScreenName(), screenName) && Objects.equals(user.getModifiedDate(), modifiedDate))) {
            Date oldModifiedDate = user.getModifiedDate();
            Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar();
            birthdayCalendar.setTime(contact.getBirthday());
            user = this._userLocalService.updateUser(user.getUserId(), "", "", "", false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), screenName, emailAddress, user.getFacebookId(), user.getOpenId(), false, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), firstName, user.getMiddleName(), lastName, contact.getPrefixId(), contact.getSuffixId(), user.getMale(), birthdayCalendar.get(2), birthdayCalendar.get(5), birthdayCalendar.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), contact.getJobTitle(), null, null, null, null, null, serviceContext);
            if (!Objects.equals(oldModifiedDate, modifiedDate)) {
                user = this._userLocalService.updateModifiedDate(user.getUserId(), modifiedDate);
            }
        }
        return user;
    }
}

