/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoResolutionContext;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyInfoReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInfoReferenceProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(KeyInfoReferenceProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getKeyInfoReference(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver2, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        KeyInfoReference ref = this.getKeyInfoReference(keyInfoChild);
        if (ref == null) {
            return null;
        }
        this.log.debug("Attempting to follow same-document KeyInfoReference");
        XMLObject target = ref.resolveIDFromRoot(ref.getURI().substring(1));
        if (target == null) {
            this.log.warn("KeyInfoReference URI could not be dereferenced");
            return null;
        }
        if (!(target instanceof KeyInfo)) {
            this.log.warn("The product of dereferencing the KeyInfoReference was not a KeyInfo");
            return null;
        }
        if (!((KeyInfo)target).getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME).isEmpty()) {
            this.log.warn("The dereferenced KeyInfo contained a KeyInfoReference, cannot process");
            return null;
        }
        this.log.debug("Recursively processing KeyInfoReference referent");
        CriteriaSet newCriteria = new CriteriaSet();
        newCriteria.add(new KeyInfoCriteria((KeyInfo)target));
        for (Criteria crit : criteriaSet) {
            if (crit instanceof KeyInfoCriteria) continue;
            newCriteria.add(crit);
        }
        Iterable creds = resolver2.resolve(newCriteria);
        if (creds != null) {
            ArrayList<Credential> result = new ArrayList<Credential>();
            for (Credential c : creds) {
                result.add(c);
            }
            return result;
        }
        return null;
    }

    protected KeyInfoReference getKeyInfoReference(XMLObject xmlObject) {
        if (xmlObject instanceof KeyInfoReference) {
            KeyInfoReference ref = (KeyInfoReference)xmlObject;
            String uri = ref.getURI();
            if (uri != null && uri.startsWith("#")) {
                return ref;
            }
            this.log.debug("KeyInfoReference did not contain a same-document URI reference, cannot handle");
        }
        return null;
    }
}

