/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.transport;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.saml.opensaml.integration.internal.transport.configuration.HttpClientFactoryConfiguration;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.saml.opensaml.integration.internal.transport.configuration.HttpClientFactoryConfiguration"}, immediate=true, service={HttpClientFactory.class})
public class HttpClientFactory {
    private static final Log _log = LogFactoryUtil.getLog(HttpClientFactory.class);
    private CloseableHttpClient _closeableHttpClient;
    private ServiceRegistration<HttpClient> _httpClientServiceRegistration;
    private PoolingHttpClientConnectionManager _poolingClientConnectionManager;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this._poolingClientConnectionManager = new PoolingHttpClientConnectionManager();
        HttpClientFactoryConfiguration httpClientFactoryConfiguration = (HttpClientFactoryConfiguration)ConfigurableUtil.createConfigurable(HttpClientFactoryConfiguration.class, properties);
        this._poolingClientConnectionManager.setDefaultMaxPerRoute(httpClientFactoryConfiguration.defaultMaxConnectionsPerRoute());
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(httpClientFactoryConfiguration.soTimeout());
        this._poolingClientConnectionManager.setDefaultSocketConfig(socketConfigBuilder.build());
        this._poolingClientConnectionManager.setMaxTotal(httpClientFactoryConfiguration.maxTotalConnections());
        httpClientBuilder.setConnectionManager(this._poolingClientConnectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(httpClientFactoryConfiguration.connectionManagerTimeout());
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        this._closeableHttpClient = httpClientBuilder.build();
        this._httpClientServiceRegistration = bundleContext.registerService(HttpClient.class, (Object)this._closeableHttpClient, null);
    }

    @Deactivate
    protected void deactivate() {
        PoolStats poolStats;
        int availableConnections;
        block11: {
            if (this._closeableHttpClient != null) {
                try {
                    this._closeableHttpClient.close();
                }
                catch (IOException ioe) {
                    if (!_log.isDebugEnabled()) break block11;
                    _log.debug((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (this._httpClientServiceRegistration != null) {
            this._httpClientServiceRegistration.unregister();
            this._httpClientServiceRegistration = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Shutting down " + this.getClass().getName()));
        }
        if (this._poolingClientConnectionManager == null) {
            return;
        }
        for (int retry = 0; retry < 10 && (availableConnections = (poolStats = this._poolingClientConnectionManager.getTotalStats()).getAvailable()) > 0; ++retry) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{this.getClass().getName(), " is waiting on ", String.valueOf(availableConnections), " connections"}));
            }
            this._poolingClientConnectionManager.closeIdleConnections(200L, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._poolingClientConnectionManager.shutdown();
        this._poolingClientConnectionManager = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this.toString() + " was shut down"));
        }
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }
}

