/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.runtime.configuration.MetadataUtilConfiguration;
import com.liferay.saml.util.MetadataUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.XMLObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.MetadataUtilConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={MetadataUtil.class})
public class MetadataUtilImpl
implements MetadataUtil {
    @Reference
    protected ParserPool parserPool;
    private static final Log _log = LogFactoryUtil.getLog(MetadataUtilImpl.class);
    private HttpClient _httpClient;
    private ServiceRegistration<HttpClient> _httpClientServiceRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getMetadata(String url) {
        GetMethod getMethod = new GetMethod(url);
        DefaultHttpMethodRetryHandler httpMethodRetryHandler = new DefaultHttpMethodRetryHandler(0, true);
        HttpMethodParams httpMethodParams = getMethod.getParams();
        httpMethodParams.setParameter("http.method.retry-handler", (Object)httpMethodRetryHandler);
        try {
            this._httpClient.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() != 200) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = getMethod.getResponseBodyAsStream();
            Header header = getMethod.getResponseHeader("Content-Encoding");
            if (header != null) {
                String contentEncoding = header.getValue();
                if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"deflate")) {
                    inputStream = new InflaterInputStream(inputStream);
                } else if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                }
            }
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
            byte[] bytes = unsyncByteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get SAML metadata from " + url), (Throwable)e);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get SAML metadata from " + url + ": " + e.getMessage()));
            }
        }
        finally {
            getMethod.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseMetadataXml(InputStream inputStream, String entityId) throws Exception {
        String string;
        block6: {
            EntityDescriptor entityDescriptor;
            block4: {
                String string2;
                block5: {
                    try {
                        XMLObject xmlObject = XMLObjectHelper.unmarshallFromInputStream(this.parserPool, inputStream);
                        entityDescriptor = SamlUtil.getEntityDescriptorById(entityId, xmlObject);
                        if (entityDescriptor != null) break block4;
                        string2 = null;
                        if (inputStream == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        }
                        throw throwable;
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                }
                return string2;
            }
            StringWriter stringWriter = new StringWriter();
            XMLObjectHelper.marshallToWriter(entityDescriptor, stringWriter);
            string = stringWriter.toString();
            if (inputStream == null) break block6;
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        return string;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        MetadataUtilConfiguration metadataUtilConfiguration = (MetadataUtilConfiguration)ConfigurableUtil.createConfigurable(MetadataUtilConfiguration.class, properties);
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setConnectionManagerTimeout((long)metadataUtilConfiguration.getConnectionManagerTimeout());
        httpClientParams.setSoTimeout(metadataUtilConfiguration.getSoTimeout());
        this._httpClient = new HttpClient(httpClientParams, (HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this._httpClientServiceRegistration = bundleContext.registerService(HttpClient.class, (Object)this._httpClient, null);
    }

    @Deactivate
    protected void deactivate() {
        this._httpClientServiceRegistration.unregister();
    }
}

