/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.transport;

import com.liferay.saml.opensaml.integration.internal.transport.OutputStreamRequestEntity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.security.credential.Credential;

public class HttpClientOutTransport
implements HTTPOutTransport {
    private final PostMethod _postMethod;

    public HttpClientOutTransport(PostMethod postMethod) {
        this._postMethod = postMethod;
    }

    @Override
    public void addParameter(String name, String value) {
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        NameValuePair nameValuePair = this._postMethod.getParameter("http.protocol.content-charset");
        return nameValuePair.getValue();
    }

    @Override
    public String getHeaderValue(String name) {
        Header header = this._postMethod.getRequestHeader(name);
        return header.getValue();
    }

    @Override
    public String getHTTPMethod() {
        NameValuePair nameValuePair = this._postMethod.getParameter("http.protocol.version");
        return nameValuePair.getValue();
    }

    @Override
    public Credential getLocalCredential() {
        return null;
    }

    @Override
    public OutputStream getOutgoingStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamRequestEntity requestEntity = new OutputStreamRequestEntity(byteArrayOutputStream);
        this._postMethod.setRequestEntity((RequestEntity)requestEntity);
        return byteArrayOutputStream;
    }

    @Override
    public String getParameterValue(String name) {
        return null;
    }

    @Override
    public List<String> getParameterValues(String name) {
        return null;
    }

    @Override
    public Credential getPeerCredential() {
        return null;
    }

    public PostMethod getPostMethod() {
        return this._postMethod;
    }

    @Override
    public int getStatusCode() {
        return -1;
    }

    @Override
    public HTTPTransport.HTTP_VERSION getVersion() {
        HttpMethodParams httpMethodParams = this._postMethod.getParams();
        HttpVersion httpVersion = (HttpVersion)httpMethodParams.getParameter("http.protocol.version");
        if (httpVersion == HttpVersion.HTTP_1_1) {
            return HTTPTransport.HTTP_VERSION.HTTP1_1;
        }
        return HTTPTransport.HTTP_VERSION.HTTP1_0;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isConfidential() {
        try {
            URI uri = this._postMethod.getURI();
            String scheme = uri.getScheme();
            if (scheme.equals("https")) {
                return true;
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isIntegrityProtected() {
        return false;
    }

    @Override
    public void sendRedirect(String redirect) {
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public void setAuthenticated(boolean uthenticated) {
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        HttpMethodParams httpMethodParams = this._postMethod.getParams();
        httpMethodParams.setParameter("http.protocol.content-charset", (Object)characterEncoding);
    }

    @Override
    public void setConfidential(boolean confidential) {
    }

    @Override
    public void setHeader(String name, String value) {
        this._postMethod.setRequestHeader(name, value);
    }

    @Override
    public void setIntegrityProtected(boolean integrityProtected) {
    }

    @Override
    public void setStatusCode(int statusCode) {
    }

    @Override
    public void setVersion(HTTPTransport.HTTP_VERSION httpVersion) {
        HttpMethodParams httpParams = this._postMethod.getParams();
        if (httpVersion.equals((Object)HTTPTransport.HTTP_VERSION.HTTP1_0)) {
            httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        } else if (httpVersion.equals((Object)HTTPTransport.HTTP_VERSION.HTTP1_1)) {
            httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        }
    }
}

