/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.opensaml.integration.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={AttributeResolver.class})
public class DefaultAttributeResolver
implements AttributeResolver {
    private static final String _SALESFORCE_ENTITY_ID = "https://saml.salesforce.com";
    private static final Log _log = LogFactoryUtil.getLog(DefaultAttributeResolver.class);
    private GroupLocalService _groupLocalService;
    private MetadataManager _metadataManager;
    private RoleLocalService _roleLocalService;
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    @Override
    public List<Attribute> resolve(User user, SAMLMessageContext<?, ?, ?> samlMessageContext) {
        List<Attribute> salesForceAttributes;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String entityId = samlMessageContext.getPeerEntityId();
        boolean namespaceEnabled = this._metadataManager.isAttributesNamespaceEnabled(samlMessageContext.getPeerEntityId());
        for (String attributeName : this.getAttributeNames(entityId)) {
            if (attributeName.startsWith("expando:")) {
                attributeName = attributeName.substring(8);
                this.addExpandoAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("groups")) {
                this.addGroupsAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizations")) {
                this.addOrganizationsAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("organizationRoles")) {
                this.addOrganizationRolesAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("roles")) {
                this.addRolesAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.startsWith("static:")) {
                attributeName = attributeName.substring(7);
                this.addStaticAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("siteRoles") || attributeName.equals("userGroupRoles")) {
                this.addSiteRolesAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            if (attributeName.equals("userGroups")) {
                this.addUserGroupsAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
                continue;
            }
            this.addUserAttribute(user, samlMessageContext, attributes, attributeName, namespaceEnabled);
        }
        if (this.isPeerSalesForce(entityId) && !(salesForceAttributes = this.getSalesForceAttributes(samlMessageContext)).isEmpty()) {
            attributes.addAll(salesForceAttributes);
        }
        return attributes;
    }

    @Reference(unbind="-")
    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    public void setMetadataManager(MetadataManager metadataManager) {
        this._metadataManager = metadataManager;
    }

    @Reference(unbind="-")
    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    public void setUserGroupGroupRoleLocalService(UserGroupGroupRoleLocalService userGroupGroupRoleLocalService) {
        this._userGroupGroupRoleLocalService = userGroupGroupRoleLocalService;
    }

    @Reference(unbind="-")
    public void setUserGroupRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        this._userGroupRoleLocalService = userGroupRoleLocalService;
    }

    protected void addExpandoAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        Attribute attribute = null;
        ExpandoBridge expandoBridge = user.getExpandoBridge();
        Serializable value = expandoBridge.getAttribute(attributeName, false);
        attribute = !namespaceEnabled ? OpenSamlUtil.buildAttribute(attributeName, value) : OpenSamlUtil.buildAttribute("urn:liferay:user:expando:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", value);
        attributes.add(attribute);
    }

    protected void addGroupsAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            List groups = user.getGroups();
            if (groups.isEmpty()) {
                return;
            }
            Attribute attribute = OpenSamlUtil.buildAttribute();
            if (namespaceEnabled) {
                attribute.setName("urn:liferay:groups");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            } else {
                attribute.setName("groups");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            }
            List<XMLObject> xmlObjects = attribute.getAttributeValues();
            for (Group group : groups) {
                XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(group.getName());
                xmlObjects.add(xmlObject);
            }
            attributes.add(attribute);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get groups for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected void addOrganizationRolesAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, HashSet<Role>> groupRoles = new HashMap<String, HashSet<Role>>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Group group = userGroupRole.getGroup();
                Role role = userGroupRole.getRole();
                if (role.getType() != 3) continue;
                HashSet<Role> roles = (HashSet<Role>)groupRoles.get(group.getName());
                if (roles == null) {
                    roles = new HashSet<Role>();
                    groupRoles.put(group.getName(), roles);
                }
                roles.add(userGroupRole.getRole());
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                Set roles = (Set)entry.getValue();
                Attribute attribute = OpenSamlUtil.buildAttribute();
                if (namespaceEnabled) {
                    attribute.setName("urn:liferay:organizationRole:" + groupName);
                    attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
                } else {
                    attribute.setName("organizationRole:" + groupName);
                    attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
                }
                List<XMLObject> xmlObjects = attribute.getAttributeValues();
                for (Role role : roles) {
                    XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(role.getName());
                    xmlObjects.add(xmlObject);
                }
                attributes.add(attribute);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get organization roles for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected void addOrganizationsAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            List organizations = user.getOrganizations();
            if (organizations.isEmpty()) {
                return;
            }
            Attribute attribute = OpenSamlUtil.buildAttribute();
            if (namespaceEnabled) {
                attribute.setName("urn:liferay:organizations");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            } else {
                attribute.setName("organizations");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            }
            List<XMLObject> xmlObjects = attribute.getAttributeValues();
            for (Organization organization : organizations) {
                XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(organization.getName());
                xmlObjects.add(xmlObject);
            }
            attributes.add(attribute);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get organizations for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected void addRolesAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            List roles = user.getRoles();
            List groups = user.getGroups();
            List organizations = user.getOrganizations();
            List userGroups = user.getUserGroups();
            List inheritedSiteGroups = this._groupLocalService.getUserGroupsRelatedGroups(userGroups);
            List organizationsRelatedGroups = Collections.emptyList();
            if (!organizations.isEmpty()) {
                organizationsRelatedGroups = this._groupLocalService.getOrganizationsRelatedGroups(organizations);
                for (Group group : organizationsRelatedGroups) {
                    if (inheritedSiteGroups.contains(group)) continue;
                    inheritedSiteGroups.add(group);
                }
            }
            ArrayList allGroups = new ArrayList();
            allGroups.addAll(groups);
            allGroups.addAll(inheritedSiteGroups);
            allGroups.addAll(organizationsRelatedGroups);
            allGroups.addAll(this._groupLocalService.getOrganizationsGroups(organizations));
            allGroups.addAll(this._groupLocalService.getUserGroupsGroups(userGroups));
            HashSet uniqueRoles = new HashSet();
            uniqueRoles.addAll(roles);
            for (Group group : allGroups) {
                if (!this._roleLocalService.hasGroupRoles(group.getGroupId())) continue;
                List groupRoles = this._roleLocalService.getGroupRoles(group.getGroupId());
                uniqueRoles.addAll(groupRoles);
            }
            if (uniqueRoles.isEmpty()) {
                return;
            }
            Attribute attribute = OpenSamlUtil.buildAttribute();
            if (namespaceEnabled) {
                attribute.setName("urn:liferay:roles");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            } else {
                attribute.setName("roles");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            }
            List<XMLObject> xmlObjects = attribute.getAttributeValues();
            for (Role role : uniqueRoles) {
                XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(role.getName());
                xmlObjects.add(xmlObject);
            }
            attributes.add(attribute);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get roles for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected void addSiteRolesAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            Set roles;
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
            HashMap<String, HashSet<Role>> groupRoles = new HashMap<String, HashSet<Role>>();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Group group = userGroupRole.getGroup();
                Role role = userGroupRole.getRole();
                if (role.getType() == 3 && !attributeName.equals("userGroupRoles")) continue;
                roles = (HashSet<Role>)groupRoles.get(group.getName());
                if (roles == null) {
                    roles = new HashSet<Role>();
                    groupRoles.put(group.getName(), (HashSet<Role>)roles);
                }
                roles.add(userGroupRole.getRole());
            }
            List inheritedSiteRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByUser(user.getUserId());
            for (UserGroupGroupRole userGroupGroupRole : inheritedSiteRoles) {
                Group group = userGroupGroupRole.getGroup();
                Role role = userGroupGroupRole.getRole();
                HashSet<Role> roles2 = (HashSet<Role>)groupRoles.get(group.getName());
                if (roles2 == null) {
                    roles2 = new HashSet<Role>();
                    groupRoles.put(group.getName(), roles2);
                }
                roles2.add(role);
            }
            for (Map.Entry entry : groupRoles.entrySet()) {
                String groupName = (String)entry.getKey();
                roles = (Set)entry.getValue();
                Attribute attribute = OpenSamlUtil.buildAttribute();
                if (namespaceEnabled) {
                    if (attributeName.equals("siteRoles")) {
                        attribute.setName("urn:liferay:siteRole:" + groupName);
                    } else {
                        attribute.setName("urn:liferay:userGroupRole:" + groupName);
                    }
                    attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
                } else {
                    if (attributeName.equals("siteRoles")) {
                        attribute.setName("siteRole:" + groupName);
                    } else {
                        attribute.setName("userGroupRole:" + groupName);
                    }
                    attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
                }
                List<XMLObject> xmlObjects = attribute.getAttributeValues();
                for (Role role : roles) {
                    XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(role.getName());
                    xmlObjects.add(xmlObject);
                }
                attributes.add(attribute);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get user group roles for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected void addStaticAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        String attributeValue = "";
        if (attributeName.indexOf(61) > 0) {
            String[] values = StringUtil.split((String)attributeName, (String)"=");
            attributeName = values[0];
            attributeValue = values[1];
            if (values.length > 2) {
                for (int i = 2; i < values.length; ++i) {
                    attributeValue = attributeValue.concat("=").concat(values[i]);
                }
            }
        }
        Attribute attribute = OpenSamlUtil.buildAttribute(attributeName, (Serializable)((Object)attributeValue));
        if (namespaceEnabled) {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        } else {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        }
        attributes.add(attribute);
    }

    protected void addUserAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        Attribute attribute = null;
        Serializable value = (Serializable)BeanPropertiesUtil.getObject((Object)user, (String)attributeName);
        attribute = !namespaceEnabled ? OpenSamlUtil.buildAttribute(attributeName, value) : OpenSamlUtil.buildAttribute("urn:liferay:user:" + attributeName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", value);
        attributes.add(attribute);
    }

    protected void addUserGroupsAttribute(User user, SAMLMessageContext<?, ?, ?> samlMessageContext, List<Attribute> attributes, String attributeName, boolean namespaceEnabled) {
        try {
            List userGroups = user.getUserGroups();
            if (userGroups.isEmpty()) {
                return;
            }
            Attribute attribute = OpenSamlUtil.buildAttribute();
            if (namespaceEnabled) {
                attribute.setName("urn:liferay:userGroups");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            } else {
                attribute.setName("userGroups");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            }
            List<XMLObject> xmlObjects = attribute.getAttributeValues();
            for (UserGroup userGroup : userGroups) {
                XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(userGroup.getName());
                xmlObjects.add(xmlObject);
            }
            attributes.add(attribute);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get user groups for user " + user.getUserId()), (Throwable)e);
        }
    }

    protected String[] getAttributeNames(String entityId) {
        return this._metadataManager.getAttributeNames(entityId);
    }

    protected List<Attribute> getSalesForceAttributes(SAMLMessageContext<?, ?, ?> samlMessageContext) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String samlIdpMetadataSalesForceLogoutUrl = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.logout.url"));
        Attribute logoutURLAttribute = OpenSamlUtil.buildAttribute("logoutURL", (Serializable)((Object)samlIdpMetadataSalesForceLogoutUrl));
        attributes.add(logoutURLAttribute);
        String samlIdpMetadataSalesForceSsoStartPage = GetterUtil.getString((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.sso.start.page"));
        try {
            IDPSSODescriptor idpSsoDescriptor = (IDPSSODescriptor)samlMessageContext.getLocalEntityRoleMetadata();
            SingleSignOnService singleSignOnService = SamlUtil.getSingleSignOnServiceForBinding(idpSsoDescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            samlIdpMetadataSalesForceSsoStartPage = singleSignOnService.getLocation();
        }
        catch (MetadataProviderException idpSsoDescriptor) {
            // empty catch block
        }
        Attribute ssoStartPageAattribute = OpenSamlUtil.buildAttribute("ssoStartPage", (Serializable)((Object)samlIdpMetadataSalesForceSsoStartPage));
        attributes.add(ssoStartPageAattribute);
        return attributes;
    }

    protected boolean isPeerSalesForce(String entityId) {
        if (entityId.equals(_SALESFORCE_ENTITY_ID)) {
            return true;
        }
        return GetterUtil.getBoolean((String)PropsUtil.get((String)"saml.idp.metadata.salesforce.attributes.enabled", (Filter)new Filter(entityId)));
    }
}

