/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.credential.BaseKeyStoreManagerImpl;
import com.liferay.saml.opensaml.integration.internal.credential.FileWatcher;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, immediate=true, property={"default=true"}, service={KeyStoreManager.class})
public class FileSystemKeyStoreManagerImpl
extends BaseKeyStoreManagerImpl {
    private static final Log _log = LogFactoryUtil.getLog(FileSystemKeyStoreManagerImpl.class);
    private KeyStore _keyStore;
    private volatile FileWatcher _samlKeyStoreFileWatcher;

    @Activate
    public void activate(Map<String, Object> properties) throws Exception {
        this.updateConfigurations(properties);
        String samlKeyStoreType = this.getSamlKeyStoreType();
        try {
            this._keyStore = KeyStore.getInstance(samlKeyStoreType);
        }
        catch (KeyStoreException kse) {
            _log.error((Object)("Unable instantiate keystore with type " + samlKeyStoreType), (Throwable)kse);
            return;
        }
        this.loadKeyStore();
    }

    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    public void saveKeyStore(KeyStore keyStore) throws Exception {
        String samlKeyStorePath = this.getSamlKeyStorePath();
        File samlKeyStoreFile = new File(samlKeyStorePath);
        if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
            File parentDir;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Creating a new SAML keystore at " + samlKeyStoreFile));
            }
            if (!(parentDir = samlKeyStoreFile.getParentFile()).exists()) {
                parentDir.mkdirs();
            }
        }
        this.monitorFile(samlKeyStoreFile);
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        try (FileOutputStream fileOutputStream = new FileOutputStream(samlKeyStoreFile);){
            this._keyStore.store(fileOutputStream, samlKeyStorePassword.toCharArray());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._samlKeyStoreFileWatcher == null) {
            return;
        }
        try {
            this._samlKeyStoreFileWatcher.close();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to close file watcher", (Throwable)e);
            }
        }
        finally {
            this._samlKeyStoreFileWatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadKeyStore() throws Exception {
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        String samlKeyStorePath = this.getSamlKeyStorePath();
        InputStream inputStream = null;
        if (samlKeyStorePath.startsWith("classpath:")) {
            Class<?> clazz = this.getClass();
            inputStream = clazz.getResourceAsStream(samlKeyStorePath.substring(10));
        } else {
            File samlKeyStoreFile = new File(samlKeyStorePath);
            if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
                this._keyStore.load(null, samlKeyStorePassword.toCharArray());
                if (Validator.isNotNull((String)this.samlConfiguration.keyStorePath()) && !"${liferay.home}/data/keystore.jks".equals(this.samlConfiguration.keyStorePath()) && _log.isWarnEnabled()) {
                    _log.warn((Object)("No SAML keystore exists at " + samlKeyStoreFile));
                }
                return;
            }
            this.monitorFile(samlKeyStoreFile);
            inputStream = new FileInputStream(samlKeyStoreFile);
        }
        try {
            this._keyStore.load(inputStream, samlKeyStorePassword.toCharArray());
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void loadKeyStore() {
        try {
            this.doLoadKeyStore();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to load SAML keystore " + this.getSamlKeyStorePath()), (Throwable)e);
        }
    }

    protected void monitorFile(File samlKeyStoreFile) throws IOException {
        if (this._samlKeyStoreFileWatcher != null) {
            return;
        }
        this._samlKeyStoreFileWatcher = new FileWatcher(ev -> this.loadKeyStore(), samlKeyStoreFile.toPath());
    }
}

