# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{compass-import-once}
  s.version = "1.0.5"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = [%q{Chris Eppstein}]
  s.date = %q{2014-08-04}
  s.description = %q{Changes the behavior of Sass's @import directive to only import a file once.}
  s.email = [%q{chris@eppsteins.net}]
  s.homepage = %q{https://github.com/chriseppstein/compass/tree/master/import-once}
  s.licenses = [%q{MIT}]
  s.require_paths = [%q{lib}]
  s.rubygems_version = %q{1.8.9}
  s.summary = %q{Speed up your Sass compilation by making @import only import each file once.}

  if s.respond_to? :specification_version then
    s.specification_version = 4

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<sass>, ["< 3.5", ">= 3.2"])
      s.add_development_dependency(%q<bundler>, ["~> 1.3"])
      s.add_development_dependency(%q<diff-lcs>, [">= 0"])
      s.add_development_dependency(%q<rake>, [">= 0"])
      s.add_development_dependency(%q<sass-globbing>, [">= 0"])
    else
      s.add_dependency(%q<sass>, ["< 3.5", ">= 3.2"])
      s.add_dependency(%q<bundler>, ["~> 1.3"])
      s.add_dependency(%q<diff-lcs>, [">= 0"])
      s.add_dependency(%q<rake>, [">= 0"])
      s.add_dependency(%q<sass-globbing>, [">= 0"])
    end
  else
    s.add_dependency(%q<sass>, ["< 3.5", ">= 3.2"])
    s.add_dependency(%q<bundler>, ["~> 1.3"])
    s.add_dependency(%q<diff-lcs>, [">= 0"])
    s.add_dependency(%q<rake>, [">= 0"])
    s.add_dependency(%q<sass-globbing>, [">= 0"])
  end
end
