/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.remote.app.internal.upgrade.v2_3_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Javier de Arcos
 */
public class RemoteAppEntryUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (!hasColumn("RemoteAppEntry", "description")) {
			alterTableAddColumn("RemoteAppEntry", "description", "TEXT null");
		}

		if (!hasColumn("RemoteAppEntry", "sourceCodeURL")) {
			alterTableAddColumn(
				"RemoteAppEntry", "sourceCodeURL", "STRING null");
		}

		if (!hasColumn("RemoteAppEntry", "status")) {
			alterTableAddColumn("RemoteAppEntry", "status", "INTEGER");

			runSQL("update RemoteAppEntry set status = 0 where status is null");
		}

		if (!hasColumn("RemoteAppEntry", "statusByUserId")) {
			alterTableAddColumn("RemoteAppEntry", "statusByUserId", "LONG");

			runSQL(
				"update RemoteAppEntry set statusByUserId = userId where " +
					"statusByUserId is null");
		}

		if (!hasColumn("RemoteAppEntry", "statusByUserName")) {
			alterTableAddColumn(
				"RemoteAppEntry", "statusByUserName", "VARCHAR(75)");

			runSQL(
				"update RemoteAppEntry set statusByUserName = (select " +
					"screenName from User_ where RemoteAppEntry.userId = " +
						"User_.userId)");
		}

		if (!hasColumn("RemoteAppEntry", "statusDate")) {
			alterTableAddColumn("RemoteAppEntry", "statusDate", "DATE");

			runSQL(
				"update RemoteAppEntry set statusDate = modifiedDate where " +
					"statusDate is null");
		}
	}

}